require 'strongtyping'
include StrongTyping

##
## Examples
##

def foo(a, b, c)
  expect(a, String, b, Integer, c, String)
  print "#{a} found #{b} #{c}\n"
end

def optional(a, b = nil)
  expect(a, Integer, b, [Integer, NilClass])
  return a + b   if b
  return a
end


# Silly example since + works for both and the function isn't too
# useful, but demonstrates it works
def add (*args)
  overload(args) {
    print "Nothing to do\n"
    return
  }
  
  overload(args, Integer, Integer) {
    | a, b |
    print "Two ints: a + b = ", a + b, "\n"
    return
  }
  
  overload(args, String, String) {
    | a, b |
    print "Two strings: concat(a, b) = \"", a + b, "\"\n"
    return
  }

  overload_exception(args, String, Integer) {
    | a, b |
    raise ArgumentError.new "I'm not going there."
  }

  overload_default args
end

#########################################################################
#
# expect
#
print "Testing: expect()\n"
begin
  foo("hello", 2, 3)
rescue ArgumentTypeError => e
  p e
end

begin
  print "optional(1): ",    optional(1),    "\n"
  print "optional(1, 2): ", optional(1, 2), "\n"
  print "optional(1, 'abc'):\n"
  optional(1, 'abc')
rescue ArgumentTypeError => e
  p e
end


#########################################################################
#
# overload
#
print "\nTesting: overload()\n"
begin
  add
  add 1, 2
  add "a", "b"
  add "a", 2
rescue ArgumentError => e
  p e
end


#########################################################################
#
# get_arg_types
#
print "\nTesting: get_arg_types()\n"
p get_arg_types method(:foo)
p get_arg_types method(:optional)
p get_arg_types method(:add)


#########################################################################
#
# verify_args_for
#
print "\nTesting: verify_args_for()\n"
a1 = [1, 2]
a2 = ["a", 2]

p verify_args_for(method(:add), a1)
p verify_args_for(method(:add), a2)
