=begin
=TC_Tuner.rb
Test for the Tuner class, a utility for generic publish/subscirbe.
=end

#<standard_header>
#
# Copyright (C) 2000-2001 Nathaniel Talbott
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#</standard_header>

require 'Lapidary/TestCase'
require 'Lapidary/UI/Util/Tuner'

module Lapidary
	module UI
		module Util
			class TC_Tuner < TestCase
				def setup
					@tuner = Tuner.new
				end
				def testListenerHandling
					channel1Listener1Called = false
					channel1Listener1 = proc { channel1Listener1Called = true }
					@tuner.addListener("channel1", channel1Listener1)
					@tuner.update("channel1")
					assert(channel1Listener1Called, "The listener should have been called")
					
					channel1Listener1Called, channel2Listener1Called = false, false
					channel2Listener1 = proc { channel2Listener1Called = true }
					@tuner.addListener("channel2", channel2Listener1)
					@tuner.update("channel2")
					assert(channel2Listener1Called, "The channel2 listener1 should have been called")
					assert(!channel1Listener1Called, "The channel1 listener1 should not have been called")

					channel1Listener1Called, channel2Listener1Called, channel1Listener2Called = false, false, false
					channel1Listener2 = proc { channel1Listener2Called = true }
					@tuner.addListener("channel1", channel1Listener2)
					@tuner.update("channel1")
					assert(channel1Listener1Called && channel1Listener2Called, "The channel1 listener1 and listener2 should have been called")
					assert(!channel2Listener1Called, "The channel2 listener1 should not have been called")

					channel1Listener1Called, channel2Listener1Called, channel1Listener2Called = false, false, false
					@tuner.removeListener("channel1", channel1Listener1)
					@tuner.update("channel1")
					assert(channel1Listener2Called, "The channel1 listener2 should have been called")
					assert(! (channel1Listener1Called || channel2Listener1Called), "The channel1 and channel2 listener1's should not have been called")

					channel1Listener1Called, channel2Listener1Called, channel1Listener2Called = false, false, false
					@tuner.update("channel2")
					assert(channel2Listener1Called, "The channel2 listener1 should have been called")
					assert(! (channel1Listener1Called || channel1Listener2Called), "The channel1 listener1 and listener2 should not have been called")

					channel1Listener1Called, channel2Listener1Called, channel1Listener2Called = false, false, false
					@tuner.removeListener("channel1", channel1Listener2)
					@tuner.removeListener("channel2", channel2Listener1)
					@tuner.update("channel1")
					@tuner.update("channel2")
					assert( !(channel1Listener1Called || channel2Listener1Called || channel1Listener2Called), "No listeners should have been called")
				end
				def testUpdate
					expectedContent = nil
					listener1Called, listener2Called = false, false
					@tuner.addListener("channel1", proc {
						| content |
						assertEqual(expectedContent, content)
						listener1Called = true
					} )
					@tuner.addListener("channel1", proc {
						listener2Called = true
					} )
					@tuner.update("channel1")
					assert(listener1Called && listener2Called, "Should have called both listeners")
					
					expectedContent = "thing"
					listener1Called, listener2Called = false, false		
					@tuner.update("channel1", "thing")
					assert(listener1Called && listener2Called, "Should have called both listeners")
				end
			end
		end
	end
end
