require "dpklib/class"

module Misen
  class Style
    include Dpklib::OnceMethod

    def block_begin_regexp
      Dpklib.implemented_by_subclass
    end

    def block_end_regexp
      Dpklib.implemented_by_subclass
    end

    def inline_regexp
      Dpklib.implemented_by_subclass
    end

    def block_get_identifier(matches)
      Dpklib.implemented_by_subclass
    end

    def inline_get_identifier(matches)
      Dpklib.implemented_by_subclass
    end

    def inline_format(string)
      string
    end

    def extended_inlines
      []
    end

    def inline_styles
      inline_names = ["inline"] + extended_inlines
      inline_names.collect { |inline_name|
        inline_style = InlineStyle.new
        inline_style.name = inline_name
        inline_style.regexp =
          __send__("#{inline_name}_regexp")
        inline_style.identifier_get_proc =
          method("#{inline_name}_get_identifier").to_proc

        format_method = begin
                          method("#{inline_name}_format")
                        rescue NameError
                          method(:inline_format)
                        end
        inline_style.format_proc = format_method.to_proc

        inline_style
      }
    end
    once_method :inline_styles
  end #/Style

  class InlineStyle
    attr_accessor :name, :regexp, :identifier_get_proc, :format_proc
    def get_identifier(matches)
      @identifier_get_proc[[matches]]
    end

    def format(string)
      @format_proc[string]
    end
  end #/InlineStyle

  class SgmlStyle < Style
    IDENT_RE = "[A-Za-z0-9_]+"

    def block_begin_regexp
      %r"<misen:(#{IDENT_RE})>"o
    end

    def block_end_regexp
      %r"</misen:#{IDENT_RE}>"o
    end

    def inline_regexp
      %r"<misen:(#{IDENT_RE}) */>"o
    end

    def block_get_identifier(matches)
      matches[1]
    end
    alias inline_get_identifier block_get_identifier
  end #/SgmlStyle
  STYLE_SGML = SgmlStyle.new

  class << self
    def inline_style_for_name(style, name)
      style.inline_styles.find { |inline_style|
        name == inline_style.name
      }
    end
  end #/<< self
end #/Misen
