# -*- ruby -*-
#
# Using a dummy node.
#

require 'xtemplate'

data = {
  'members' => [
    {'name' => 'name1', '@uid' => 1},              # has no 'age' field.
    {'name' => 'name2', 'age' => 22, '@uid' => 2},
    {'name' => 'name3', 'age' => 23, '@uid' => 3},
  ],
}

text = <<EOF
<?xml version="1.0" encoding="EUC-JP"?>
<members>
  <!-- 'age' tag is eliminated, if data has no 'age' field. -->
  <member id="members">
     <name id="name" />
     <age id="age" />
  </member>

  <!-- 'age' tag is not eliminated. -->
  <member id="members">
     <name id="name" />
     <age xmlns:xt="http://xtemplate.sourceforge.net/xtemplate"><xt:select id="age" /></age>
  </member>
</members>
EOF

t = XTemplate::XMLTemplate.new(text)
print(t.expand(data))
