# -*- ruby -*-
#
# Replacing a sub-template with another sub-template.
#

require 'xtemplate'

data ={
  'names' => ["name1", "name2", "name3"]
}

text1 = <<EOF
<?xml version="1.0"?>
<html xmlns:xt="#{XTemplate::BIND_URI}">
<body>
  <xt:template name="ul">
  <ul>
    <li xt:id="names" />
  </ul>
  </xt:template>
</body>
</html>
EOF

text2 = <<EOF
<?xml version="1.0"?>
<html xmlns:xt="#{XTemplate::BIND_URI}">
<body>
  <xt:template name="ol">
  <ol>
    <li xt:id="names" />
  </ol>
  </xt:template>
</body>
</html>
EOF

t1 = XTemplate::XMLTemplate.new(text1)
t2 = XTemplate::XMLTemplate.new(text2)
print(t1.expand(data, :keep_data => true),"\n")
t1['ul'] = t2['ol'].dup
print(t1.expand(data),"\n")
