# -*- ruby -*-
#
# Expanding a template with attributes.
#

require 'xtemplate'

data = {
  'members' => [
    {'name' => 'name1', 'age' => 21, 'uid' => 1},
    {'name' => 'name2', 'age' => 22, 'uid' => 2},
    {'name' => 'name3', 'age' => 23, 'uid' => 3},
  ],
}

text = <<EOF
<?xml version="1.0" encoding="EUC-JP"?>
<members>
  <member id="members" uid="A@{uid}" other="@@{uid}">
     <name id="name" uid="@{uid}" />
     <age id="age" />
     <comment>This entry is generated by xtemplate.</comment>
  </member>
</members>
EOF

t = XTemplate::XMLTemplate.new(text)
print(t.expand(data))
