# -*- ruby -*-
# Using YAML document

require 'xtemplate'
require 'xtemplate/yaml'

data = XTemplate::YAMLDocument.new(<<EOS)
links:
  - link:
    - url: url1
      name: name1
  - link:
    - url: url2
      name: name2
  - link:
    - url: url3
      name: name3
EOS

text = <<EOF
<?xml version="1.0" encoding="EUC-JP"?>
<html>
<body>
  <ul>
    <xt:select id="/links" xmlns:xt="http://xtemplate.sourceforge.net/xtemplate">
      <li><a xt:id="link{rename(url,@href);untag(name)}" /></li>
    </xt:select>
  </ul>
</body>
</html>
EOF

t = XTemplate::XMLTemplate.new(text)
print(t.expand(data))
