# You need RubyUnit and MS Excel and MSI to run this test script 

require 'rubyunit'

require 'win32ole'

class TestOLEVARIABLE < RUNIT::TestCase
  EXCEL_TYPELIB = 'Microsoft Excel 9.0 Object Library'
  XML_TYPELIB = 'Microsoft XML, version 2.0'
  def test_name
    classes = WIN32OLE_TYPE.ole_classes(EXCEL_TYPELIB)
    chart = classes.find {|c| c.name == 'XlChartType'}
    var_names = chart.variables.collect {|m| m.name}
    assert(var_names.size > 0)
    assert(var_names.include?('xl3DColumn'))
  end
  def test_ole_type
    classes = WIN32OLE_TYPE.ole_classes(EXCEL_TYPELIB)
    chart = classes.find {|c| c.name == 'XlChartType'}
    var = chart.variables.find {|m| m.name == 'xl3DColumn'}
    assert_equal('INT', var.ole_type)
  end
  def test_ole_type_detail
    classes = WIN32OLE_TYPE.ole_classes(EXCEL_TYPELIB)
    chart = classes.find {|c| c.name == 'XlChartType'}
    var = chart.variables.find {|m| m.name == 'xl3DColumn'}
    assert_equal(['INT'], var.ole_type_detail)
  end

  def test_value
    classes = WIN32OLE_TYPE.ole_classes(EXCEL_TYPELIB)
    chart = classes.find {|c| c.name == 'XlChartType'}
    var = chart.variables.find {|m| m.name == 'xl3DColumn'}
    assert_equal(-4100, var.value)
  end
  def test_visible
    classes = WIN32OLE_TYPE.ole_classes(EXCEL_TYPELIB)
    chart = classes.find {|c| c.name == 'XlChartType'}
    var = chart.variables.find {|m| m.name == 'xl3DColumn'}
    assert(var.visible?)
  end
end
