=begin
=RUNIT::Assert module

==Methods:

: assert(condition [,message])
      Raises RUNIT::AssertionFailedError if ((|condition|)) is (({false})) or (({nil})).
      If second argument specified, 
      raises RUNIT::AssertionFailedError with ((|message|)) string.

: assert_equal(expected, actual [,message])
      Raises RUNIT::AssertionFailedError if (({((|expected|)) != ((|actual|))})).
      If third argument specified, 
      raises RUNIT::AssertionFailedError with ((|message|)) string.

: assert_equal_float(expected, actual, eps [,message])
      Raises RUNIT::AssertionFailedError if (({(((|expected|)) - ((|actual|))).abs > ((|eps|))})).
      ((|eps|)) should be 0 or greater than 0.
      If 4th argument specified,
      raises RUNIT::AssertionFailedError with ((|message|)) string.

: assert_exception(expected [,message]){...}
      Raises RUNIT::AssertionFailedError if ((|expected|)) exception is not raised
      when block evaluated.
      If second argument specified,
      raises RUNIT::AssertionFailedError with ((|message|)) string.

: assert_fail(message)
      Raises RUNIT::AssertionFailedError with ((|message|)) string specified by argument.

: assert_instance_of(class, obj [,message])
      Raises RUNIT::AssertionFailedError if (({((|obj|)).instance_of?(((|class|)))})) is false.
      If third argument specified, 
      raises RUNIT::AssertionFailedError with ((|message|)) string.

: assert_kind_of(class, obj [,message])
      Raises RUNIT::AssertionFailedError if (({((|obj|)).kind_of?(((|class|)))})) is false.
      If third argument specified, 
      raises RUNIT::AssertionFailedError with ((|message|)) string.

: assert_match(str, re [,message])
      Raises RUNIT::AssertionFailedError if (({((|re|)) !~ ((|str|))})).
      If third argument specified, 
      raises RUNIT::AssertionFailedError with ((|message|)) string.

: assert_not_match(str, re [,message])
      Raises RUNIT::AssertionFailedError if (({((|re|)) =~ ((|str|))})).
      If third argument specified, 
      raises RUNIT::AssertionFailedError with ((|message|)) string.

: assert_nil(obj [,message])
      Raises RUNIT::AssertionFailedError if ((|obj|)) is not (({nil})).
      If second argument specified,
      raises RUNIT::AssertionFailedError with ((|message|)) string.

: assert_no_exception(expected1 [,expected2, expected3, ... ,message]) {...}
      Raises RUNIT::AssertionFailedError if the one of the exceptions 
      specified by argument is raised when block is evaluated.
      If ((|message|)) string specified,
      raises RUNIT::AssertionFailedError with ((|message|)) string.

: assert_not_nil(obj [,message])
      Raises RUNIT::AssertionFailedError if ((|obj|)) is (({nil})).
      If second argument specified,
      raises RUNIT::AssertionFailedError with ((|message|)) string.

: assert_operator(obj1, op, obj2 [,message])
      Raises RUNIT::AssertionFailedError if (({!((|obj1|)).send(((|op|)), ((|obj2|)))})).
      If fourth argument specified, 
      raises RUNIT::AssertionFailedError with ((|message|)) string.

: assert_respond_to(method, obj [,message])
      Raises RUNIT::AssertionFailedError if (({((|obj|)).respond_to?(((|method|)))})) is (({false})).
      If third argument specified,
      raises RUNIT::AssertionFailedError with ((|message|)) string.

: assert_same(expected, actual [,message])
      Raises RUNIT::AssertionFailedError if (({((|actual|)).equal?(((|expected|)))})) is (({false})).
      If third argument specified,
      raises RUNIT::AssertionFailedError with ((|message|)) string.
=end
