#!/usr/local/bin/ruby
require "dir-compare"
require "ftools"

class SameDir < DirPairRunner
  def initialize(ignore_time = false)
    @ignore_time = ignore_time
  end

  def file_lt_file(s, t)
    throw :differ, "#{s} < #{t} (#{s.mtime}, #{t.mtime})" unless @ignore_time
    throw :differ, "#{s} <!=  #{t}" unless File.compare(s.path, t.path)
  end

  def file_gt_file(s, t)
    throw :differ, "#{s} > #{t} (#{s.mtime}, #{t.mtime})" unless @ignore_time
    throw :differ, "#{s} >!=  #{t}" unless File.compare(s.path, t.path)
  end

  def file_eq_file(s, t)
    throw :differ, "#{s} !=  #{t}" unless File.compare(s.path, t.path)
  end

  def file_dir(s, t)
    throw :differ, "#{s} file:dir #{t}"
  end

  def file_non(s, t)
    throw :differ, "#{s} file:non #{t}"
  end

  def dir_file(s, t)
    throw :differ, "#{s} dir:file #{t}"
  end

  def dir_dir(s, t)
  end

  def dir_non(s, t)
    throw :differ, "#{s} dir:non #{t}"
  end

  def non_file(s, t)
    throw :differ, "#{s} non:file #{t}"
  end

  def non_dir(s, t)
    throw :differ, "#{s} non:dir #{t}"
  end

  def non_non(s, t)
  end
end

def find_diff(sdir, tdir, ignore_time = nil)
  target, source = [sdir, tdir].map{|x| x.sub(/\/$/, '')} #/
  visitor = SameDir.new(ignore_time)
  dc = DirCompare.new(visitor)
  catch(:differ) {
    dc.compare(target, source)
    nil
  }
end

if $0 == __FILE__
  if x = find_diff(ARGV.shift, ARGV.shift)
    puts "not same (#{x})"
  else
    puts "same"
  end
end
