#!/usr/bin/env ruby
#-*-ruby-*-
require "misen/util"

source = '
 <html>
  <body>
   <misen:groups>
    <h1><misen:title /></h1>
    <misen:no_data>
     <p>This group has no data.</p>
    </misen:no_data>
    <misen:one_data>
     <p>This group has only one data.: "<misen:data />"</p>
    </misen:one_data>
    <misen:many_data>
     <p>This group has multiple data.</p>
     <ul>
      <misen:list>
       <li><misen:content /></li>
      </misen:list>
     </ul>
    </misen:many_data>
   </misen:groups>
  </body>
 </html>
'
groups = []
groups << {:title => "Group A", :no_data => true}
groups << {:title => "Group B", :one_data => {:data => "only_one"}}

list = %w"one two three".collect { |content|
  {:content => content}
}
groups << {:title => "Group C", :many_data => {:list => list}}
data = {:groups => groups}

print Misen.expand_sgml(source, data)

