=begin
=TestResult.rb
A TestResult encapsulates the result of running a set of tests.
=end

#<standard_header>
#
# Copyright (C) 2000-2001 Nathaniel Talbott
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#</standard_header>

module Lapidary
	class TestResult
		attr_reader(:runs, :assertions, :failures, :errors)
		def initialize
			@runs, @assertions, @failures, @errors = 0, 0, 0, 0
			@resultListeners, @faultListeners = Array.new, Array.new
		end
		def addRun
			@runs = @runs.next
			notifyResult
		end
		def addFailedAssertion(failure="Assertion failed")
			@failures = @failures.next
			notifyFault(failure)
			notifyResult
		end
		def addError(error="Error")
			@errors = @errors.next
			notifyFault(error)
			notifyResult
		end
		def addSuccessfulAssertion(message="Assertion succeeded")
			@assertions = @assertions.next
			notifyResult
		end
		def to_s
			"#@runs runs, #@assertions assertions, #@failures failures, #@errors errors"
		end
		def addResultListener(proc)
			@resultListeners << proc
		end
		def removeResultListener(proc)
			@resultListeners.delete(proc)
		end
		def notifyResult
			@resultListeners.each {
				| proc |
				proc.call(self)
			}
		end
		def addFaultListener(proc)
			@faultListeners << proc
		end
		def removeFaultListener(proc)
			@faultListeners.delete(proc)
		end
		def notifyFault(fault)
			@faultListeners.each {
				| proc |
				proc.call(fault)
			}
		end
	end
end
