=begin
=Failure.rb
Encapsulates an assertion failure.
=end

#<standard_header>
#
# Copyright (C) 2000-2001 Nathaniel Talbott
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#</standard_header>

module Lapidary
	class Failure
		attr_reader(:location, :message)

		def initialize(location, message)
			@location = location
			@message = message
		end
		def shortDisplay
			"#{@location}: #{@message}"
		end
		def longDisplay
			"Failure occurred in #{shortDisplay}"
		end
		def to_s
			longDisplay
		end
	end
end
