require 'date'

module Dpklib
  class MonthDay
    ParseError = Class.new(StandardError)

    include Comparable

    DAY_RANGE = (1..31)
    MONTH_RANGE = (1..12)
    DAY_PER_MONTH = 32

    attr_accessor :day_count
    def initialize(*args)
      @day_count = 1
      self.set_md *args
    end
    
    def month
      @day_count / DAY_PER_MONTH
    end

    def day
      @day_count % DAY_PER_MONTH
    end

    def month=(m)
      set_md(m, day)
    end

    def day=(d)
      set_md(month, d)
    end

    def set_md(m = 1, d = 1)
      @day_count = DAY_PER_MONTH * m + d
    end

    def set_date(date)
      set_md(date.month, date.mday)
    end

    def ==(other)
      case other
      when MonthDay
	@day_count == other.day_count
      else
	false
      end
    end

    def ===(other)
      case other
        when Date
        other = MonthDay.from_date(other)
      end
      (self == other)
    end

    def <=>(other)
      case other
        when Date
        other = MonthDay.from_date(other)
        (self <=> other)
        else
        (@day_count <=> other.day_count)
      end
    end

    def hash
      @day_count.hash
    end

    def to_s
      "#{self.month}/#{self.day}"
    end

    def inspect
      "#{super}[#{to_s}]"
    end

    def to_date(year)
      Date.new( year, self.month, self.day )
    end
  end #/MonthDay

  class << MonthDay
    alias [] new
    def from_date(date)
      monthday = MonthDay.new
      monthday.set_date date
      monthday
    end

    def parse(str)
      ( str =~ %r"\A(\d+)/(\d+)\Z" ) || raise(MonthDay::ParseError)
      self[$1.to_i, $2.to_i]
    end

  end #/<< MonthDay

end #/Dpklib

