
module Dpklib
  NestedHashConflictError = Class.new(StandardError)
  class << NestedHashConflictError
    def assert_hash(hash, keys)
      hash.kind_of?(Hash) ||
        raise(NestedHashConflictError, "hash#{keys.inspect} is not a Hash.")
    end
  end #/<< NestedHashConflictError
end #/Dpklib

class << Dpklib
  def values_of_hash(hash)
    values = []
    hash.each { |key, value|
      values << value
    }
    values
  end

  def keys_of_hash(hash)
    keys = []
    hash.each { |key, value|
      keys << key
    }
    keys
  end

  def struct_to_hash(struct)
    hash = {}
    struct.members.each do |m|
      m = m.intern
      hash[m] = struct.__send__(m)
    end
    hash
  end

  def hash_to_struct(hash, struct)
    hash.each do |k, v|
      struct.__send__ "#{k}=", v
    end
    nil
  end

  def flat_alist_from_hash(hash)
    alist = []
    hash.each { |key, value|
      alist << key << value
    }
    alist
  end

  def flat_alist_to_hash(alist)
    hash = {}
    key = nil
    alist.each { |item|
      if key
        hash[key] = item
        key = nil
      else
        key = item
      end
    }
    hash
  end
  
  def nested_hash(hash, keys)
    tmpkeys = keys.dup
    nested_hash_main(hash, tmpkeys, keys)
  end

  private
  def nested_hash_main(hash, keys, orig_keys)
    Dpklib::NestedHashConflictError.assert_hash(hash, orig_keys)
    key = keys.shift
    if key
      hash = hash.include?(key) ? hash[key] : (hash[key] = Hash.new)
      nested_hash_main(hash, keys, orig_keys)
    else
      hash
    end
  end
end #/<< Dpklib
