require 'strscan'

module Dpklib
  CSVError = Class.new(StandardError)
  CSVParseError = Class.new(CSVError)

  class CSVRule < Struct.new(:field_delimiter, :record_delimiter)
    def create(ary)
      quoted_ary = ary.collect { |item|
        quote_field(item)
      }
      quoted_ary.join(field_delimiter)
    end

    def parse(csvstr)
      ary = []
      csvstr = csvstr.clone
      until csvstr.empty? do
        item, csvstr = scan_field(csvstr)
        ary << item
      end
      ary
    end

    def quote_field(unquoted)

    end
    
    def scan_field(str)

    end

    def concat_to(stream, array)
      csvtext = create(array)
      stream << csvtext << record_delimiter
      nil
    end
  end #/CSVRule

  CSV = CSVRule.new
  CSV.field_delimiter = ","
  CSV.record_delimiter = "\r\n"
  class << CSV
    def quote_field(unquoted)
      if unquoted.empty? then
        '""'
      elsif unquoted =~ %r'[",\n]' then
        quoted = unquoted.gsub(%r'"', '""')
        '"' << quoted << '"'
      else
        unquoted
      end
    end

    def scan_field(str)
      sc = StringScanner.new(str)
      if sc.skip(%r'"') then
        item = ""
        while true do
          sc.scan(%r'((.|\n)*?)"')
          raise(CSVParseError, "invalid quotation") unless sc.matched?
          item << sc[1]

          if sc.skip(%r'"') then
            item << '"'
          else
            break
          end
        end

        sc.skip(%r'(#{field_delimiter}|\z)')
        unless sc.matched? then
          raise(CSVParseError, "no delimiter after conclusion of quote") 
        end

        [item, sc.rest]
      else
        sc.scan(%r'((.|\n)+?)(#{field_delimiter}|\z)')
        [sc[1], sc.rest]
      end
    end

  end #/<< CSV
  

end #/Dpklib
