require "dpklib/dpkstd"

module Dpklib
  AUTORELOAD_LOG = ENV["RUBY_AUTORELOAD_LOG"] ? true : false
  LIBRARY_MTIMES = {}
  module RequireWithAutoReload
    class Script
      attr_accessor :loadname, :file, :mtime
      def initialize(loadname)
        @loadname = loadname
        @file = Dpklib.find_library(@loadname)
        @file && @mtime = File.mtime(@file)
      end
    end #/Script
    
    def self.append_features(klass)
      super
      loaded = $" #"
      loaded.each { |loadname|
        script = Script.new(loadname)
        if script.file
          LIBRARY_MTIMES[script.file] = script.mtime
        end
      }
    end

    # from auto-reload.rb
    def require(lib, *args)
      script = Script.new(lib)
      if script.file
        if script.mtime == LIBRARY_MTIMES[script.file]
          false
        else
          LIBRARY_MTIMES[script.file] && Dpklib.log_reload(script.file)
          LIBRARY_MTIMES[script.file] = script.mtime
          Kernel.load(script.file)
        end
      else
        super
      end
    end
  end #/RequireWithAutoReload
end #/Dpklib

class << Dpklib
  def reload_all
    Dpklib::LIBRARY_MTIMES.each { |file, mtime|
      require(file)
    }
  end

  def reload_all_with_protected
    begin
      Dpklib.reload_all
    rescue Exception
      $stderr.puts(Dpklib.stacktrace_message)
    end
  end

  def log_reload(file)
    if Dpklib::AUTORELOAD_LOG
      $stderr.puts "auto-reload: loaded `#{file}'."
    end
  end
end #/<< Dpklib

include Dpklib::RequireWithAutoReload
