require 'rubyunit'

require 'dpklib/webutils'

class TESTCASE_WebUtils < RUNIT::TestCase
  class URL
    def initialize(str)
      @str = str
    end
    
    def eql?(rhs)
      lhs = split_to_urltokens
      rhs = rhs.split_to_urltokens
      eql = true
      eql &&= (lhs.shift == rhs.shift)
      eql &&= (lhs - rhs).empty?
      eql &&= (rhs - lhs).empty?
      eql
    end
    alias == eql?

    def split_to_urltokens
      @str.split(%r'[?&]')
    end

    def to_s
      @str
    end
    alias inspect to_s
    
    class << self
      alias [] new
    end #/<< self
  end #/URL

  def test_parameterize_url
    url = "test.cgi"

    hash = {:namco => "765", :naxat => "79310"}
    url = Dpklib::WebUtils.parameterize_url(url, hash)
    assert_equals URL["test.cgi?naxat=79310&namco=765"], URL[url]

    hash = {:ikaruga => "385220"}
    url = Dpklib::WebUtils.parameterize_url(url, hash)
    assert_equals URL["test.cgi?naxat=79310&namco=765&ikaruga=385220"], URL[url]

    url = "test2.cgi"

    hash = {:radiant => {:silvergun => "treasure"}}
    url = Dpklib::WebUtils.parameterize_url(url, hash)
    assert_equals URL["test2.cgi?radiant.silvergun=treasure"], URL[url]
    
    url = "test3.cgi"

    hash = {:iam => nil}
    url = Dpklib::WebUtils.parameterize_url(url, hash)
    assert_equals URL["test3.cgi"], URL[url]
  end

end #/TESTCASE_WebUtils
