require "dpklib/error"
require "rubyunit"

class TESTCASE_ErrorClass < RUNIT::TestCase
  BaseError = Class.new(StandardError)
  TestError = Dpklib.new_error_class(BaseError) { |arg|
    "err:#{arg}"
  }

  def test_it
    check_err {
      raise(TestError.new("test"))
    }
    check_err {
      TestError.raise("test")
    }
  end

  def check_err(&block)
    begin
      yield
    rescue TestError
      assert_kind_of BaseError, $!
      assert_equals "err:test", $!.message
    end
  end

end #/TESTCASE_ErrorClass
