require "strscan"
module Dpklib
end #/Dpklib

class << Dpklib
  def tsv_encode!(decoded)
    encoded = decoded
    encoded.gsub!(%r"\\", "\\\\\\\\")
    encoded.gsub!(%r"\n", "\\\\n")
    encoded.gsub!(%r"\t", "\\\\t")
    encoded
  end

  def tsv_decode!(encoded)
    decoded = encoded
    decoded.gsub!(%r"([^\\]|)\\n", "\\1\n")
    decoded.gsub!(%r"([^\\]|)\\t", "\\1\t")
    decoded.gsub!(%r"\\\\", "\\\\")
    decoded
  end

  def tsv_encode(decoded)
    tsv_encode!(decoded.dup)
  end

  def tsv_decode(encoded)
    tsv_decode!(encoded.dup)
  end

  def tsv_split(tsvstr)
    splitted = []
    scanner = StringScanner.new(tsvstr)
    while true
      scanner.scan(%r"[^\t\Z]*")
      cell = tsv_decode!(scanner[0])
      splitted << cell
      break if scanner.empty?
      scanner.skip(%r"\t")
    end
    splitted
  end

  def tsv_join(array)
    array = array.collect { |cell|
      tsv_encode(cell.to_s)
    }
    array.join("\t")
  end
end #/<< Dpklib

