require "ftools"

module Dpklib
  CannotReplaceFileError = Class.new(StandardError)
  class << self
    def replace_file(file, tmpfile = nil, &block)
      tmpfile ||= default_tmpfile_for_replace(file)
      begin
        # Preserves file attributes.
        system("cp", "-pf", file, tmpfile) ||
          raise(CannotReplaceFileError, "Couldn't copy #{file} into #{tmpfile}.")
        File.truncate(tmpfile, 0)
        File.open(file, "rb") { |input|
          File.open(tmpfile, "ab") { |output|
            yield(input, output)
          }
        }
        File.mv(tmpfile, file) ||
          raise(CannotReplaceFileError, "Couldn't move #{tmpfile} into #{file}.")
      ensure
        File.rm_f(tmpfile)
      end
    end

    def default_tmpfile_for_replace(file)
      "#{file}.tmp"
    end
  end #/<< self
end #/Dpklib
