module Dpklib
  InvalidParseRuleError = Class.new(StandardError)

  class ParsedArguments
    attr_reader :args
    def initialize(args, opthash)
      @args, @opthash = args, opthash
    end

    def [](key)
      case key
      when Fixnum; @args[key]
      when Symbol; @opthash[key.to_s]
      when String; @opthash[key]
      else; raise(TypeError, "Not suitable for key: #{key}")
      end
    end

    include Enumerable
    def each(&block)
      @args.each(&block)
    end

    def each_options(&block)
      @opthash.each(&block)
    end

    def shift
      @args.shift
    end

    def pop
      @args.pop
    end

    def size
      @args.size
    end

    def empty?
      @args.empty?
    end
  end #/ParsedArguments

  class ArgumentParser
    def initialize(*parse_rule_args)
      @boolopts = {}
      @valopts = {}
      @multival_opts_set = {}

      single_options = parse_rule_args.shift
      single_options.scan(%r".:{0,2}") do |optspec|
        if optspec.size == 1
          @boolopts[optspec] = nil
        else
          opt = optspec[0, 1]
          @valopts[opt] = case optspec.size
                          when 2; nil
                          when 3
                            @multival_opts_set[opt] = true
                            nil
                          else; raise(InvalidParseRuleError,
                                      single_options)
                          end
        end
      end if single_options

      options = parse_rule_args
      options.each do |arg|
        unless arg =~ %r"\A([^:]+)(:{0,2})"
          raise(InvalidParseRuleError, arg)
        end
        opt = $~[1]
        corons = $~[2].size
        default_val = $~.post_match
        if corons == 0
          @boolopts[opt] = nil
        else
          @valopts[opt] = case $2.size
                          when 1; default_val.empty?() ? nil : default_val
                          when 2
                            @multival_opts_set[opt] = true
                            nil
                          else; raise(InvalidParseRuleError, arg)
                          end
        end
      end
    end

    def parse(*argv)
      getopts!(argv)
    end

    private
    # from getopts.rb
    def getopts!(argv)
      boolopts = @boolopts.dup
      valopts = @valopts.dup
      @multival_opts_set.each_key { |opt|
        valopts[opt] = []
      }
      c = 0
      while arg = argv.shift
        case arg
        when /\A--(.*)/
          if $1.empty?			# xinit -- -bpp 24
            break
          end

          opt, val = $1.split('=', 2)

          if opt.size == 1
            argv.unshift arg
            return nil
          elsif valopts.key? opt		# imclean --src +trash
            optval = (val || argv.shift) or return(nil)
            set_valopt(valopts, opt, optval)
          elsif boolopts.key? opt		# ruby --verbose
            boolopts[opt] = true
          else
            argv.unshift arg
            return nil
          end

          c += 1
        when /\A-(.+)/
          opts = $1

          until opts.empty?
            opt = opts.slice!(0, 1)

            if valopts.key? opt
              val = opts

              if val.empty?			# ruby -e 'p $:'
                optval = argv.shift or return(nil)
                set_valopt(valopts, opt, optval)
              else				# cc -ohello ...
                set_valopt(valopts, opt, val)
              end

              c += 1
              break
            elsif boolopts.key? opt
              boolopts[opt] = true		# ruby -h
              c += 1
            else
              argv.unshift arg
              return nil
            end
          end
        else
          argv.unshift arg
          break
        end
      end

      opthash = boolopts
      opthash.update(valopts)
      ParsedArguments.new(argv, opthash)
    end #/getopts!

    def set_valopt(valopts, opt, val)
      if @multival_opts_set[opt]
        valopts[opt] << val
      else
        valopts[opt] = val
      end
    end
  end #/ArgumentParser

  class << self
    def parse_args(argv, *parse_rule_args)
      Dpklib::ArgumentParser.new(*parse_rule_args).parse(*argv)
    end
  end #/<< self
end #/Dpklib
