require "dpklib/gtk/utils"
require "gtk"

module Dpklib_Gtk
  class SimplyIndexedMenu < Gtk::Menu
    attr_reader :selections, :selected_index
    def initialize(selections = nil)
      super()
      @menuitems = []
      @selected_index = 0

      self.selections = selections || []
    end
    
    def selections=(selections)
      each { |item|
        item.destroy
      }
      @menuitems = []

      append(Gtk::TearoffMenuItem::new)
      activate_event_proc = method(:on_menuitem_activated).to_proc
      selections.each_with_index { |selection, index|
        if selection
          menuitem = Gtk::MenuItem.new(selection)
          menuitem.signal_connect("activate", &activate_event_proc)
        else
          menuitem = Gtk::MenuItem.new  #separator
        end
        menuitem.show
        append(menuitem)
        
        @menuitems << menuitem
      }
      @selections = selections
    end

    def select(index)
      item = @menuitems[index] || raise(RangeError,
                                        "out of selection's range: #{index}")
      item.activate
    end

    def on_menuitem_activated(menuitem)
      selected_index = @menuitems.index(menuitem)
      on_selected(selected_index)
      @selected_index = selected_index
    end

    def on_selected(index)
      true
    end
  end #/SimplyIndexedMenu

  class SimplyIndexedOptionMenu < Gtk::OptionMenu
    def initialize(selections = nil)
      super()
      self.selections = selections
    end

    def selections=(selections)
      menu && remove_menu
      set_menu(new_indexed_menu(selections))

      begin
        menu.select(0)
      rescue RangeError
      end
      selections
    end

    def selected_index
      menu.selected_index
    end

    def new_indexed_menu(selections)
      menu = SimplyIndexedMenu.new(selections)
      Dpklib.install_singleton_method(menu, :on_selected,
                                      &method(:on_selected).to_proc)
      menu
    end

    def on_selected(index)
      true
    end
  end #/SimplyIndexedOptionMenu

  class << self
    def connect_menu_popup_to(widget, menu, mouse_buttons = nil)
      mouse_buttons ||= [3]
      widget.signal_connect("button_press_event") { |w, event|
        if mouse_buttons.include?(event.button)
          menu.popup(nil, nil, nil, event.button, event.time)
        end
        true
      }
      nil
    end

    # label_to_proc_flatalist pattern:
    # (1) "item 1", method(:on_item1)
    # (2) menuitem, nil
    # (3) nil, nil  => means separator
    def append_command_menuitems_to(menu, *label_to_proc_flatalist)
      item_to_proc_hash = {}
      activate_handler_proc = proc { |widget|
        Dpklib_Gtk.with_protected {
          item_to_proc_hash[widget].call
        }
      }

      until label_to_proc_flatalist.empty?
        label = label_to_proc_flatalist.shift
        procedure = label_to_proc_flatalist.shift
        
        item = case label
               when nil
                 Gtk::MenuItem.new
               when String
                 item = Gtk::MenuItem.new(label)

                 item_to_proc_hash[item] = procedure
                 item.signal_connect(Gtk::MenuItem::SIGNAL_ACTIVATE,
                                     &activate_handler_proc)
                 item
               when Gtk::MenuItem
                 label
               else
                 raise(TypeError, "Unknown type on label: #{label}")
               end
        item.show
        menu.append(item)
      end
      menu
    end

    def new_menu_with_tearoff(*args, &block)
      menu = Gtk::Menu.new(*args, &block)
      tearoff = Gtk::TearoffMenuItem.new
      tearoff.show
      menu.append(tearoff)
      menu
    end
  end #/<< self

end #/Dpklib_Gtk
