require "gtk"

module Dpklib_Gtk
  class ButtonSelectableDialog < Gtk::Dialog
    attr_reader :selections, :message, :selected_index
    attr_accessor :destroy_on_selected

    def initialize(message, *selections)
      super()
      @destroy_on_selected = true
      @selected_index = nil
      @buttons = []
      set_position(Gtk::WIN_POS_CENTER)

      @message_label = Gtk::Label.new
      @message_label.set_line_wrap(true)
      @message_label.set_alignment(0.1, 0.5)
      @message_label.set_padding(8, 8)
      @message_label.show
      self.message = message
      self.vbox.pack_start(@message_label, true, true, 10)

      self.selections = selections
    end

    def message=(message)
      @message_label.set_text(message)
      @message = message
    end

    def selections=(selections)
      @buttons.each { |btn|
        btn.destroy
      }

      singnal_handler = method(:on_button_selected).to_proc
      selections.each { |selection|
        button = Gtk::Button.new(selection)
        button.signal_connect(Gtk::Button::SIGNAL_CLICKED, &singnal_handler)
        button.show
        @buttons << button
        self.action_area.pack_start(button)
      }
      @selections = selections
    end

    def wait_answer
      show
      Dpklib_Gtk.wait_widget_hidden_or_destroyed(self)
      @selected_index
    end

    def on_button_selected(button_widget)
      @selected_index = @buttons.index(button_widget)
      @destroy_on_selected ? destroy : hide
    end
  end #/ButtonSelectableDialog

  class YesNoDialog < ButtonSelectableDialog
    def initialize(message, yes = nil, no = nil)
      yes ||= "Yes"
      no ||= "No"
      super(message, yes, no)
    end

    def wait_answer
      super
      yes?
    end

    def yes?
      selected_index == 0
    end
  end #/YesNoDialog

  class AlertDialog < ButtonSelectableDialog
    def initialize(message, ok = nil)
      ok ||= "OK"
      super(message, ok)
    end

    def wait_answer
      super
      nil
    end
  end #/AlertDialog

  class << self
    def alert(message)
      AlertDialog.new(message).wait_answer
    end

    def confirm(message, yes = nil, no = nil)
      YesNoDialog.new(message, yes, no).wait_answer
    end
  end #/<< self
end #/Dpklib_Gtk
