
#==============================================================================#
# test/testcase.rb
# $Id: testcase.rb,v 1.11 2003/03/06 06:12:50 yuya Exp $
#==============================================================================#

require 'test/unit'
require 'test/unit/testcase'
require 'bruby'

#==============================================================================#

class BRbTestCase < Test::Unit::TestCase

  def mkname(name, dir = '')
     rbfile  = dir + 'src/' + name + '.rb'
     brbfile = dir + 'bin/' + name + '.brb'
     return [rbfile, brbfile]
  end

  def verify(rbfile, brbfile)
     if BRb.verifyfile(rbfile)
       File.open(brbfile, 'wb') { |file|
         file.print(BRb.dumpfile(rbfile))
       }

       return true
     else
       return false
     end
  end

  def exec_ruby(file)
    return `ruby -Ks #{file}`
  end

  def exec_bruby(file)
    return `ruby ../bin/brbexe.rb -Ks #{file}`
  end

end

#==============================================================================#
#==============================================================================#
