require 'bitvector'

class BitVector
  # Substitute bits after (and including) a point
  def crossover_1point(other, point, numResults = 2)
    a = self.clone
    a.substitute(other, point, a.length, point, other.length)
    return a if numResults == 1
    b = other.clone
    b.substitute(self, point, other.length, point, self.length)
    [a,b]
  end

  # Substitute bits between point1 and point2 (incl point1 but excl point2)
  def crossover_2point(other, point1, point2, numResults = 2)
    a = self.clone
    len = point2-point1
    a.substitute(other, point1, len, point1, len)
    return a if numResults == 1
    b = other.clone
    b.substitute(self, point1, len, point1, len)
    [a,b]
  end
end
