=begin
  $Id: unittest_bitvector_extras.rb,v 1.4 2003/01/23 17:42:40 knu Exp $

  Unit test for XX.

  Part of Yoda (Yet another jOb Distributing And queueing system).
  (c) Copyright 2000, Robert Feldt, feldt@ce.chalmers.se

  This software is distributed under a license. See LICENSE in the Yoda main 
  directory for more information.

=end
require 'test/unit'
require 'test/unit/ui/console/testrunner'
require 'bitvector_extras'

class Test_BitVector < Test::Unit::TestCase

  def setup
    @i1 = BitVector.from_bin(20, "11111111111111111111")
    @i2 = BitVector.from_bin(20, "00000000000000000000")
  end

  def test_01_crossover_1point
    c1, c2 = @i1.crossover_1point(@i2, 10)
    assert_equal(20, c1.length)
    assert_equal(20, c2.length)
    assert_equal("11111111110000000000", c2.inspect)
    assert_equal("00000000001111111111", c1.inspect)
    assert_equal("11111111111111111111", @i1.inspect)
    assert_equal("00000000000000000000", @i2.inspect)

    c1, c2 = @i1.crossover_1point(@i2, 19)
    assert_equal(20, c1.length)
    assert_equal(20, c2.length)
    assert_equal("10000000000000000000", c2.inspect)
    assert_equal("01111111111111111111", c1.inspect)
  end

  def test_02_crossover_2point
    c1, c2 = @i1.crossover_2point(@i2, 5, 12)
    assert_equal(20, c1.length)
    assert_equal(20, c2.length)
    assert_equal("00000000111111100000", c2.inspect)
    assert_equal("11111111000000011111", c1.inspect)
  end
end
