/******************************************************************************/
/* This file is generated by the templates/template.rb script and should not  */
/* be modified manually. See                                                  */
/* templates/src/serialize.c.erb                                              */
/* if you are looking to modify the                                           */
/* template                                                                   */
/******************************************************************************/

#include "prism.h"

// We optionally support serializing to a binary string. For systems that don't
// want or need this functionality, it can be turned off with the
// PRISM_EXCLUDE_SERIALIZATION define.
#ifndef PRISM_EXCLUDE_SERIALIZATION

#include <stdio.h>

static inline uint32_t
pm_ptrdifft_to_u32(ptrdiff_t value) {
    assert(value >= 0 && ((unsigned long) value) < UINT32_MAX);
    return (uint32_t) value;
}

static inline uint32_t
pm_sizet_to_u32(size_t value) {
    assert(value < UINT32_MAX);
    return (uint32_t) value;
}

static void
pm_serialize_location(const pm_parser_t *parser, const pm_location_t *location, pm_buffer_t *buffer) {
    assert(location->start);
    assert(location->end);
    assert(location->start <= location->end);

    pm_buffer_append_varuint(buffer, pm_ptrdifft_to_u32(location->start - parser->start));
    pm_buffer_append_varuint(buffer, pm_ptrdifft_to_u32(location->end - location->start));
}

static void
pm_serialize_string(const pm_parser_t *parser, const pm_string_t *string, pm_buffer_t *buffer) {
    switch (string->type) {
        case PM_STRING_SHARED: {
            pm_buffer_append_byte(buffer, 1);
            pm_buffer_append_varuint(buffer, pm_ptrdifft_to_u32(pm_string_source(string) - parser->start));
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(pm_string_length(string)));
            break;
        }
        case PM_STRING_OWNED:
        case PM_STRING_CONSTANT: {
            uint32_t length = pm_sizet_to_u32(pm_string_length(string));
            pm_buffer_append_byte(buffer, 2);
            pm_buffer_append_varuint(buffer, length);
            pm_buffer_append_bytes(buffer, pm_string_source(string), length);
            break;
        }
#ifdef PRISM_HAS_MMAP
        case PM_STRING_MAPPED:
            assert(false && "Cannot serialize mapped strings.");
            break;
#endif
    }
}

static void
pm_serialize_integer(const pm_integer_t *integer, pm_buffer_t *buffer) {
    pm_buffer_append_byte(buffer, integer->negative ? 1 : 0);
    if (integer->values == NULL) {
        pm_buffer_append_varuint(buffer, pm_sizet_to_u32(1));
        pm_buffer_append_varuint(buffer, integer->value);
    } else {
        pm_buffer_append_varuint(buffer, pm_sizet_to_u32(integer->length));
        for (size_t i = 0; i < integer->length; i++) {
            pm_buffer_append_varuint(buffer, integer->values[i]);
        }
    }
}

static void
pm_serialize_node(pm_parser_t *parser, pm_node_t *node, pm_buffer_t *buffer) {
    pm_buffer_append_byte(buffer, (uint8_t) PM_NODE_TYPE(node));

    size_t offset = buffer->length;

    pm_serialize_location(parser, &node->location, buffer);

    switch (PM_NODE_TYPE(node)) {
        // We do not need to serialize a ScopeNode ever as
        // it is not part of the AST
        case PM_SCOPE_NODE:
            return;
        case PM_ALIAS_GLOBAL_VARIABLE_NODE: {
            pm_serialize_node(parser, (pm_node_t *)((pm_alias_global_variable_node_t *)node)->new_name, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_alias_global_variable_node_t *)node)->old_name, buffer);
            pm_serialize_location(parser, &((pm_alias_global_variable_node_t *)node)->keyword_loc, buffer);
            break;
        }
        case PM_ALIAS_METHOD_NODE: {
            pm_serialize_node(parser, (pm_node_t *)((pm_alias_method_node_t *)node)->new_name, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_alias_method_node_t *)node)->old_name, buffer);
            pm_serialize_location(parser, &((pm_alias_method_node_t *)node)->keyword_loc, buffer);
            break;
        }
        case PM_ALTERNATION_PATTERN_NODE: {
            pm_serialize_node(parser, (pm_node_t *)((pm_alternation_pattern_node_t *)node)->left, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_alternation_pattern_node_t *)node)->right, buffer);
            pm_serialize_location(parser, &((pm_alternation_pattern_node_t *)node)->operator_loc, buffer);
            break;
        }
        case PM_AND_NODE: {
            pm_serialize_node(parser, (pm_node_t *)((pm_and_node_t *)node)->left, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_and_node_t *)node)->right, buffer);
            pm_serialize_location(parser, &((pm_and_node_t *)node)->operator_loc, buffer);
            break;
        }
        case PM_ARGUMENTS_NODE: {
            pm_buffer_append_varuint(buffer, (uint32_t)(node->flags & ~PM_NODE_FLAG_COMMON_MASK));
            uint32_t arguments_size = pm_sizet_to_u32(((pm_arguments_node_t *)node)->arguments.size);
            pm_buffer_append_varuint(buffer, arguments_size);
            for (uint32_t index = 0; index < arguments_size; index++) {
                pm_serialize_node(parser, (pm_node_t *) ((pm_arguments_node_t *)node)->arguments.nodes[index], buffer);
            }
            break;
        }
        case PM_ARRAY_NODE: {
            pm_buffer_append_varuint(buffer, (uint32_t)(node->flags & ~PM_NODE_FLAG_COMMON_MASK));
            uint32_t elements_size = pm_sizet_to_u32(((pm_array_node_t *)node)->elements.size);
            pm_buffer_append_varuint(buffer, elements_size);
            for (uint32_t index = 0; index < elements_size; index++) {
                pm_serialize_node(parser, (pm_node_t *) ((pm_array_node_t *)node)->elements.nodes[index], buffer);
            }
            if (((pm_array_node_t *)node)->opening_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_array_node_t *)node)->opening_loc, buffer);
            }
            if (((pm_array_node_t *)node)->closing_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_array_node_t *)node)->closing_loc, buffer);
            }
            break;
        }
        case PM_ARRAY_PATTERN_NODE: {
            if (((pm_array_pattern_node_t *)node)->constant == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_array_pattern_node_t *)node)->constant, buffer);
            }
            uint32_t requireds_size = pm_sizet_to_u32(((pm_array_pattern_node_t *)node)->requireds.size);
            pm_buffer_append_varuint(buffer, requireds_size);
            for (uint32_t index = 0; index < requireds_size; index++) {
                pm_serialize_node(parser, (pm_node_t *) ((pm_array_pattern_node_t *)node)->requireds.nodes[index], buffer);
            }
            if (((pm_array_pattern_node_t *)node)->rest == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_array_pattern_node_t *)node)->rest, buffer);
            }
            uint32_t posts_size = pm_sizet_to_u32(((pm_array_pattern_node_t *)node)->posts.size);
            pm_buffer_append_varuint(buffer, posts_size);
            for (uint32_t index = 0; index < posts_size; index++) {
                pm_serialize_node(parser, (pm_node_t *) ((pm_array_pattern_node_t *)node)->posts.nodes[index], buffer);
            }
            if (((pm_array_pattern_node_t *)node)->opening_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_array_pattern_node_t *)node)->opening_loc, buffer);
            }
            if (((pm_array_pattern_node_t *)node)->closing_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_array_pattern_node_t *)node)->closing_loc, buffer);
            }
            break;
        }
        case PM_ASSOC_NODE: {
            pm_serialize_node(parser, (pm_node_t *)((pm_assoc_node_t *)node)->key, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_assoc_node_t *)node)->value, buffer);
            if (((pm_assoc_node_t *)node)->operator_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_assoc_node_t *)node)->operator_loc, buffer);
            }
            break;
        }
        case PM_ASSOC_SPLAT_NODE: {
            if (((pm_assoc_splat_node_t *)node)->value == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_assoc_splat_node_t *)node)->value, buffer);
            }
            pm_serialize_location(parser, &((pm_assoc_splat_node_t *)node)->operator_loc, buffer);
            break;
        }
        case PM_BACK_REFERENCE_READ_NODE: {
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_back_reference_read_node_t *)node)->name));
            break;
        }
        case PM_BEGIN_NODE: {
            if (((pm_begin_node_t *)node)->begin_keyword_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_begin_node_t *)node)->begin_keyword_loc, buffer);
            }
            if (((pm_begin_node_t *)node)->statements == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_begin_node_t *)node)->statements, buffer);
            }
            if (((pm_begin_node_t *)node)->rescue_clause == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_begin_node_t *)node)->rescue_clause, buffer);
            }
            if (((pm_begin_node_t *)node)->else_clause == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_begin_node_t *)node)->else_clause, buffer);
            }
            if (((pm_begin_node_t *)node)->ensure_clause == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_begin_node_t *)node)->ensure_clause, buffer);
            }
            if (((pm_begin_node_t *)node)->end_keyword_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_begin_node_t *)node)->end_keyword_loc, buffer);
            }
            break;
        }
        case PM_BLOCK_ARGUMENT_NODE: {
            if (((pm_block_argument_node_t *)node)->expression == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_block_argument_node_t *)node)->expression, buffer);
            }
            pm_serialize_location(parser, &((pm_block_argument_node_t *)node)->operator_loc, buffer);
            break;
        }
        case PM_BLOCK_LOCAL_VARIABLE_NODE: {
            pm_buffer_append_varuint(buffer, (uint32_t)(node->flags & ~PM_NODE_FLAG_COMMON_MASK));
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_block_local_variable_node_t *)node)->name));
            break;
        }
        case PM_BLOCK_NODE: {
            uint32_t locals_size = pm_sizet_to_u32(((pm_block_node_t *)node)->locals.size);
            pm_buffer_append_varuint(buffer, locals_size);
            for (uint32_t index = 0; index < locals_size; index++) {
                pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_block_node_t *)node)->locals.ids[index]));
            }
            if (((pm_block_node_t *)node)->parameters == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_block_node_t *)node)->parameters, buffer);
            }
            if (((pm_block_node_t *)node)->body == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_block_node_t *)node)->body, buffer);
            }
            pm_serialize_location(parser, &((pm_block_node_t *)node)->opening_loc, buffer);
            pm_serialize_location(parser, &((pm_block_node_t *)node)->closing_loc, buffer);
            break;
        }
        case PM_BLOCK_PARAMETER_NODE: {
            pm_buffer_append_varuint(buffer, (uint32_t)(node->flags & ~PM_NODE_FLAG_COMMON_MASK));
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_block_parameter_node_t *)node)->name));
            if (((pm_block_parameter_node_t *)node)->name_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_block_parameter_node_t *)node)->name_loc, buffer);
            }
            pm_serialize_location(parser, &((pm_block_parameter_node_t *)node)->operator_loc, buffer);
            break;
        }
        case PM_BLOCK_PARAMETERS_NODE: {
            if (((pm_block_parameters_node_t *)node)->parameters == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_block_parameters_node_t *)node)->parameters, buffer);
            }
            uint32_t locals_size = pm_sizet_to_u32(((pm_block_parameters_node_t *)node)->locals.size);
            pm_buffer_append_varuint(buffer, locals_size);
            for (uint32_t index = 0; index < locals_size; index++) {
                pm_serialize_node(parser, (pm_node_t *) ((pm_block_parameters_node_t *)node)->locals.nodes[index], buffer);
            }
            if (((pm_block_parameters_node_t *)node)->opening_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_block_parameters_node_t *)node)->opening_loc, buffer);
            }
            if (((pm_block_parameters_node_t *)node)->closing_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_block_parameters_node_t *)node)->closing_loc, buffer);
            }
            break;
        }
        case PM_BREAK_NODE: {
            if (((pm_break_node_t *)node)->arguments == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_break_node_t *)node)->arguments, buffer);
            }
            pm_serialize_location(parser, &((pm_break_node_t *)node)->keyword_loc, buffer);
            break;
        }
        case PM_CALL_AND_WRITE_NODE: {
            pm_buffer_append_varuint(buffer, (uint32_t)(node->flags & ~PM_NODE_FLAG_COMMON_MASK));
            if (((pm_call_and_write_node_t *)node)->receiver == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_call_and_write_node_t *)node)->receiver, buffer);
            }
            if (((pm_call_and_write_node_t *)node)->call_operator_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_call_and_write_node_t *)node)->call_operator_loc, buffer);
            }
            if (((pm_call_and_write_node_t *)node)->message_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_call_and_write_node_t *)node)->message_loc, buffer);
            }
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_call_and_write_node_t *)node)->read_name));
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_call_and_write_node_t *)node)->write_name));
            pm_serialize_location(parser, &((pm_call_and_write_node_t *)node)->operator_loc, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_call_and_write_node_t *)node)->value, buffer);
            break;
        }
        case PM_CALL_NODE: {
            pm_buffer_append_varuint(buffer, (uint32_t)(node->flags & ~PM_NODE_FLAG_COMMON_MASK));
            if (((pm_call_node_t *)node)->receiver == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_call_node_t *)node)->receiver, buffer);
            }
            if (((pm_call_node_t *)node)->call_operator_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_call_node_t *)node)->call_operator_loc, buffer);
            }
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_call_node_t *)node)->name));
            if (((pm_call_node_t *)node)->message_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_call_node_t *)node)->message_loc, buffer);
            }
            if (((pm_call_node_t *)node)->opening_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_call_node_t *)node)->opening_loc, buffer);
            }
            if (((pm_call_node_t *)node)->arguments == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_call_node_t *)node)->arguments, buffer);
            }
            if (((pm_call_node_t *)node)->closing_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_call_node_t *)node)->closing_loc, buffer);
            }
            if (((pm_call_node_t *)node)->block == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_call_node_t *)node)->block, buffer);
            }
            break;
        }
        case PM_CALL_OPERATOR_WRITE_NODE: {
            pm_buffer_append_varuint(buffer, (uint32_t)(node->flags & ~PM_NODE_FLAG_COMMON_MASK));
            if (((pm_call_operator_write_node_t *)node)->receiver == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_call_operator_write_node_t *)node)->receiver, buffer);
            }
            if (((pm_call_operator_write_node_t *)node)->call_operator_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_call_operator_write_node_t *)node)->call_operator_loc, buffer);
            }
            if (((pm_call_operator_write_node_t *)node)->message_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_call_operator_write_node_t *)node)->message_loc, buffer);
            }
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_call_operator_write_node_t *)node)->read_name));
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_call_operator_write_node_t *)node)->write_name));
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_call_operator_write_node_t *)node)->binary_operator));
            pm_serialize_location(parser, &((pm_call_operator_write_node_t *)node)->binary_operator_loc, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_call_operator_write_node_t *)node)->value, buffer);
            break;
        }
        case PM_CALL_OR_WRITE_NODE: {
            pm_buffer_append_varuint(buffer, (uint32_t)(node->flags & ~PM_NODE_FLAG_COMMON_MASK));
            if (((pm_call_or_write_node_t *)node)->receiver == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_call_or_write_node_t *)node)->receiver, buffer);
            }
            if (((pm_call_or_write_node_t *)node)->call_operator_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_call_or_write_node_t *)node)->call_operator_loc, buffer);
            }
            if (((pm_call_or_write_node_t *)node)->message_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_call_or_write_node_t *)node)->message_loc, buffer);
            }
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_call_or_write_node_t *)node)->read_name));
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_call_or_write_node_t *)node)->write_name));
            pm_serialize_location(parser, &((pm_call_or_write_node_t *)node)->operator_loc, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_call_or_write_node_t *)node)->value, buffer);
            break;
        }
        case PM_CALL_TARGET_NODE: {
            pm_buffer_append_varuint(buffer, (uint32_t)(node->flags & ~PM_NODE_FLAG_COMMON_MASK));
            pm_serialize_node(parser, (pm_node_t *)((pm_call_target_node_t *)node)->receiver, buffer);
            pm_serialize_location(parser, &((pm_call_target_node_t *)node)->call_operator_loc, buffer);
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_call_target_node_t *)node)->name));
            pm_serialize_location(parser, &((pm_call_target_node_t *)node)->message_loc, buffer);
            break;
        }
        case PM_CAPTURE_PATTERN_NODE: {
            pm_serialize_node(parser, (pm_node_t *)((pm_capture_pattern_node_t *)node)->value, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_capture_pattern_node_t *)node)->target, buffer);
            pm_serialize_location(parser, &((pm_capture_pattern_node_t *)node)->operator_loc, buffer);
            break;
        }
        case PM_CASE_MATCH_NODE: {
            if (((pm_case_match_node_t *)node)->predicate == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_case_match_node_t *)node)->predicate, buffer);
            }
            uint32_t conditions_size = pm_sizet_to_u32(((pm_case_match_node_t *)node)->conditions.size);
            pm_buffer_append_varuint(buffer, conditions_size);
            for (uint32_t index = 0; index < conditions_size; index++) {
                pm_serialize_node(parser, (pm_node_t *) ((pm_case_match_node_t *)node)->conditions.nodes[index], buffer);
            }
            if (((pm_case_match_node_t *)node)->consequent == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_case_match_node_t *)node)->consequent, buffer);
            }
            pm_serialize_location(parser, &((pm_case_match_node_t *)node)->case_keyword_loc, buffer);
            pm_serialize_location(parser, &((pm_case_match_node_t *)node)->end_keyword_loc, buffer);
            break;
        }
        case PM_CASE_NODE: {
            if (((pm_case_node_t *)node)->predicate == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_case_node_t *)node)->predicate, buffer);
            }
            uint32_t conditions_size = pm_sizet_to_u32(((pm_case_node_t *)node)->conditions.size);
            pm_buffer_append_varuint(buffer, conditions_size);
            for (uint32_t index = 0; index < conditions_size; index++) {
                pm_serialize_node(parser, (pm_node_t *) ((pm_case_node_t *)node)->conditions.nodes[index], buffer);
            }
            if (((pm_case_node_t *)node)->consequent == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_case_node_t *)node)->consequent, buffer);
            }
            pm_serialize_location(parser, &((pm_case_node_t *)node)->case_keyword_loc, buffer);
            pm_serialize_location(parser, &((pm_case_node_t *)node)->end_keyword_loc, buffer);
            break;
        }
        case PM_CLASS_NODE: {
            uint32_t locals_size = pm_sizet_to_u32(((pm_class_node_t *)node)->locals.size);
            pm_buffer_append_varuint(buffer, locals_size);
            for (uint32_t index = 0; index < locals_size; index++) {
                pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_class_node_t *)node)->locals.ids[index]));
            }
            pm_serialize_location(parser, &((pm_class_node_t *)node)->class_keyword_loc, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_class_node_t *)node)->constant_path, buffer);
            if (((pm_class_node_t *)node)->inheritance_operator_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_class_node_t *)node)->inheritance_operator_loc, buffer);
            }
            if (((pm_class_node_t *)node)->superclass == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_class_node_t *)node)->superclass, buffer);
            }
            if (((pm_class_node_t *)node)->body == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_class_node_t *)node)->body, buffer);
            }
            pm_serialize_location(parser, &((pm_class_node_t *)node)->end_keyword_loc, buffer);
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_class_node_t *)node)->name));
            break;
        }
        case PM_CLASS_VARIABLE_AND_WRITE_NODE: {
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_class_variable_and_write_node_t *)node)->name));
            pm_serialize_location(parser, &((pm_class_variable_and_write_node_t *)node)->name_loc, buffer);
            pm_serialize_location(parser, &((pm_class_variable_and_write_node_t *)node)->operator_loc, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_class_variable_and_write_node_t *)node)->value, buffer);
            break;
        }
        case PM_CLASS_VARIABLE_OPERATOR_WRITE_NODE: {
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_class_variable_operator_write_node_t *)node)->name));
            pm_serialize_location(parser, &((pm_class_variable_operator_write_node_t *)node)->name_loc, buffer);
            pm_serialize_location(parser, &((pm_class_variable_operator_write_node_t *)node)->binary_operator_loc, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_class_variable_operator_write_node_t *)node)->value, buffer);
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_class_variable_operator_write_node_t *)node)->binary_operator));
            break;
        }
        case PM_CLASS_VARIABLE_OR_WRITE_NODE: {
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_class_variable_or_write_node_t *)node)->name));
            pm_serialize_location(parser, &((pm_class_variable_or_write_node_t *)node)->name_loc, buffer);
            pm_serialize_location(parser, &((pm_class_variable_or_write_node_t *)node)->operator_loc, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_class_variable_or_write_node_t *)node)->value, buffer);
            break;
        }
        case PM_CLASS_VARIABLE_READ_NODE: {
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_class_variable_read_node_t *)node)->name));
            break;
        }
        case PM_CLASS_VARIABLE_TARGET_NODE: {
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_class_variable_target_node_t *)node)->name));
            break;
        }
        case PM_CLASS_VARIABLE_WRITE_NODE: {
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_class_variable_write_node_t *)node)->name));
            pm_serialize_location(parser, &((pm_class_variable_write_node_t *)node)->name_loc, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_class_variable_write_node_t *)node)->value, buffer);
            pm_serialize_location(parser, &((pm_class_variable_write_node_t *)node)->operator_loc, buffer);
            break;
        }
        case PM_CONSTANT_AND_WRITE_NODE: {
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_constant_and_write_node_t *)node)->name));
            pm_serialize_location(parser, &((pm_constant_and_write_node_t *)node)->name_loc, buffer);
            pm_serialize_location(parser, &((pm_constant_and_write_node_t *)node)->operator_loc, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_constant_and_write_node_t *)node)->value, buffer);
            break;
        }
        case PM_CONSTANT_OPERATOR_WRITE_NODE: {
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_constant_operator_write_node_t *)node)->name));
            pm_serialize_location(parser, &((pm_constant_operator_write_node_t *)node)->name_loc, buffer);
            pm_serialize_location(parser, &((pm_constant_operator_write_node_t *)node)->binary_operator_loc, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_constant_operator_write_node_t *)node)->value, buffer);
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_constant_operator_write_node_t *)node)->binary_operator));
            break;
        }
        case PM_CONSTANT_OR_WRITE_NODE: {
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_constant_or_write_node_t *)node)->name));
            pm_serialize_location(parser, &((pm_constant_or_write_node_t *)node)->name_loc, buffer);
            pm_serialize_location(parser, &((pm_constant_or_write_node_t *)node)->operator_loc, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_constant_or_write_node_t *)node)->value, buffer);
            break;
        }
        case PM_CONSTANT_PATH_AND_WRITE_NODE: {
            pm_serialize_node(parser, (pm_node_t *)((pm_constant_path_and_write_node_t *)node)->target, buffer);
            pm_serialize_location(parser, &((pm_constant_path_and_write_node_t *)node)->operator_loc, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_constant_path_and_write_node_t *)node)->value, buffer);
            break;
        }
        case PM_CONSTANT_PATH_NODE: {
            if (((pm_constant_path_node_t *)node)->parent == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_constant_path_node_t *)node)->parent, buffer);
            }
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_constant_path_node_t *)node)->name));
            pm_serialize_location(parser, &((pm_constant_path_node_t *)node)->delimiter_loc, buffer);
            pm_serialize_location(parser, &((pm_constant_path_node_t *)node)->name_loc, buffer);
            break;
        }
        case PM_CONSTANT_PATH_OPERATOR_WRITE_NODE: {
            pm_serialize_node(parser, (pm_node_t *)((pm_constant_path_operator_write_node_t *)node)->target, buffer);
            pm_serialize_location(parser, &((pm_constant_path_operator_write_node_t *)node)->binary_operator_loc, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_constant_path_operator_write_node_t *)node)->value, buffer);
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_constant_path_operator_write_node_t *)node)->binary_operator));
            break;
        }
        case PM_CONSTANT_PATH_OR_WRITE_NODE: {
            pm_serialize_node(parser, (pm_node_t *)((pm_constant_path_or_write_node_t *)node)->target, buffer);
            pm_serialize_location(parser, &((pm_constant_path_or_write_node_t *)node)->operator_loc, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_constant_path_or_write_node_t *)node)->value, buffer);
            break;
        }
        case PM_CONSTANT_PATH_TARGET_NODE: {
            if (((pm_constant_path_target_node_t *)node)->parent == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_constant_path_target_node_t *)node)->parent, buffer);
            }
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_constant_path_target_node_t *)node)->name));
            pm_serialize_location(parser, &((pm_constant_path_target_node_t *)node)->delimiter_loc, buffer);
            pm_serialize_location(parser, &((pm_constant_path_target_node_t *)node)->name_loc, buffer);
            break;
        }
        case PM_CONSTANT_PATH_WRITE_NODE: {
            pm_serialize_node(parser, (pm_node_t *)((pm_constant_path_write_node_t *)node)->target, buffer);
            pm_serialize_location(parser, &((pm_constant_path_write_node_t *)node)->operator_loc, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_constant_path_write_node_t *)node)->value, buffer);
            break;
        }
        case PM_CONSTANT_READ_NODE: {
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_constant_read_node_t *)node)->name));
            break;
        }
        case PM_CONSTANT_TARGET_NODE: {
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_constant_target_node_t *)node)->name));
            break;
        }
        case PM_CONSTANT_WRITE_NODE: {
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_constant_write_node_t *)node)->name));
            pm_serialize_location(parser, &((pm_constant_write_node_t *)node)->name_loc, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_constant_write_node_t *)node)->value, buffer);
            pm_serialize_location(parser, &((pm_constant_write_node_t *)node)->operator_loc, buffer);
            break;
        }
        case PM_DEF_NODE: {
            // serialize length
            // encoding of location u32s make us need to save this offset.
            size_t length_offset = buffer->length;
            pm_buffer_append_string(buffer, "\0\0\0\0", 4); /* consume 4 bytes, updated below */
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_def_node_t *)node)->name));
            pm_serialize_location(parser, &((pm_def_node_t *)node)->name_loc, buffer);
            if (((pm_def_node_t *)node)->receiver == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_def_node_t *)node)->receiver, buffer);
            }
            if (((pm_def_node_t *)node)->parameters == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_def_node_t *)node)->parameters, buffer);
            }
            if (((pm_def_node_t *)node)->body == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_def_node_t *)node)->body, buffer);
            }
            uint32_t locals_size = pm_sizet_to_u32(((pm_def_node_t *)node)->locals.size);
            pm_buffer_append_varuint(buffer, locals_size);
            for (uint32_t index = 0; index < locals_size; index++) {
                pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_def_node_t *)node)->locals.ids[index]));
            }
            pm_serialize_location(parser, &((pm_def_node_t *)node)->def_keyword_loc, buffer);
            if (((pm_def_node_t *)node)->operator_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_def_node_t *)node)->operator_loc, buffer);
            }
            if (((pm_def_node_t *)node)->lparen_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_def_node_t *)node)->lparen_loc, buffer);
            }
            if (((pm_def_node_t *)node)->rparen_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_def_node_t *)node)->rparen_loc, buffer);
            }
            if (((pm_def_node_t *)node)->equal_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_def_node_t *)node)->equal_loc, buffer);
            }
            if (((pm_def_node_t *)node)->end_keyword_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_def_node_t *)node)->end_keyword_loc, buffer);
            }
            // serialize length
            uint32_t length = pm_sizet_to_u32(buffer->length - offset - sizeof(uint32_t));
            memcpy(buffer->value + length_offset, &length, sizeof(uint32_t));
            break;
        }
        case PM_DEFINED_NODE: {
            if (((pm_defined_node_t *)node)->lparen_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_defined_node_t *)node)->lparen_loc, buffer);
            }
            pm_serialize_node(parser, (pm_node_t *)((pm_defined_node_t *)node)->value, buffer);
            if (((pm_defined_node_t *)node)->rparen_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_defined_node_t *)node)->rparen_loc, buffer);
            }
            pm_serialize_location(parser, &((pm_defined_node_t *)node)->keyword_loc, buffer);
            break;
        }
        case PM_ELSE_NODE: {
            pm_serialize_location(parser, &((pm_else_node_t *)node)->else_keyword_loc, buffer);
            if (((pm_else_node_t *)node)->statements == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_else_node_t *)node)->statements, buffer);
            }
            if (((pm_else_node_t *)node)->end_keyword_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_else_node_t *)node)->end_keyword_loc, buffer);
            }
            break;
        }
        case PM_EMBEDDED_STATEMENTS_NODE: {
            pm_serialize_location(parser, &((pm_embedded_statements_node_t *)node)->opening_loc, buffer);
            if (((pm_embedded_statements_node_t *)node)->statements == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_embedded_statements_node_t *)node)->statements, buffer);
            }
            pm_serialize_location(parser, &((pm_embedded_statements_node_t *)node)->closing_loc, buffer);
            break;
        }
        case PM_EMBEDDED_VARIABLE_NODE: {
            pm_serialize_location(parser, &((pm_embedded_variable_node_t *)node)->operator_loc, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_embedded_variable_node_t *)node)->variable, buffer);
            break;
        }
        case PM_ENSURE_NODE: {
            pm_serialize_location(parser, &((pm_ensure_node_t *)node)->ensure_keyword_loc, buffer);
            if (((pm_ensure_node_t *)node)->statements == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_ensure_node_t *)node)->statements, buffer);
            }
            pm_serialize_location(parser, &((pm_ensure_node_t *)node)->end_keyword_loc, buffer);
            break;
        }
        case PM_FALSE_NODE: {
            break;
        }
        case PM_FIND_PATTERN_NODE: {
            if (((pm_find_pattern_node_t *)node)->constant == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_find_pattern_node_t *)node)->constant, buffer);
            }
            pm_serialize_node(parser, (pm_node_t *)((pm_find_pattern_node_t *)node)->left, buffer);
            uint32_t requireds_size = pm_sizet_to_u32(((pm_find_pattern_node_t *)node)->requireds.size);
            pm_buffer_append_varuint(buffer, requireds_size);
            for (uint32_t index = 0; index < requireds_size; index++) {
                pm_serialize_node(parser, (pm_node_t *) ((pm_find_pattern_node_t *)node)->requireds.nodes[index], buffer);
            }
            pm_serialize_node(parser, (pm_node_t *)((pm_find_pattern_node_t *)node)->right, buffer);
            if (((pm_find_pattern_node_t *)node)->opening_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_find_pattern_node_t *)node)->opening_loc, buffer);
            }
            if (((pm_find_pattern_node_t *)node)->closing_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_find_pattern_node_t *)node)->closing_loc, buffer);
            }
            break;
        }
        case PM_FLIP_FLOP_NODE: {
            pm_buffer_append_varuint(buffer, (uint32_t)(node->flags & ~PM_NODE_FLAG_COMMON_MASK));
            if (((pm_flip_flop_node_t *)node)->left == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_flip_flop_node_t *)node)->left, buffer);
            }
            if (((pm_flip_flop_node_t *)node)->right == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_flip_flop_node_t *)node)->right, buffer);
            }
            pm_serialize_location(parser, &((pm_flip_flop_node_t *)node)->operator_loc, buffer);
            break;
        }
        case PM_FLOAT_NODE: {
            pm_buffer_append_double(buffer, ((pm_float_node_t *)node)->value);
            break;
        }
        case PM_FOR_NODE: {
            pm_serialize_node(parser, (pm_node_t *)((pm_for_node_t *)node)->index, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_for_node_t *)node)->collection, buffer);
            if (((pm_for_node_t *)node)->statements == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_for_node_t *)node)->statements, buffer);
            }
            pm_serialize_location(parser, &((pm_for_node_t *)node)->for_keyword_loc, buffer);
            pm_serialize_location(parser, &((pm_for_node_t *)node)->in_keyword_loc, buffer);
            if (((pm_for_node_t *)node)->do_keyword_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_for_node_t *)node)->do_keyword_loc, buffer);
            }
            pm_serialize_location(parser, &((pm_for_node_t *)node)->end_keyword_loc, buffer);
            break;
        }
        case PM_FORWARDING_ARGUMENTS_NODE: {
            break;
        }
        case PM_FORWARDING_PARAMETER_NODE: {
            break;
        }
        case PM_FORWARDING_SUPER_NODE: {
            if (((pm_forwarding_super_node_t *)node)->block == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_forwarding_super_node_t *)node)->block, buffer);
            }
            break;
        }
        case PM_GLOBAL_VARIABLE_AND_WRITE_NODE: {
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_global_variable_and_write_node_t *)node)->name));
            pm_serialize_location(parser, &((pm_global_variable_and_write_node_t *)node)->name_loc, buffer);
            pm_serialize_location(parser, &((pm_global_variable_and_write_node_t *)node)->operator_loc, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_global_variable_and_write_node_t *)node)->value, buffer);
            break;
        }
        case PM_GLOBAL_VARIABLE_OPERATOR_WRITE_NODE: {
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_global_variable_operator_write_node_t *)node)->name));
            pm_serialize_location(parser, &((pm_global_variable_operator_write_node_t *)node)->name_loc, buffer);
            pm_serialize_location(parser, &((pm_global_variable_operator_write_node_t *)node)->binary_operator_loc, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_global_variable_operator_write_node_t *)node)->value, buffer);
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_global_variable_operator_write_node_t *)node)->binary_operator));
            break;
        }
        case PM_GLOBAL_VARIABLE_OR_WRITE_NODE: {
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_global_variable_or_write_node_t *)node)->name));
            pm_serialize_location(parser, &((pm_global_variable_or_write_node_t *)node)->name_loc, buffer);
            pm_serialize_location(parser, &((pm_global_variable_or_write_node_t *)node)->operator_loc, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_global_variable_or_write_node_t *)node)->value, buffer);
            break;
        }
        case PM_GLOBAL_VARIABLE_READ_NODE: {
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_global_variable_read_node_t *)node)->name));
            break;
        }
        case PM_GLOBAL_VARIABLE_TARGET_NODE: {
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_global_variable_target_node_t *)node)->name));
            break;
        }
        case PM_GLOBAL_VARIABLE_WRITE_NODE: {
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_global_variable_write_node_t *)node)->name));
            pm_serialize_location(parser, &((pm_global_variable_write_node_t *)node)->name_loc, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_global_variable_write_node_t *)node)->value, buffer);
            pm_serialize_location(parser, &((pm_global_variable_write_node_t *)node)->operator_loc, buffer);
            break;
        }
        case PM_HASH_NODE: {
            pm_serialize_location(parser, &((pm_hash_node_t *)node)->opening_loc, buffer);
            uint32_t elements_size = pm_sizet_to_u32(((pm_hash_node_t *)node)->elements.size);
            pm_buffer_append_varuint(buffer, elements_size);
            for (uint32_t index = 0; index < elements_size; index++) {
                pm_serialize_node(parser, (pm_node_t *) ((pm_hash_node_t *)node)->elements.nodes[index], buffer);
            }
            pm_serialize_location(parser, &((pm_hash_node_t *)node)->closing_loc, buffer);
            break;
        }
        case PM_HASH_PATTERN_NODE: {
            if (((pm_hash_pattern_node_t *)node)->constant == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_hash_pattern_node_t *)node)->constant, buffer);
            }
            uint32_t elements_size = pm_sizet_to_u32(((pm_hash_pattern_node_t *)node)->elements.size);
            pm_buffer_append_varuint(buffer, elements_size);
            for (uint32_t index = 0; index < elements_size; index++) {
                pm_serialize_node(parser, (pm_node_t *) ((pm_hash_pattern_node_t *)node)->elements.nodes[index], buffer);
            }
            if (((pm_hash_pattern_node_t *)node)->rest == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_hash_pattern_node_t *)node)->rest, buffer);
            }
            if (((pm_hash_pattern_node_t *)node)->opening_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_hash_pattern_node_t *)node)->opening_loc, buffer);
            }
            if (((pm_hash_pattern_node_t *)node)->closing_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_hash_pattern_node_t *)node)->closing_loc, buffer);
            }
            break;
        }
        case PM_IF_NODE: {
            if (((pm_if_node_t *)node)->if_keyword_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_if_node_t *)node)->if_keyword_loc, buffer);
            }
            pm_serialize_node(parser, (pm_node_t *)((pm_if_node_t *)node)->predicate, buffer);
            if (((pm_if_node_t *)node)->then_keyword_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_if_node_t *)node)->then_keyword_loc, buffer);
            }
            if (((pm_if_node_t *)node)->statements == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_if_node_t *)node)->statements, buffer);
            }
            if (((pm_if_node_t *)node)->consequent == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_if_node_t *)node)->consequent, buffer);
            }
            if (((pm_if_node_t *)node)->end_keyword_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_if_node_t *)node)->end_keyword_loc, buffer);
            }
            break;
        }
        case PM_IMAGINARY_NODE: {
            pm_serialize_node(parser, (pm_node_t *)((pm_imaginary_node_t *)node)->numeric, buffer);
            break;
        }
        case PM_IMPLICIT_NODE: {
            pm_serialize_node(parser, (pm_node_t *)((pm_implicit_node_t *)node)->value, buffer);
            break;
        }
        case PM_IMPLICIT_REST_NODE: {
            break;
        }
        case PM_IN_NODE: {
            pm_serialize_node(parser, (pm_node_t *)((pm_in_node_t *)node)->pattern, buffer);
            if (((pm_in_node_t *)node)->statements == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_in_node_t *)node)->statements, buffer);
            }
            pm_serialize_location(parser, &((pm_in_node_t *)node)->in_loc, buffer);
            if (((pm_in_node_t *)node)->then_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_in_node_t *)node)->then_loc, buffer);
            }
            break;
        }
        case PM_INDEX_AND_WRITE_NODE: {
            pm_buffer_append_varuint(buffer, (uint32_t)(node->flags & ~PM_NODE_FLAG_COMMON_MASK));
            if (((pm_index_and_write_node_t *)node)->receiver == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_index_and_write_node_t *)node)->receiver, buffer);
            }
            if (((pm_index_and_write_node_t *)node)->call_operator_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_index_and_write_node_t *)node)->call_operator_loc, buffer);
            }
            pm_serialize_location(parser, &((pm_index_and_write_node_t *)node)->opening_loc, buffer);
            if (((pm_index_and_write_node_t *)node)->arguments == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_index_and_write_node_t *)node)->arguments, buffer);
            }
            pm_serialize_location(parser, &((pm_index_and_write_node_t *)node)->closing_loc, buffer);
            if (((pm_index_and_write_node_t *)node)->block == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_index_and_write_node_t *)node)->block, buffer);
            }
            pm_serialize_location(parser, &((pm_index_and_write_node_t *)node)->operator_loc, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_index_and_write_node_t *)node)->value, buffer);
            break;
        }
        case PM_INDEX_OPERATOR_WRITE_NODE: {
            pm_buffer_append_varuint(buffer, (uint32_t)(node->flags & ~PM_NODE_FLAG_COMMON_MASK));
            if (((pm_index_operator_write_node_t *)node)->receiver == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_index_operator_write_node_t *)node)->receiver, buffer);
            }
            if (((pm_index_operator_write_node_t *)node)->call_operator_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_index_operator_write_node_t *)node)->call_operator_loc, buffer);
            }
            pm_serialize_location(parser, &((pm_index_operator_write_node_t *)node)->opening_loc, buffer);
            if (((pm_index_operator_write_node_t *)node)->arguments == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_index_operator_write_node_t *)node)->arguments, buffer);
            }
            pm_serialize_location(parser, &((pm_index_operator_write_node_t *)node)->closing_loc, buffer);
            if (((pm_index_operator_write_node_t *)node)->block == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_index_operator_write_node_t *)node)->block, buffer);
            }
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_index_operator_write_node_t *)node)->binary_operator));
            pm_serialize_location(parser, &((pm_index_operator_write_node_t *)node)->binary_operator_loc, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_index_operator_write_node_t *)node)->value, buffer);
            break;
        }
        case PM_INDEX_OR_WRITE_NODE: {
            pm_buffer_append_varuint(buffer, (uint32_t)(node->flags & ~PM_NODE_FLAG_COMMON_MASK));
            if (((pm_index_or_write_node_t *)node)->receiver == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_index_or_write_node_t *)node)->receiver, buffer);
            }
            if (((pm_index_or_write_node_t *)node)->call_operator_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_index_or_write_node_t *)node)->call_operator_loc, buffer);
            }
            pm_serialize_location(parser, &((pm_index_or_write_node_t *)node)->opening_loc, buffer);
            if (((pm_index_or_write_node_t *)node)->arguments == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_index_or_write_node_t *)node)->arguments, buffer);
            }
            pm_serialize_location(parser, &((pm_index_or_write_node_t *)node)->closing_loc, buffer);
            if (((pm_index_or_write_node_t *)node)->block == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_index_or_write_node_t *)node)->block, buffer);
            }
            pm_serialize_location(parser, &((pm_index_or_write_node_t *)node)->operator_loc, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_index_or_write_node_t *)node)->value, buffer);
            break;
        }
        case PM_INDEX_TARGET_NODE: {
            pm_buffer_append_varuint(buffer, (uint32_t)(node->flags & ~PM_NODE_FLAG_COMMON_MASK));
            pm_serialize_node(parser, (pm_node_t *)((pm_index_target_node_t *)node)->receiver, buffer);
            pm_serialize_location(parser, &((pm_index_target_node_t *)node)->opening_loc, buffer);
            if (((pm_index_target_node_t *)node)->arguments == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_index_target_node_t *)node)->arguments, buffer);
            }
            pm_serialize_location(parser, &((pm_index_target_node_t *)node)->closing_loc, buffer);
            if (((pm_index_target_node_t *)node)->block == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_index_target_node_t *)node)->block, buffer);
            }
            break;
        }
        case PM_INSTANCE_VARIABLE_AND_WRITE_NODE: {
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_instance_variable_and_write_node_t *)node)->name));
            pm_serialize_location(parser, &((pm_instance_variable_and_write_node_t *)node)->name_loc, buffer);
            pm_serialize_location(parser, &((pm_instance_variable_and_write_node_t *)node)->operator_loc, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_instance_variable_and_write_node_t *)node)->value, buffer);
            break;
        }
        case PM_INSTANCE_VARIABLE_OPERATOR_WRITE_NODE: {
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_instance_variable_operator_write_node_t *)node)->name));
            pm_serialize_location(parser, &((pm_instance_variable_operator_write_node_t *)node)->name_loc, buffer);
            pm_serialize_location(parser, &((pm_instance_variable_operator_write_node_t *)node)->binary_operator_loc, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_instance_variable_operator_write_node_t *)node)->value, buffer);
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_instance_variable_operator_write_node_t *)node)->binary_operator));
            break;
        }
        case PM_INSTANCE_VARIABLE_OR_WRITE_NODE: {
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_instance_variable_or_write_node_t *)node)->name));
            pm_serialize_location(parser, &((pm_instance_variable_or_write_node_t *)node)->name_loc, buffer);
            pm_serialize_location(parser, &((pm_instance_variable_or_write_node_t *)node)->operator_loc, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_instance_variable_or_write_node_t *)node)->value, buffer);
            break;
        }
        case PM_INSTANCE_VARIABLE_READ_NODE: {
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_instance_variable_read_node_t *)node)->name));
            break;
        }
        case PM_INSTANCE_VARIABLE_TARGET_NODE: {
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_instance_variable_target_node_t *)node)->name));
            break;
        }
        case PM_INSTANCE_VARIABLE_WRITE_NODE: {
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_instance_variable_write_node_t *)node)->name));
            pm_serialize_location(parser, &((pm_instance_variable_write_node_t *)node)->name_loc, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_instance_variable_write_node_t *)node)->value, buffer);
            pm_serialize_location(parser, &((pm_instance_variable_write_node_t *)node)->operator_loc, buffer);
            break;
        }
        case PM_INTEGER_NODE: {
            pm_buffer_append_varuint(buffer, (uint32_t)(node->flags & ~PM_NODE_FLAG_COMMON_MASK));
            pm_serialize_integer(&((pm_integer_node_t *)node)->value, buffer);
            break;
        }
        case PM_INTERPOLATED_MATCH_LAST_LINE_NODE: {
            pm_buffer_append_varuint(buffer, (uint32_t)(node->flags & ~PM_NODE_FLAG_COMMON_MASK));
            pm_serialize_location(parser, &((pm_interpolated_match_last_line_node_t *)node)->opening_loc, buffer);
            uint32_t parts_size = pm_sizet_to_u32(((pm_interpolated_match_last_line_node_t *)node)->parts.size);
            pm_buffer_append_varuint(buffer, parts_size);
            for (uint32_t index = 0; index < parts_size; index++) {
                pm_serialize_node(parser, (pm_node_t *) ((pm_interpolated_match_last_line_node_t *)node)->parts.nodes[index], buffer);
            }
            pm_serialize_location(parser, &((pm_interpolated_match_last_line_node_t *)node)->closing_loc, buffer);
            break;
        }
        case PM_INTERPOLATED_REGULAR_EXPRESSION_NODE: {
            pm_buffer_append_varuint(buffer, (uint32_t)(node->flags & ~PM_NODE_FLAG_COMMON_MASK));
            pm_serialize_location(parser, &((pm_interpolated_regular_expression_node_t *)node)->opening_loc, buffer);
            uint32_t parts_size = pm_sizet_to_u32(((pm_interpolated_regular_expression_node_t *)node)->parts.size);
            pm_buffer_append_varuint(buffer, parts_size);
            for (uint32_t index = 0; index < parts_size; index++) {
                pm_serialize_node(parser, (pm_node_t *) ((pm_interpolated_regular_expression_node_t *)node)->parts.nodes[index], buffer);
            }
            pm_serialize_location(parser, &((pm_interpolated_regular_expression_node_t *)node)->closing_loc, buffer);
            break;
        }
        case PM_INTERPOLATED_STRING_NODE: {
            pm_buffer_append_varuint(buffer, (uint32_t)(node->flags & ~PM_NODE_FLAG_COMMON_MASK));
            if (((pm_interpolated_string_node_t *)node)->opening_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_interpolated_string_node_t *)node)->opening_loc, buffer);
            }
            uint32_t parts_size = pm_sizet_to_u32(((pm_interpolated_string_node_t *)node)->parts.size);
            pm_buffer_append_varuint(buffer, parts_size);
            for (uint32_t index = 0; index < parts_size; index++) {
                pm_serialize_node(parser, (pm_node_t *) ((pm_interpolated_string_node_t *)node)->parts.nodes[index], buffer);
            }
            if (((pm_interpolated_string_node_t *)node)->closing_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_interpolated_string_node_t *)node)->closing_loc, buffer);
            }
            break;
        }
        case PM_INTERPOLATED_SYMBOL_NODE: {
            if (((pm_interpolated_symbol_node_t *)node)->opening_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_interpolated_symbol_node_t *)node)->opening_loc, buffer);
            }
            uint32_t parts_size = pm_sizet_to_u32(((pm_interpolated_symbol_node_t *)node)->parts.size);
            pm_buffer_append_varuint(buffer, parts_size);
            for (uint32_t index = 0; index < parts_size; index++) {
                pm_serialize_node(parser, (pm_node_t *) ((pm_interpolated_symbol_node_t *)node)->parts.nodes[index], buffer);
            }
            if (((pm_interpolated_symbol_node_t *)node)->closing_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_interpolated_symbol_node_t *)node)->closing_loc, buffer);
            }
            break;
        }
        case PM_INTERPOLATED_X_STRING_NODE: {
            pm_serialize_location(parser, &((pm_interpolated_x_string_node_t *)node)->opening_loc, buffer);
            uint32_t parts_size = pm_sizet_to_u32(((pm_interpolated_x_string_node_t *)node)->parts.size);
            pm_buffer_append_varuint(buffer, parts_size);
            for (uint32_t index = 0; index < parts_size; index++) {
                pm_serialize_node(parser, (pm_node_t *) ((pm_interpolated_x_string_node_t *)node)->parts.nodes[index], buffer);
            }
            pm_serialize_location(parser, &((pm_interpolated_x_string_node_t *)node)->closing_loc, buffer);
            break;
        }
        case PM_IT_PARAMETERS_NODE: {
            break;
        }
        case PM_KEYWORD_HASH_NODE: {
            pm_buffer_append_varuint(buffer, (uint32_t)(node->flags & ~PM_NODE_FLAG_COMMON_MASK));
            uint32_t elements_size = pm_sizet_to_u32(((pm_keyword_hash_node_t *)node)->elements.size);
            pm_buffer_append_varuint(buffer, elements_size);
            for (uint32_t index = 0; index < elements_size; index++) {
                pm_serialize_node(parser, (pm_node_t *) ((pm_keyword_hash_node_t *)node)->elements.nodes[index], buffer);
            }
            break;
        }
        case PM_KEYWORD_REST_PARAMETER_NODE: {
            pm_buffer_append_varuint(buffer, (uint32_t)(node->flags & ~PM_NODE_FLAG_COMMON_MASK));
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_keyword_rest_parameter_node_t *)node)->name));
            if (((pm_keyword_rest_parameter_node_t *)node)->name_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_keyword_rest_parameter_node_t *)node)->name_loc, buffer);
            }
            pm_serialize_location(parser, &((pm_keyword_rest_parameter_node_t *)node)->operator_loc, buffer);
            break;
        }
        case PM_LAMBDA_NODE: {
            uint32_t locals_size = pm_sizet_to_u32(((pm_lambda_node_t *)node)->locals.size);
            pm_buffer_append_varuint(buffer, locals_size);
            for (uint32_t index = 0; index < locals_size; index++) {
                pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_lambda_node_t *)node)->locals.ids[index]));
            }
            pm_serialize_location(parser, &((pm_lambda_node_t *)node)->operator_loc, buffer);
            pm_serialize_location(parser, &((pm_lambda_node_t *)node)->opening_loc, buffer);
            pm_serialize_location(parser, &((pm_lambda_node_t *)node)->closing_loc, buffer);
            if (((pm_lambda_node_t *)node)->parameters == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_lambda_node_t *)node)->parameters, buffer);
            }
            if (((pm_lambda_node_t *)node)->body == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_lambda_node_t *)node)->body, buffer);
            }
            break;
        }
        case PM_LOCAL_VARIABLE_AND_WRITE_NODE: {
            pm_serialize_location(parser, &((pm_local_variable_and_write_node_t *)node)->name_loc, buffer);
            pm_serialize_location(parser, &((pm_local_variable_and_write_node_t *)node)->operator_loc, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_local_variable_and_write_node_t *)node)->value, buffer);
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_local_variable_and_write_node_t *)node)->name));
            pm_buffer_append_varuint(buffer, ((pm_local_variable_and_write_node_t *)node)->depth);
            break;
        }
        case PM_LOCAL_VARIABLE_OPERATOR_WRITE_NODE: {
            pm_serialize_location(parser, &((pm_local_variable_operator_write_node_t *)node)->name_loc, buffer);
            pm_serialize_location(parser, &((pm_local_variable_operator_write_node_t *)node)->binary_operator_loc, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_local_variable_operator_write_node_t *)node)->value, buffer);
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_local_variable_operator_write_node_t *)node)->name));
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_local_variable_operator_write_node_t *)node)->binary_operator));
            pm_buffer_append_varuint(buffer, ((pm_local_variable_operator_write_node_t *)node)->depth);
            break;
        }
        case PM_LOCAL_VARIABLE_OR_WRITE_NODE: {
            pm_serialize_location(parser, &((pm_local_variable_or_write_node_t *)node)->name_loc, buffer);
            pm_serialize_location(parser, &((pm_local_variable_or_write_node_t *)node)->operator_loc, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_local_variable_or_write_node_t *)node)->value, buffer);
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_local_variable_or_write_node_t *)node)->name));
            pm_buffer_append_varuint(buffer, ((pm_local_variable_or_write_node_t *)node)->depth);
            break;
        }
        case PM_LOCAL_VARIABLE_READ_NODE: {
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_local_variable_read_node_t *)node)->name));
            pm_buffer_append_varuint(buffer, ((pm_local_variable_read_node_t *)node)->depth);
            break;
        }
        case PM_LOCAL_VARIABLE_TARGET_NODE: {
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_local_variable_target_node_t *)node)->name));
            pm_buffer_append_varuint(buffer, ((pm_local_variable_target_node_t *)node)->depth);
            break;
        }
        case PM_LOCAL_VARIABLE_WRITE_NODE: {
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_local_variable_write_node_t *)node)->name));
            pm_buffer_append_varuint(buffer, ((pm_local_variable_write_node_t *)node)->depth);
            pm_serialize_location(parser, &((pm_local_variable_write_node_t *)node)->name_loc, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_local_variable_write_node_t *)node)->value, buffer);
            pm_serialize_location(parser, &((pm_local_variable_write_node_t *)node)->operator_loc, buffer);
            break;
        }
        case PM_MATCH_LAST_LINE_NODE: {
            pm_buffer_append_varuint(buffer, (uint32_t)(node->flags & ~PM_NODE_FLAG_COMMON_MASK));
            pm_serialize_location(parser, &((pm_match_last_line_node_t *)node)->opening_loc, buffer);
            pm_serialize_location(parser, &((pm_match_last_line_node_t *)node)->content_loc, buffer);
            pm_serialize_location(parser, &((pm_match_last_line_node_t *)node)->closing_loc, buffer);
            pm_serialize_string(parser, &((pm_match_last_line_node_t *)node)->unescaped, buffer);
            break;
        }
        case PM_MATCH_PREDICATE_NODE: {
            pm_serialize_node(parser, (pm_node_t *)((pm_match_predicate_node_t *)node)->value, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_match_predicate_node_t *)node)->pattern, buffer);
            pm_serialize_location(parser, &((pm_match_predicate_node_t *)node)->operator_loc, buffer);
            break;
        }
        case PM_MATCH_REQUIRED_NODE: {
            pm_serialize_node(parser, (pm_node_t *)((pm_match_required_node_t *)node)->value, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_match_required_node_t *)node)->pattern, buffer);
            pm_serialize_location(parser, &((pm_match_required_node_t *)node)->operator_loc, buffer);
            break;
        }
        case PM_MATCH_WRITE_NODE: {
            pm_serialize_node(parser, (pm_node_t *)((pm_match_write_node_t *)node)->call, buffer);
            uint32_t targets_size = pm_sizet_to_u32(((pm_match_write_node_t *)node)->targets.size);
            pm_buffer_append_varuint(buffer, targets_size);
            for (uint32_t index = 0; index < targets_size; index++) {
                pm_serialize_node(parser, (pm_node_t *) ((pm_match_write_node_t *)node)->targets.nodes[index], buffer);
            }
            break;
        }
        case PM_MISSING_NODE: {
            break;
        }
        case PM_MODULE_NODE: {
            uint32_t locals_size = pm_sizet_to_u32(((pm_module_node_t *)node)->locals.size);
            pm_buffer_append_varuint(buffer, locals_size);
            for (uint32_t index = 0; index < locals_size; index++) {
                pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_module_node_t *)node)->locals.ids[index]));
            }
            pm_serialize_location(parser, &((pm_module_node_t *)node)->module_keyword_loc, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_module_node_t *)node)->constant_path, buffer);
            if (((pm_module_node_t *)node)->body == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_module_node_t *)node)->body, buffer);
            }
            pm_serialize_location(parser, &((pm_module_node_t *)node)->end_keyword_loc, buffer);
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_module_node_t *)node)->name));
            break;
        }
        case PM_MULTI_TARGET_NODE: {
            uint32_t lefts_size = pm_sizet_to_u32(((pm_multi_target_node_t *)node)->lefts.size);
            pm_buffer_append_varuint(buffer, lefts_size);
            for (uint32_t index = 0; index < lefts_size; index++) {
                pm_serialize_node(parser, (pm_node_t *) ((pm_multi_target_node_t *)node)->lefts.nodes[index], buffer);
            }
            if (((pm_multi_target_node_t *)node)->rest == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_multi_target_node_t *)node)->rest, buffer);
            }
            uint32_t rights_size = pm_sizet_to_u32(((pm_multi_target_node_t *)node)->rights.size);
            pm_buffer_append_varuint(buffer, rights_size);
            for (uint32_t index = 0; index < rights_size; index++) {
                pm_serialize_node(parser, (pm_node_t *) ((pm_multi_target_node_t *)node)->rights.nodes[index], buffer);
            }
            if (((pm_multi_target_node_t *)node)->lparen_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_multi_target_node_t *)node)->lparen_loc, buffer);
            }
            if (((pm_multi_target_node_t *)node)->rparen_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_multi_target_node_t *)node)->rparen_loc, buffer);
            }
            break;
        }
        case PM_MULTI_WRITE_NODE: {
            uint32_t lefts_size = pm_sizet_to_u32(((pm_multi_write_node_t *)node)->lefts.size);
            pm_buffer_append_varuint(buffer, lefts_size);
            for (uint32_t index = 0; index < lefts_size; index++) {
                pm_serialize_node(parser, (pm_node_t *) ((pm_multi_write_node_t *)node)->lefts.nodes[index], buffer);
            }
            if (((pm_multi_write_node_t *)node)->rest == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_multi_write_node_t *)node)->rest, buffer);
            }
            uint32_t rights_size = pm_sizet_to_u32(((pm_multi_write_node_t *)node)->rights.size);
            pm_buffer_append_varuint(buffer, rights_size);
            for (uint32_t index = 0; index < rights_size; index++) {
                pm_serialize_node(parser, (pm_node_t *) ((pm_multi_write_node_t *)node)->rights.nodes[index], buffer);
            }
            if (((pm_multi_write_node_t *)node)->lparen_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_multi_write_node_t *)node)->lparen_loc, buffer);
            }
            if (((pm_multi_write_node_t *)node)->rparen_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_multi_write_node_t *)node)->rparen_loc, buffer);
            }
            pm_serialize_location(parser, &((pm_multi_write_node_t *)node)->operator_loc, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_multi_write_node_t *)node)->value, buffer);
            break;
        }
        case PM_NEXT_NODE: {
            if (((pm_next_node_t *)node)->arguments == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_next_node_t *)node)->arguments, buffer);
            }
            pm_serialize_location(parser, &((pm_next_node_t *)node)->keyword_loc, buffer);
            break;
        }
        case PM_NIL_NODE: {
            break;
        }
        case PM_NO_KEYWORDS_PARAMETER_NODE: {
            pm_serialize_location(parser, &((pm_no_keywords_parameter_node_t *)node)->operator_loc, buffer);
            pm_serialize_location(parser, &((pm_no_keywords_parameter_node_t *)node)->keyword_loc, buffer);
            break;
        }
        case PM_NUMBERED_PARAMETERS_NODE: {
            pm_buffer_append_byte(buffer, ((pm_numbered_parameters_node_t *)node)->maximum);
            break;
        }
        case PM_NUMBERED_REFERENCE_READ_NODE: {
            pm_buffer_append_varuint(buffer, ((pm_numbered_reference_read_node_t *)node)->number);
            break;
        }
        case PM_OPTIONAL_KEYWORD_PARAMETER_NODE: {
            pm_buffer_append_varuint(buffer, (uint32_t)(node->flags & ~PM_NODE_FLAG_COMMON_MASK));
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_optional_keyword_parameter_node_t *)node)->name));
            pm_serialize_location(parser, &((pm_optional_keyword_parameter_node_t *)node)->name_loc, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_optional_keyword_parameter_node_t *)node)->value, buffer);
            break;
        }
        case PM_OPTIONAL_PARAMETER_NODE: {
            pm_buffer_append_varuint(buffer, (uint32_t)(node->flags & ~PM_NODE_FLAG_COMMON_MASK));
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_optional_parameter_node_t *)node)->name));
            pm_serialize_location(parser, &((pm_optional_parameter_node_t *)node)->name_loc, buffer);
            pm_serialize_location(parser, &((pm_optional_parameter_node_t *)node)->operator_loc, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_optional_parameter_node_t *)node)->value, buffer);
            break;
        }
        case PM_OR_NODE: {
            pm_serialize_node(parser, (pm_node_t *)((pm_or_node_t *)node)->left, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_or_node_t *)node)->right, buffer);
            pm_serialize_location(parser, &((pm_or_node_t *)node)->operator_loc, buffer);
            break;
        }
        case PM_PARAMETERS_NODE: {
            uint32_t requireds_size = pm_sizet_to_u32(((pm_parameters_node_t *)node)->requireds.size);
            pm_buffer_append_varuint(buffer, requireds_size);
            for (uint32_t index = 0; index < requireds_size; index++) {
                pm_serialize_node(parser, (pm_node_t *) ((pm_parameters_node_t *)node)->requireds.nodes[index], buffer);
            }
            uint32_t optionals_size = pm_sizet_to_u32(((pm_parameters_node_t *)node)->optionals.size);
            pm_buffer_append_varuint(buffer, optionals_size);
            for (uint32_t index = 0; index < optionals_size; index++) {
                pm_serialize_node(parser, (pm_node_t *) ((pm_parameters_node_t *)node)->optionals.nodes[index], buffer);
            }
            if (((pm_parameters_node_t *)node)->rest == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_parameters_node_t *)node)->rest, buffer);
            }
            uint32_t posts_size = pm_sizet_to_u32(((pm_parameters_node_t *)node)->posts.size);
            pm_buffer_append_varuint(buffer, posts_size);
            for (uint32_t index = 0; index < posts_size; index++) {
                pm_serialize_node(parser, (pm_node_t *) ((pm_parameters_node_t *)node)->posts.nodes[index], buffer);
            }
            uint32_t keywords_size = pm_sizet_to_u32(((pm_parameters_node_t *)node)->keywords.size);
            pm_buffer_append_varuint(buffer, keywords_size);
            for (uint32_t index = 0; index < keywords_size; index++) {
                pm_serialize_node(parser, (pm_node_t *) ((pm_parameters_node_t *)node)->keywords.nodes[index], buffer);
            }
            if (((pm_parameters_node_t *)node)->keyword_rest == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_parameters_node_t *)node)->keyword_rest, buffer);
            }
            if (((pm_parameters_node_t *)node)->block == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_parameters_node_t *)node)->block, buffer);
            }
            break;
        }
        case PM_PARENTHESES_NODE: {
            if (((pm_parentheses_node_t *)node)->body == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_parentheses_node_t *)node)->body, buffer);
            }
            pm_serialize_location(parser, &((pm_parentheses_node_t *)node)->opening_loc, buffer);
            pm_serialize_location(parser, &((pm_parentheses_node_t *)node)->closing_loc, buffer);
            break;
        }
        case PM_PINNED_EXPRESSION_NODE: {
            pm_serialize_node(parser, (pm_node_t *)((pm_pinned_expression_node_t *)node)->expression, buffer);
            pm_serialize_location(parser, &((pm_pinned_expression_node_t *)node)->operator_loc, buffer);
            pm_serialize_location(parser, &((pm_pinned_expression_node_t *)node)->lparen_loc, buffer);
            pm_serialize_location(parser, &((pm_pinned_expression_node_t *)node)->rparen_loc, buffer);
            break;
        }
        case PM_PINNED_VARIABLE_NODE: {
            pm_serialize_node(parser, (pm_node_t *)((pm_pinned_variable_node_t *)node)->variable, buffer);
            pm_serialize_location(parser, &((pm_pinned_variable_node_t *)node)->operator_loc, buffer);
            break;
        }
        case PM_POST_EXECUTION_NODE: {
            if (((pm_post_execution_node_t *)node)->statements == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_post_execution_node_t *)node)->statements, buffer);
            }
            pm_serialize_location(parser, &((pm_post_execution_node_t *)node)->keyword_loc, buffer);
            pm_serialize_location(parser, &((pm_post_execution_node_t *)node)->opening_loc, buffer);
            pm_serialize_location(parser, &((pm_post_execution_node_t *)node)->closing_loc, buffer);
            break;
        }
        case PM_PRE_EXECUTION_NODE: {
            if (((pm_pre_execution_node_t *)node)->statements == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_pre_execution_node_t *)node)->statements, buffer);
            }
            pm_serialize_location(parser, &((pm_pre_execution_node_t *)node)->keyword_loc, buffer);
            pm_serialize_location(parser, &((pm_pre_execution_node_t *)node)->opening_loc, buffer);
            pm_serialize_location(parser, &((pm_pre_execution_node_t *)node)->closing_loc, buffer);
            break;
        }
        case PM_PROGRAM_NODE: {
            uint32_t locals_size = pm_sizet_to_u32(((pm_program_node_t *)node)->locals.size);
            pm_buffer_append_varuint(buffer, locals_size);
            for (uint32_t index = 0; index < locals_size; index++) {
                pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_program_node_t *)node)->locals.ids[index]));
            }
            pm_serialize_node(parser, (pm_node_t *)((pm_program_node_t *)node)->statements, buffer);
            break;
        }
        case PM_RANGE_NODE: {
            pm_buffer_append_varuint(buffer, (uint32_t)(node->flags & ~PM_NODE_FLAG_COMMON_MASK));
            if (((pm_range_node_t *)node)->left == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_range_node_t *)node)->left, buffer);
            }
            if (((pm_range_node_t *)node)->right == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_range_node_t *)node)->right, buffer);
            }
            pm_serialize_location(parser, &((pm_range_node_t *)node)->operator_loc, buffer);
            break;
        }
        case PM_RATIONAL_NODE: {
            pm_serialize_node(parser, (pm_node_t *)((pm_rational_node_t *)node)->numeric, buffer);
            break;
        }
        case PM_REDO_NODE: {
            break;
        }
        case PM_REGULAR_EXPRESSION_NODE: {
            pm_buffer_append_varuint(buffer, (uint32_t)(node->flags & ~PM_NODE_FLAG_COMMON_MASK));
            pm_serialize_location(parser, &((pm_regular_expression_node_t *)node)->opening_loc, buffer);
            pm_serialize_location(parser, &((pm_regular_expression_node_t *)node)->content_loc, buffer);
            pm_serialize_location(parser, &((pm_regular_expression_node_t *)node)->closing_loc, buffer);
            pm_serialize_string(parser, &((pm_regular_expression_node_t *)node)->unescaped, buffer);
            break;
        }
        case PM_REQUIRED_KEYWORD_PARAMETER_NODE: {
            pm_buffer_append_varuint(buffer, (uint32_t)(node->flags & ~PM_NODE_FLAG_COMMON_MASK));
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_required_keyword_parameter_node_t *)node)->name));
            pm_serialize_location(parser, &((pm_required_keyword_parameter_node_t *)node)->name_loc, buffer);
            break;
        }
        case PM_REQUIRED_PARAMETER_NODE: {
            pm_buffer_append_varuint(buffer, (uint32_t)(node->flags & ~PM_NODE_FLAG_COMMON_MASK));
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_required_parameter_node_t *)node)->name));
            break;
        }
        case PM_RESCUE_MODIFIER_NODE: {
            pm_serialize_node(parser, (pm_node_t *)((pm_rescue_modifier_node_t *)node)->expression, buffer);
            pm_serialize_location(parser, &((pm_rescue_modifier_node_t *)node)->keyword_loc, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_rescue_modifier_node_t *)node)->rescue_expression, buffer);
            break;
        }
        case PM_RESCUE_NODE: {
            pm_serialize_location(parser, &((pm_rescue_node_t *)node)->keyword_loc, buffer);
            uint32_t exceptions_size = pm_sizet_to_u32(((pm_rescue_node_t *)node)->exceptions.size);
            pm_buffer_append_varuint(buffer, exceptions_size);
            for (uint32_t index = 0; index < exceptions_size; index++) {
                pm_serialize_node(parser, (pm_node_t *) ((pm_rescue_node_t *)node)->exceptions.nodes[index], buffer);
            }
            if (((pm_rescue_node_t *)node)->operator_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_rescue_node_t *)node)->operator_loc, buffer);
            }
            if (((pm_rescue_node_t *)node)->reference == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_rescue_node_t *)node)->reference, buffer);
            }
            if (((pm_rescue_node_t *)node)->statements == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_rescue_node_t *)node)->statements, buffer);
            }
            if (((pm_rescue_node_t *)node)->consequent == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_rescue_node_t *)node)->consequent, buffer);
            }
            break;
        }
        case PM_REST_PARAMETER_NODE: {
            pm_buffer_append_varuint(buffer, (uint32_t)(node->flags & ~PM_NODE_FLAG_COMMON_MASK));
            pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_rest_parameter_node_t *)node)->name));
            if (((pm_rest_parameter_node_t *)node)->name_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_rest_parameter_node_t *)node)->name_loc, buffer);
            }
            pm_serialize_location(parser, &((pm_rest_parameter_node_t *)node)->operator_loc, buffer);
            break;
        }
        case PM_RETRY_NODE: {
            break;
        }
        case PM_RETURN_NODE: {
            pm_buffer_append_varuint(buffer, (uint32_t)(node->flags & ~PM_NODE_FLAG_COMMON_MASK));
            pm_serialize_location(parser, &((pm_return_node_t *)node)->keyword_loc, buffer);
            if (((pm_return_node_t *)node)->arguments == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_return_node_t *)node)->arguments, buffer);
            }
            break;
        }
        case PM_SELF_NODE: {
            break;
        }
        case PM_SHAREABLE_CONSTANT_NODE: {
            pm_buffer_append_varuint(buffer, (uint32_t)(node->flags & ~PM_NODE_FLAG_COMMON_MASK));
            pm_serialize_node(parser, (pm_node_t *)((pm_shareable_constant_node_t *)node)->write, buffer);
            break;
        }
        case PM_SINGLETON_CLASS_NODE: {
            uint32_t locals_size = pm_sizet_to_u32(((pm_singleton_class_node_t *)node)->locals.size);
            pm_buffer_append_varuint(buffer, locals_size);
            for (uint32_t index = 0; index < locals_size; index++) {
                pm_buffer_append_varuint(buffer, pm_sizet_to_u32(((pm_singleton_class_node_t *)node)->locals.ids[index]));
            }
            pm_serialize_location(parser, &((pm_singleton_class_node_t *)node)->class_keyword_loc, buffer);
            pm_serialize_location(parser, &((pm_singleton_class_node_t *)node)->operator_loc, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_singleton_class_node_t *)node)->expression, buffer);
            if (((pm_singleton_class_node_t *)node)->body == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_singleton_class_node_t *)node)->body, buffer);
            }
            pm_serialize_location(parser, &((pm_singleton_class_node_t *)node)->end_keyword_loc, buffer);
            break;
        }
        case PM_SOURCE_ENCODING_NODE: {
            break;
        }
        case PM_SOURCE_FILE_NODE: {
            pm_buffer_append_varuint(buffer, (uint32_t)(node->flags & ~PM_NODE_FLAG_COMMON_MASK));
            pm_serialize_string(parser, &((pm_source_file_node_t *)node)->filepath, buffer);
            break;
        }
        case PM_SOURCE_LINE_NODE: {
            break;
        }
        case PM_SPLAT_NODE: {
            pm_serialize_location(parser, &((pm_splat_node_t *)node)->operator_loc, buffer);
            if (((pm_splat_node_t *)node)->expression == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_splat_node_t *)node)->expression, buffer);
            }
            break;
        }
        case PM_STATEMENTS_NODE: {
            uint32_t body_size = pm_sizet_to_u32(((pm_statements_node_t *)node)->body.size);
            pm_buffer_append_varuint(buffer, body_size);
            for (uint32_t index = 0; index < body_size; index++) {
                pm_serialize_node(parser, (pm_node_t *) ((pm_statements_node_t *)node)->body.nodes[index], buffer);
            }
            break;
        }
        case PM_STRING_NODE: {
            pm_buffer_append_varuint(buffer, (uint32_t)(node->flags & ~PM_NODE_FLAG_COMMON_MASK));
            if (((pm_string_node_t *)node)->opening_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_string_node_t *)node)->opening_loc, buffer);
            }
            pm_serialize_location(parser, &((pm_string_node_t *)node)->content_loc, buffer);
            if (((pm_string_node_t *)node)->closing_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_string_node_t *)node)->closing_loc, buffer);
            }
            pm_serialize_string(parser, &((pm_string_node_t *)node)->unescaped, buffer);
            break;
        }
        case PM_SUPER_NODE: {
            pm_serialize_location(parser, &((pm_super_node_t *)node)->keyword_loc, buffer);
            if (((pm_super_node_t *)node)->lparen_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_super_node_t *)node)->lparen_loc, buffer);
            }
            if (((pm_super_node_t *)node)->arguments == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_super_node_t *)node)->arguments, buffer);
            }
            if (((pm_super_node_t *)node)->rparen_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_super_node_t *)node)->rparen_loc, buffer);
            }
            if (((pm_super_node_t *)node)->block == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_super_node_t *)node)->block, buffer);
            }
            break;
        }
        case PM_SYMBOL_NODE: {
            pm_buffer_append_varuint(buffer, (uint32_t)(node->flags & ~PM_NODE_FLAG_COMMON_MASK));
            if (((pm_symbol_node_t *)node)->opening_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_symbol_node_t *)node)->opening_loc, buffer);
            }
            if (((pm_symbol_node_t *)node)->value_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_symbol_node_t *)node)->value_loc, buffer);
            }
            if (((pm_symbol_node_t *)node)->closing_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_symbol_node_t *)node)->closing_loc, buffer);
            }
            pm_serialize_string(parser, &((pm_symbol_node_t *)node)->unescaped, buffer);
            break;
        }
        case PM_TRUE_NODE: {
            break;
        }
        case PM_UNDEF_NODE: {
            uint32_t names_size = pm_sizet_to_u32(((pm_undef_node_t *)node)->names.size);
            pm_buffer_append_varuint(buffer, names_size);
            for (uint32_t index = 0; index < names_size; index++) {
                pm_serialize_node(parser, (pm_node_t *) ((pm_undef_node_t *)node)->names.nodes[index], buffer);
            }
            pm_serialize_location(parser, &((pm_undef_node_t *)node)->keyword_loc, buffer);
            break;
        }
        case PM_UNLESS_NODE: {
            pm_serialize_location(parser, &((pm_unless_node_t *)node)->keyword_loc, buffer);
            pm_serialize_node(parser, (pm_node_t *)((pm_unless_node_t *)node)->predicate, buffer);
            if (((pm_unless_node_t *)node)->then_keyword_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_unless_node_t *)node)->then_keyword_loc, buffer);
            }
            if (((pm_unless_node_t *)node)->statements == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_unless_node_t *)node)->statements, buffer);
            }
            if (((pm_unless_node_t *)node)->consequent == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_unless_node_t *)node)->consequent, buffer);
            }
            if (((pm_unless_node_t *)node)->end_keyword_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_unless_node_t *)node)->end_keyword_loc, buffer);
            }
            break;
        }
        case PM_UNTIL_NODE: {
            pm_buffer_append_varuint(buffer, (uint32_t)(node->flags & ~PM_NODE_FLAG_COMMON_MASK));
            pm_serialize_location(parser, &((pm_until_node_t *)node)->keyword_loc, buffer);
            if (((pm_until_node_t *)node)->closing_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_until_node_t *)node)->closing_loc, buffer);
            }
            pm_serialize_node(parser, (pm_node_t *)((pm_until_node_t *)node)->predicate, buffer);
            if (((pm_until_node_t *)node)->statements == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_until_node_t *)node)->statements, buffer);
            }
            break;
        }
        case PM_WHEN_NODE: {
            pm_serialize_location(parser, &((pm_when_node_t *)node)->keyword_loc, buffer);
            uint32_t conditions_size = pm_sizet_to_u32(((pm_when_node_t *)node)->conditions.size);
            pm_buffer_append_varuint(buffer, conditions_size);
            for (uint32_t index = 0; index < conditions_size; index++) {
                pm_serialize_node(parser, (pm_node_t *) ((pm_when_node_t *)node)->conditions.nodes[index], buffer);
            }
            if (((pm_when_node_t *)node)->then_keyword_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_when_node_t *)node)->then_keyword_loc, buffer);
            }
            if (((pm_when_node_t *)node)->statements == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_when_node_t *)node)->statements, buffer);
            }
            break;
        }
        case PM_WHILE_NODE: {
            pm_buffer_append_varuint(buffer, (uint32_t)(node->flags & ~PM_NODE_FLAG_COMMON_MASK));
            pm_serialize_location(parser, &((pm_while_node_t *)node)->keyword_loc, buffer);
            if (((pm_while_node_t *)node)->closing_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_while_node_t *)node)->closing_loc, buffer);
            }
            pm_serialize_node(parser, (pm_node_t *)((pm_while_node_t *)node)->predicate, buffer);
            if (((pm_while_node_t *)node)->statements == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_while_node_t *)node)->statements, buffer);
            }
            break;
        }
        case PM_X_STRING_NODE: {
            pm_buffer_append_varuint(buffer, (uint32_t)(node->flags & ~PM_NODE_FLAG_COMMON_MASK));
            pm_serialize_location(parser, &((pm_x_string_node_t *)node)->opening_loc, buffer);
            pm_serialize_location(parser, &((pm_x_string_node_t *)node)->content_loc, buffer);
            pm_serialize_location(parser, &((pm_x_string_node_t *)node)->closing_loc, buffer);
            pm_serialize_string(parser, &((pm_x_string_node_t *)node)->unescaped, buffer);
            break;
        }
        case PM_YIELD_NODE: {
            pm_serialize_location(parser, &((pm_yield_node_t *)node)->keyword_loc, buffer);
            if (((pm_yield_node_t *)node)->lparen_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_yield_node_t *)node)->lparen_loc, buffer);
            }
            if (((pm_yield_node_t *)node)->arguments == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_serialize_node(parser, (pm_node_t *)((pm_yield_node_t *)node)->arguments, buffer);
            }
            if (((pm_yield_node_t *)node)->rparen_loc.start == NULL) {
                pm_buffer_append_byte(buffer, 0);
            } else {
                pm_buffer_append_byte(buffer, 1);
                pm_serialize_location(parser, &((pm_yield_node_t *)node)->rparen_loc, buffer);
            }
            break;
        }
    }
}

static void
pm_serialize_newline_list(pm_newline_list_t *list, pm_buffer_t *buffer) {
    uint32_t size = pm_sizet_to_u32(list->size);
    pm_buffer_append_varuint(buffer, size);

    for (uint32_t i = 0; i < size; i++) {
        uint32_t offset = pm_sizet_to_u32(list->offsets[i]);
        pm_buffer_append_varuint(buffer, offset);
    }
}

static void
pm_serialize_comment(pm_parser_t *parser, pm_comment_t *comment, pm_buffer_t *buffer) {
    // serialize type
    pm_buffer_append_byte(buffer, (uint8_t) comment->type);

    // serialize location
    pm_serialize_location(parser, &comment->location, buffer);
}

/**
 * Serialize the given list of comments to the given buffer.
 */
void
pm_serialize_comment_list(pm_parser_t *parser, pm_list_t *list, pm_buffer_t *buffer) {
    pm_buffer_append_varuint(buffer, pm_sizet_to_u32(pm_list_size(list)));

    pm_comment_t *comment;
    for (comment = (pm_comment_t *) list->head; comment != NULL; comment = (pm_comment_t *) comment->node.next) {
        pm_serialize_comment(parser, comment, buffer);
    }
}

static void
pm_serialize_magic_comment(pm_parser_t *parser, pm_magic_comment_t *magic_comment, pm_buffer_t *buffer) {
    // serialize key location
    pm_buffer_append_varuint(buffer, pm_ptrdifft_to_u32(magic_comment->key_start - parser->start));
    pm_buffer_append_varuint(buffer, pm_sizet_to_u32(magic_comment->key_length));

    // serialize value location
    pm_buffer_append_varuint(buffer, pm_ptrdifft_to_u32(magic_comment->value_start - parser->start));
    pm_buffer_append_varuint(buffer, pm_sizet_to_u32(magic_comment->value_length));
}

static void
pm_serialize_magic_comment_list(pm_parser_t *parser, pm_list_t *list, pm_buffer_t *buffer) {
    pm_buffer_append_varuint(buffer, pm_sizet_to_u32(pm_list_size(list)));

    pm_magic_comment_t *magic_comment;
    for (magic_comment = (pm_magic_comment_t *) list->head; magic_comment != NULL; magic_comment = (pm_magic_comment_t *) magic_comment->node.next) {
        pm_serialize_magic_comment(parser, magic_comment, buffer);
    }
}

static void
pm_serialize_data_loc(const pm_parser_t *parser, pm_buffer_t *buffer) {
    if (parser->data_loc.end == NULL) {
        pm_buffer_append_byte(buffer, 0);
    } else {
        pm_buffer_append_byte(buffer, 1);
        pm_serialize_location(parser, &parser->data_loc, buffer);
    }
}

static void
pm_serialize_diagnostic(pm_parser_t *parser, pm_diagnostic_t *diagnostic, pm_buffer_t *buffer) {
    // serialize the type
    pm_buffer_append_varuint(buffer, (uint32_t) diagnostic->diag_id);

    // serialize message
    size_t message_length = strlen(diagnostic->message);
    pm_buffer_append_varuint(buffer, pm_sizet_to_u32(message_length));
    pm_buffer_append_string(buffer, diagnostic->message, message_length);

    // serialize location
    pm_serialize_location(parser, &diagnostic->location, buffer);

    pm_buffer_append_byte(buffer, diagnostic->level);
}

static void
pm_serialize_diagnostic_list(pm_parser_t *parser, pm_list_t *list, pm_buffer_t *buffer) {
    pm_buffer_append_varuint(buffer, pm_sizet_to_u32(pm_list_size(list)));

    pm_diagnostic_t *diagnostic;
    for (diagnostic = (pm_diagnostic_t *) list->head; diagnostic != NULL; diagnostic = (pm_diagnostic_t *) diagnostic->node.next) {
        pm_serialize_diagnostic(parser, diagnostic, buffer);
    }
}

/**
 * Serialize the name of the encoding to the buffer.
 */
void
pm_serialize_encoding(const pm_encoding_t *encoding, pm_buffer_t *buffer) {
    size_t encoding_length = strlen(encoding->name);
    pm_buffer_append_varuint(buffer, pm_sizet_to_u32(encoding_length));
    pm_buffer_append_string(buffer, encoding->name, encoding_length);
}

static void
pm_serialize_metadata(pm_parser_t *parser, pm_buffer_t *buffer) {
    pm_serialize_encoding(parser->encoding, buffer);
    pm_buffer_append_varsint(buffer, parser->start_line);
    pm_serialize_newline_list(&parser->newline_list, buffer);
    pm_serialize_comment_list(parser, &parser->comment_list, buffer);
    pm_serialize_magic_comment_list(parser, &parser->magic_comment_list, buffer);
    pm_serialize_data_loc(parser, buffer);
    pm_serialize_diagnostic_list(parser, &parser->error_list, buffer);
    pm_serialize_diagnostic_list(parser, &parser->warning_list, buffer);
}

#line 271 "serialize.c.erb"
/**
 * Serialize the metadata, nodes, and constant pool.
 */
void
pm_serialize_content(pm_parser_t *parser, pm_node_t *node, pm_buffer_t *buffer) {
    pm_serialize_metadata(parser, buffer);

    // Here we're going to leave space for the offset of the constant pool in
    // the buffer.
    size_t offset = buffer->length;
    pm_buffer_append_zeroes(buffer, 4);

    // Next, encode the length of the constant pool.
    pm_buffer_append_varuint(buffer, parser->constant_pool.size);

    // Now we're going to serialize the content of the node.
    pm_serialize_node(parser, node, buffer);

    // Now we're going to serialize the offset of the constant pool back where
    // we left space for it.
    uint32_t length = pm_sizet_to_u32(buffer->length);
    memcpy(buffer->value + offset, &length, sizeof(uint32_t));

    // Now we're going to serialize the constant pool.
    offset = buffer->length;
    pm_buffer_append_zeroes(buffer, parser->constant_pool.size * 8);

    for (uint32_t index = 0; index < parser->constant_pool.capacity; index++) {
        pm_constant_pool_bucket_t *bucket = &parser->constant_pool.buckets[index];

        // If we find a constant at this index, serialize it at the correct
        // index in the buffer.
        if (bucket->id != 0) {
            pm_constant_t *constant = &parser->constant_pool.constants[bucket->id - 1];
            size_t buffer_offset = offset + ((((size_t)bucket->id) - 1) * 8);

            if (bucket->type == PM_CONSTANT_POOL_BUCKET_OWNED || bucket->type == PM_CONSTANT_POOL_BUCKET_CONSTANT) {
                // Since this is an owned or constant constant, we are going to
                // write its contents into the buffer after the constant pool.
                // So effectively in place of the source offset, we have a
                // buffer offset. We will add a leading 1 to indicate that this
                // is a buffer offset.
                uint32_t content_offset = pm_sizet_to_u32(buffer->length);
                uint32_t owned_mask = (uint32_t) (1 << 31);

                assert(content_offset < owned_mask);
                content_offset |= owned_mask;

                memcpy(buffer->value + buffer_offset, &content_offset, 4);
                pm_buffer_append_bytes(buffer, constant->start, constant->length);
            } else {
                // Since this is a shared constant, we are going to write its
                // source offset directly into the buffer.
                uint32_t source_offset = pm_ptrdifft_to_u32(constant->start - parser->start);
                memcpy(buffer->value + buffer_offset, &source_offset, 4);
            }

            // Now we can write the length of the constant into the buffer.
            uint32_t constant_length = pm_sizet_to_u32(constant->length);
            memcpy(buffer->value + buffer_offset + 4, &constant_length, 4);
        }
    }
}

static void
serialize_token(void *data, pm_parser_t *parser, pm_token_t *token) {
    pm_buffer_t *buffer = (pm_buffer_t *) data;

    pm_buffer_append_varuint(buffer, token->type);
    pm_buffer_append_varuint(buffer, pm_ptrdifft_to_u32(token->start - parser->start));
    pm_buffer_append_varuint(buffer, pm_ptrdifft_to_u32(token->end - token->start));
    pm_buffer_append_varuint(buffer, parser->lex_state);
}

/**
 * Lex the given source and serialize to the given buffer.
 */
PRISM_EXPORTED_FUNCTION void
pm_serialize_lex(pm_buffer_t *buffer, const uint8_t *source, size_t size, const char *data) {
    pm_options_t options = { 0 };
    pm_options_read(&options, data);

    pm_parser_t parser;
    pm_parser_init(&parser, source, size, &options);

    pm_lex_callback_t lex_callback = (pm_lex_callback_t) {
        .data = (void *) buffer,
        .callback = serialize_token,
    };

    parser.lex_callback = &lex_callback;
    pm_node_t *node = pm_parse(&parser);

    // Append 0 to mark end of tokens.
    pm_buffer_append_byte(buffer, 0);

    pm_serialize_metadata(&parser, buffer);

    pm_node_destroy(&parser, node);
    pm_parser_free(&parser);
    pm_options_free(&options);
}

/**
 * Parse and serialize both the AST and the tokens represented by the given
 * source to the given buffer.
 */
PRISM_EXPORTED_FUNCTION void
pm_serialize_parse_lex(pm_buffer_t *buffer, const uint8_t *source, size_t size, const char *data) {
    pm_options_t options = { 0 };
    pm_options_read(&options, data);

    pm_parser_t parser;
    pm_parser_init(&parser, source, size, &options);

    pm_lex_callback_t lex_callback = (pm_lex_callback_t) {
        .data = (void *) buffer,
        .callback = serialize_token,
    };

    parser.lex_callback = &lex_callback;
    pm_node_t *node = pm_parse(&parser);

    pm_buffer_append_byte(buffer, 0);
    pm_serialize(&parser, node, buffer);

    pm_node_destroy(&parser, node);
    pm_parser_free(&parser);
    pm_options_free(&options);
}

#endif
