/* -*-c-*-
 THIS FILE WAS AUTOGENERATED BY template/prelude.c.tmpl. DO NOT EDIT.

 sources: ./ast, ./dir, ./gc, ./numeric, ./io, ./marshal, ./pack, ./trace_point, ./warning, ./array, ./kernel, ./ractor, ./timev, ./nilclass, ./prelude, ./gem_prelude, ./yjit
*/
#include "internal.h"
#include "internal/warnings.h"
#include "iseq.h"
#include "ruby/ruby.h"
#include "vm_core.h"

COMPILER_WARNING_PUSH
#if __has_warning("-Wstring-concatenation")
COMPILER_WARNING_IGNORED(-Wstring-concatenation)
#endif

static const char prelude_name0[] = "<internal:ast>";
static const struct {
    char L0[488]; /* 1..95 */
    char L95[503]; /* 96..162 */
    char L162[338]; /* 163..191 */
} prelude_code0 = {
#line 1 "ast.rb"
""/* for ast.c */
""
""/* AbstractSyntaxTree provides methods to parse Ruby code into */
""/* abstract syntax trees. The nodes in the tree */
""/* are instances of RubyVM::AbstractSyntaxTree::Node. */
""/*  */
""/* This module is MRI specific as it exposes implementation details */
""/* of the MRI abstract syntax tree. */
""/*  */
""/* This module is experimental and its API is not stable, therefore it might */
""/* change without notice. As examples, the order of children nodes is not */
""/* guaranteed, the number of children nodes might change, there is no way to */
""/* access children nodes by name, etc. */
""/*  */
""/* If you are looking for a stable API or an API working under multiple Ruby */
""/* implementations, consider using the _parser_ gem or Ripper. If you would */
""/* like to make RubyVM::AbstractSyntaxTree stable, please join the discussion */
""/* at https://bugs.ruby-lang.org/issues/14844. */
""/*  */
"module RubyVM::AbstractSyntaxTree\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     RubyVM::AbstractSyntaxTree.parse(string) -> RubyVM::AbstractSyntaxTree::Node */
"\n"/*  */
"\n"/*  Parses the given _string_ into an abstract syntax tree, */
"\n"/*  returning the root node of that tree. */
"\n"/*  */
"\n"/*  SyntaxError is raised if the given _string_ is invalid syntax. */
"\n"/*  */
"\n"/*    RubyVM::AbstractSyntaxTree.parse("x = 1 + 2") */
"\n"/*    # => #<RubyVM::AbstractSyntaxTree::Node:SCOPE@1:0-1:9> */
"  def self.parse string, keep_script_lines: false\n"
"    Primitive.ast_s_parse string, keep_script_lines\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     RubyVM::AbstractSyntaxTree.parse_file(pathname) -> RubyVM::AbstractSyntaxTree::Node */
"\n"/*  */
"\n"/*   Reads the file from _pathname_, then parses it like ::parse, */
"\n"/*   returning the root node of the abstract syntax tree. */
"\n"/*  */
"\n"/*   SyntaxError is raised if _pathname_'s contents are not */
"\n"/*   valid Ruby syntax. */
"\n"/*  */
"\n"/*     RubyVM::AbstractSyntaxTree.parse_file("my-app/app.rb") */
"\n"/*     # => #<RubyVM::AbstractSyntaxTree::Node:SCOPE@1:0-31:3> */
"  def self.parse_file pathname, keep_script_lines: false\n"
"    Primitive.ast_s_parse_file pathname, keep_script_lines\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     RubyVM::AbstractSyntaxTree.of(proc)   -> RubyVM::AbstractSyntaxTree::Node */
"\n"/*     RubyVM::AbstractSyntaxTree.of(method) -> RubyVM::AbstractSyntaxTree::Node */
"\n"/*  */
"\n"/*   Returns AST nodes of the given _proc_ or _method_. */
"\n"/*  */
"\n"/*     RubyVM::AbstractSyntaxTree.of(proc {1 + 2}) */
"\n"/*     # => #<RubyVM::AbstractSyntaxTree::Node:SCOPE@1:35-1:42> */
"\n"/*  */
"\n"/*     def hello */
"\n"/*       puts "hello, world" */
"\n"/*     end */
"\n"/*  */
"\n"/*     RubyVM::AbstractSyntaxTree.of(method(:hello)) */
"\n"/*     # => #<RubyVM::AbstractSyntaxTree::Node:SCOPE@1:0-3:3> */
"  def self.of body, keep_script_lines: false\n"
"    Primitive.ast_s_of body, keep_script_lines\n"
"  end\n"
"\n"
"\n"/* RubyVM::AbstractSyntaxTree::Node instances are created by parse methods in */
"\n"/* RubyVM::AbstractSyntaxTree. */
"\n"/*  */
"\n"/* This class is MRI specific. */
"\n"/*  */
"  class Node\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.type -> symbol */
"\n"/*  */
"\n"/*  Returns the type of this node as a symbol. */
"\n"/*  */
"\n"/*    root = RubyVM::AbstractSyntaxTree.parse("x = 1 + 2") */
"\n"/*    root.type # => :SCOPE */
"\n"/*    lasgn = root.children[2] */
"\n"/*    lasgn.type # => :LASGN */
"\n"/*    call = lasgn.children[1] */
"\n"/*    call.type # => :OPCALL */
"    def type\n"
"      Primitive.ast_node_type\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.first_lineno -> integer */
"\n"/*  */
"\n"/*  The line number in the source code where this AST's text began. */
,
#line 96 "ast.rb"
"    def first_lineno\n"
"      Primitive.ast_node_first_lineno\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.first_column -> integer */
"\n"/*  */
"\n"/*  The column number in the source code where this AST's text began. */
"    def first_column\n"
"      Primitive.ast_node_first_column\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.last_lineno -> integer */
"\n"/*  */
"\n"/*  The line number in the source code where this AST's text ended. */
"    def last_lineno\n"
"      Primitive.ast_node_last_lineno\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.last_column -> integer */
"\n"/*  */
"\n"/*  The column number in the source code where this AST's text ended. */
"    def last_column\n"
"      Primitive.ast_node_last_column\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.children -> array */
"\n"/*  */
"\n"/*  Returns AST nodes under this one.  Each kind of node */
"\n"/*  has different children, depending on what kind of node it is. */
"\n"/*  */
"\n"/*  The returned array may contain other nodes or <code>nil</code>. */
"    def children\n"
"      Primitive.ast_node_children\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.inspect -> string */
"\n"/*  */
"\n"/*  Returns debugging information about this node as a string. */
"    def inspect\n"
"      Primitive.ast_node_inspect\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.node_id -> integer */
"\n"/*  */
"\n"/*  Returns an internal node_id number. */
"\n"/*  Note that this is an API for ruby internal use, debugging, */
"\n"/*  and research. Do not use this for any other purpose. */
"\n"/*  The compatibility is not guaranteed. */
"    def node_id\n"
"      Primitive.ast_node_node_id\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.script_lines -> array */
"\n"/*  */
"\n"/*  Returns the original source code as an array of lines. */
"\n"/*  */
"\n"/*  Note that this is an API for ruby internal use, debugging, */
"\n"/*  and research. Do not use this for any other purpose. */
"\n"/*  The compatibility is not guaranteed. */
"    def script_lines\n"
,
#line 163 "ast.rb"
"      Primitive.ast_node_script_lines\n"
"    end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     node.source -> string */
"\n"/*  */
"\n"/*  Returns the code fragment that corresponds to this AST. */
"\n"/*  */
"\n"/*  Note that this is an API for ruby internal use, debugging, */
"\n"/*  and research. Do not use this for any other purpose. */
"\n"/*  The compatibility is not guaranteed. */
"\n"/*  */
"\n"/*  Also note that this API may return an incomplete code fragment */
"\n"/*  that does not parse; for example, a here document following */
"\n"/*  an expression may be dropped. */
"    def source\n"
"      lines = script_lines\n"
"      if lines\n"
"        lines = lines[first_lineno - 1 .. last_lineno - 1]\n"
"        lines[-1] = lines[-1][0...last_column]\n"
"        lines[0] = lines[0][first_column..-1]\n"
"        lines.join\n"
"      else\n"
"        nil\n"
"      end\n"
"    end\n"
"  end\n"
"end\n"
#line 219 "miniprelude.c"
};

static const char prelude_name1[] = "<internal:dir>";
static const struct {
    char L0[508]; /* 1..191 */
    char L191[350]; /* 192..315 */
} prelude_code1 = {
#line 1 "dir.rb"
""/* Objects of class Dir are directory streams representing */
""/* directories in the underlying file system. They provide a variety */
""/* of ways to list directories and their contents. See also File. */
""/*  */
""/* The directory used in these examples contains the two regular files */
""/* (<code>config.h</code> and <code>main.rb</code>), the parent */
""/* directory (<code>..</code>), and the directory itself */
""/* (<code>.</code>). */
""/*  */
""/* == What's Here */
""/*  */
""/* First, what's elsewhere. \Class \Dir: */
""/*  */
""/* - Inherits from {class Object}[rdoc-ref:Object@What-27s+Here]. */
""/* - Includes {module Enumerable}[rdoc-ref:Enumerable@What-27s+Here], */
""/*   which provides dozens of additional methods. */
""/*  */
""/* Here, class \Dir provides methods that are useful for: */
""/*  */
""/* - {Reading}[rdoc-ref:Dir@Reading] */
""/* - {Setting}[rdoc-ref:Dir@Setting] */
""/* - {Querying}[rdoc-ref:Dir@Querying] */
""/* - {Iterating}[rdoc-ref:Dir@Iterating] */
""/* - {Other}[rdoc-ref:Dir@Other] */
""/*  */
""/* === Reading */
""/*  */
""/* - #close: Closes the directory stream for +self+. */
""/* - #pos=: Sets the position in the directory stream for +self+. */
""/* - #read: Reads and returns the next entry in the directory stream for +self+. */
""/* - #rewind: Sets the position in the directory stream for +self+ to the first entry. */
""/* - #seek: Sets the position in the directory stream for +self+ */
""/*   the entry at the given offset. */
""/*  */
""/* === Setting */
""/*  */
""/* - ::chdir: Changes the working directory of the current process */
""/*   to the given directory. */
""/* - ::chroot: Changes the file-system root for the current process */
""/*   to the given directory. */
""/*  */
""/* === Querying */
""/*  */
""/* - ::[]: Same as ::glob without the ability to pass flags. */
""/* - ::children: Returns an array of names of the children */
""/*   (both files and directories) of the given directory, */
""/*   but not including <tt>.</tt> or <tt>..</tt>. */
""/* - ::empty?: Returns whether the given path is an empty directory. */
""/* - ::entries: Returns an array of names of the children */
""/*   (both files and directories) of the given directory, */
""/*   including <tt>.</tt> and <tt>..</tt>. */
""/* - ::exist?: Returns whether the given path is a directory. */
""/* - ::getwd (aliased as #pwd): Returns the path to the current working directory. */
""/* - ::glob: Returns an array of file paths matching the given pattern and flags. */
""/* - ::home: Returns the home directory path for a given user or the current user. */
""/* - #children: Returns an array of names of the children */
""/*   (both files and directories) of +self+, */
""/*   but not including <tt>.</tt> or <tt>..</tt>. */
""/* - #fileno: Returns the integer file descriptor for +self+. */
""/* - #path (aliased as #to_path): Returns the path used to create +self+. */
""/* - #tell (aliased as #pos): Returns the integer position */
""/*   in the directory stream for +self+. */
""/*  */
""/* === Iterating */
""/*  */
""/* - ::each_child: Calls the given block with each entry in the given directory, */
""/*   but not including <tt>.</tt> or <tt>..</tt>. */
""/* - ::foreach: Calls the given block with each entryin the given directory, */
""/*   including <tt>.</tt> and <tt>..</tt>. */
""/* - #each: Calls the given block with each entry in +self+, */
""/*   including <tt>.</tt> and <tt>..</tt>. */
""/* - #each_child: Calls the given block with each entry in +self+, */
""/*   but not including <tt>.</tt> or <tt>..</tt>. */
""/*  */
""/* === Other */
""/*  */
""/* - ::mkdir: Creates a directory at the given path, with optional permissions. */
""/* - ::new: Returns a new \Dir for the given path, with optional encoding. */
""/* - ::open: Same as ::new, but if a block is given, yields the \Dir to the block, */
""/*   closing it upon block exit. */
""/* - ::unlink (aliased as ::delete and ::rmdir): Removes the given directory. */
""/* - #inspect: Returns a string description of +self+. */
"class Dir\n"
"\n"/* call-seq: */
"\n"/*    Dir.open( string ) -> aDir */
"\n"/*    Dir.open( string, encoding: enc ) -> aDir */
"\n"/*    Dir.open( string ) {| aDir | block } -> anObject */
"\n"/*    Dir.open( string, encoding: enc ) {| aDir | block } -> anObject */
"\n"/*  */
"\n"/* The optional <i>encoding</i> keyword argument specifies the encoding of the directory. */
"\n"/* If not specified, the filesystem encoding is used. */
"\n"/*  */
"\n"/* With no block, <code>open</code> is a synonym for Dir::new. If a */
"\n"/* block is present, it is passed <i>aDir</i> as a parameter. The */
"\n"/* directory is closed at the end of the block, and Dir::open returns */
"\n"/* the value of the block. */
"  def self.open(name, encoding: nil, &block)\n"
"    dir = Primitive.dir_s_open(name, encoding)\n"
"    if block\n"
"      begin\n"
"        yield dir\n"
"      ensure\n"
"        Primitive.dir_s_close(dir)\n"
"      end\n"
"    else\n"
"      dir\n"
"    end\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    Dir.new( string ) -> aDir */
"\n"/*    Dir.new( string, encoding: enc ) -> aDir */
"\n"/*  */
"\n"/* Returns a new directory object for the named directory. */
"\n"/*  */
"\n"/* The optional <i>encoding</i> keyword argument specifies the encoding of the directory. */
"\n"/* If not specified, the filesystem encoding is used. */
"  def initialize(name, encoding: nil)\n"
"    Primitive.dir_initialize(name, encoding)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    Dir[ string [, string ...] [, base: path] [, sort: true] ] -> array */
"\n"/*  */
"\n"/* Equivalent to calling */
"\n"/* <code>Dir.glob([</code><i>string,...</i><code>], 0)</code>. */
"  def self.[](*args, base: nil, sort: true)\n"
"    Primitive.dir_s_aref(args, base, sort)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    Dir.glob( pattern, [flags], [base: path] [, sort: true] )                       -> array */
"\n"/*    Dir.glob( pattern, [flags], [base: path] [, sort: true] ) { |filename| block }  -> nil */
"\n"/*  */
"\n"/* Expands +pattern+, which is a pattern string or an Array of pattern */
"\n"/* strings, and returns an array containing the matching filenames. */
"\n"/* If a block is given, calls the block once for each matching filename, */
"\n"/* passing the filename as a parameter to the block. */
"\n"/*  */
"\n"/* The optional +base+ keyword argument specifies the base directory for */
"\n"/* interpreting relative pathnames instead of the current working directory. */
"\n"/* As the results are not prefixed with the base directory name in this */
"\n"/* case, you will need to prepend the base directory name if you want real */
"\n"/* paths. */
"\n"/*  */
"\n"/* The results which matched single wildcard or character set are sorted in */
"\n"/* binary ascending order, unless +false+ is given as the optional +sort+ */
"\n"/* keyword argument.  The order of an Array of pattern strings and braces */
"\n"/* are preserved. */
"\n"/*  */
"\n"/* Note that the pattern is not a regexp, it's closer to a shell glob. */
"\n"/* See File::fnmatch for the meaning of the +flags+ parameter. */
"\n"/* Case sensitivity depends on your system (+File::FNM_CASEFOLD+ is ignored). */
"\n"/*  */
"\n"/* <code>*</code>:: */
"\n"/*   Matches any file. Can be restricted by other values in the glob. */
"\n"/*   Equivalent to <code>/.*\/mx</code> in regexp. */
"\n"/*  */
"\n"/*   <code>*</code>::     Matches all files */
"\n"/*   <code>c*</code>::    Matches all files beginning with <code>c</code> */
"\n"/*   <code>*c</code>::    Matches all files ending with <code>c</code> */
"\n"/*   <code>\*c\*</code>:: Match all files that have <code>c</code> in them */
"\n"/*                        (including at the beginning or end). */
"\n"/*  */
"\n"/*   Note, this will not match Unix-like hidden files (dotfiles).  In order */
"\n"/*   to include those in the match results, you must use the */
"\n"/*   File::FNM_DOTMATCH flag or something like <code>"{*,.*}"</code>. */
"\n"/*  */
"\n"/* <code>**</code>:: */
"\n"/*   Matches directories recursively if followed by <code>/</code>.  If */
"\n"/*   this path segment contains any other characters, it is the same as the */
"\n"/*   usual <code>*</code>. */
"\n"/*  */
"\n"/* <code>?</code>:: */
"\n"/*   Matches any one character. Equivalent to <code>/.{1}/</code> in regexp. */
"\n"/*  */
"\n"/* <code>[set]</code>:: */
"\n"/*   Matches any one character in +set+.  Behaves exactly like character sets */
"\n"/*   in Regexp, including set negation (<code>[^a-z]</code>). */
"\n"/*  */
"\n"/* <code>{p,q}</code>:: */
"\n"/*   Matches either literal <code>p</code> or literal <code>q</code>. */
"\n"/*   Equivalent to pattern alternation in regexp. */
"\n"/*  */
"\n"/*   Matching literals may be more than one character in length.  More than */
"\n"/*   two literals may be specified. */
"\n"/*  */
"\n"/* <code>\\</code>:: */
"\n"/*   Escapes the next metacharacter. */
"\n"/*  */
"\n"/*   Note that this means you cannot use backslash on windows as part of a */
,
#line 192 "dir.rb"
"\n"/*   glob, i.e.  <code>Dir["c:\\foo*"]</code> will not work, use */
"\n"/*   <code>Dir["c:/foo*"]</code> instead. */
"\n"/*  */
"\n"/* Examples: */
"\n"/*  */
"\n"/*    Dir["config.?"]                     #=> ["config.h"] */
"\n"/*    Dir.glob("config.?")                #=> ["config.h"] */
"\n"/*    Dir.glob("*.[a-z][a-z]")            #=> ["main.rb"] */
"\n"/*    Dir.glob("*.[^r]*")                 #=> ["config.h"] */
"\n"/*    Dir.glob("*.{rb,h}")                #=> ["main.rb", "config.h"] */
"\n"/*    Dir.glob("*")                       #=> ["config.h", "main.rb"] */
"\n"/*    Dir.glob("*", File::FNM_DOTMATCH)   #=> [".", "config.h", "main.rb"] */
"\n"/*    Dir.glob(["*.rb", "*.h"])           #=> ["main.rb", "config.h"] */
"\n"/*  */
"\n"/*    Dir.glob("**\/\*.rb")                 #=> ["main.rb", */
"\n"/*                                        #    "lib/song.rb", */
"\n"/*                                        #    "lib/song/karaoke.rb"] */
"\n"/*  */
"\n"/*    Dir.glob("**\/\*.rb", base: "lib")    #=> ["song.rb", */
"\n"/*                                        #    "song/karaoke.rb"] */
"\n"/*  */
"\n"/*    Dir.glob("**\/lib")                  #=> ["lib"] */
"\n"/*  */
"\n"/*    Dir.glob("**\/lib/\**\/\*.rb")          #=> ["lib/song.rb", */
"\n"/*                                        #    "lib/song/karaoke.rb"] */
"\n"/*  */
"\n"/*    Dir.glob("**\/lib/\*.rb")             #=> ["lib/song.rb"] */
"  def self.glob(pattern, _flags = 0, flags: _flags, base: nil, sort: true)\n"
"    Primitive.dir_s_glob(pattern, flags, base, sort)\n"
"  end\n"
"end\n"
"\n"
"class << File\n"
"\n"/* call-seq: */
"\n"/*    File.fnmatch( pattern, path, [flags] ) -> (true or false) */
"\n"/*    File.fnmatch?( pattern, path, [flags] ) -> (true or false) */
"\n"/*  */
"\n"/* Returns true if +path+ matches against +pattern+.  The pattern is not a */
"\n"/* regular expression; instead it follows rules similar to shell filename */
"\n"/* globbing.  It may contain the following metacharacters: */
"\n"/*  */
"\n"/* <code>*</code>:: */
"\n"/*   Matches any file. Can be restricted by other values in the glob. */
"\n"/*   Equivalent to <code>/.*\/x</code> in regexp. */
"\n"/*  */
"\n"/*   <code>*</code>::    Matches all regular files */
"\n"/*   <code>c*</code>::   Matches all files beginning with <code>c</code> */
"\n"/*   <code>*c</code>::   Matches all files ending with <code>c</code> */
"\n"/*   <code>\*c*</code>:: Matches all files that have <code>c</code> in them */
"\n"/*                       (including at the beginning or end). */
"\n"/*  */
"\n"/*   To match hidden files (that start with a <code>.</code>) set the */
"\n"/*   File::FNM_DOTMATCH flag. */
"\n"/*  */
"\n"/* <code>**</code>:: */
"\n"/*   Matches directories recursively or files expansively. */
"\n"/*  */
"\n"/* <code>?</code>:: */
"\n"/*   Matches any one character. Equivalent to <code>/.{1}/</code> in regexp. */
"\n"/*  */
"\n"/* <code>[set]</code>:: */
"\n"/*   Matches any one character in +set+.  Behaves exactly like character sets */
"\n"/*   in Regexp, including set negation (<code>[^a-z]</code>). */
"\n"/*  */
"\n"/* <code>\\</code>:: */
"\n"/*   Escapes the next metacharacter. */
"\n"/*  */
"\n"/* <code>{a,b}</code>:: */
"\n"/*   Matches pattern a and pattern b if File::FNM_EXTGLOB flag is enabled. */
"\n"/*   Behaves like a Regexp union (<code>(?:a|b)</code>). */
"\n"/*  */
"\n"/* +flags+ is a bitwise OR of the <code>FNM_XXX</code> constants. The same */
"\n"/* glob pattern and flags are used by Dir::glob. */
"\n"/*  */
"\n"/* Examples: */
"\n"/*  */
"\n"/*    File.fnmatch('cat',       'cat')        #=> true  # match entire string */
"\n"/*    File.fnmatch('cat',       'category')   #=> false # only match partial string */
"\n"/*  */
"\n"/*    File.fnmatch('c{at,ub}s', 'cats')                    #=> false # { } isn't supported by default */
"\n"/*    File.fnmatch('c{at,ub}s', 'cats', File::FNM_EXTGLOB) #=> true  # { } is supported on FNM_EXTGLOB */
"\n"/*  */
"\n"/*    File.fnmatch('c?t',     'cat')          #=> true  # '?' match only 1 character */
"\n"/*    File.fnmatch('c??t',    'cat')          #=> false # ditto */
"\n"/*    File.fnmatch('c*',      'cats')         #=> true  # '*' match 0 or more characters */
"\n"/*    File.fnmatch('c*t',     'c/a/b/t')      #=> true  # ditto */
"\n"/*    File.fnmatch('ca[a-z]', 'cat')          #=> true  # inclusive bracket expression */
"\n"/*    File.fnmatch('ca[^t]',  'cat')          #=> false # exclusive bracket expression ('^' or '!') */
"\n"/*  */
"\n"/*    File.fnmatch('cat', 'CAT')                     #=> false # case sensitive */
"\n"/*    File.fnmatch('cat', 'CAT', File::FNM_CASEFOLD) #=> true  # case insensitive */
"\n"/*    File.fnmatch('cat', 'CAT', File::FNM_SYSCASE)  #=> true or false # depends on the system default */
"\n"/*  */
"\n"/*    File.fnmatch('?',   '/', File::FNM_PATHNAME)  #=> false # wildcard doesn't match '/' on FNM_PATHNAME */
"\n"/*    File.fnmatch('*',   '/', File::FNM_PATHNAME)  #=> false # ditto */
"\n"/*    File.fnmatch('[/]', '/', File::FNM_PATHNAME)  #=> false # ditto */
"\n"/*  */
"\n"/*    File.fnmatch('\?',   '?')                       #=> true  # escaped wildcard becomes ordinary */
"\n"/*    File.fnmatch('\a',   'a')                       #=> true  # escaped ordinary remains ordinary */
"\n"/*    File.fnmatch('\a',   '\a', File::FNM_NOESCAPE)  #=> true  # FNM_NOESCAPE makes '\' ordinary */
"\n"/*    File.fnmatch('[\?]', '?')                       #=> true  # can escape inside bracket expression */
"\n"/*  */
"\n"/*    File.fnmatch('*',   '.profile')                      #=> false # wildcard doesn't match leading */
"\n"/*    File.fnmatch('*',   '.profile', File::FNM_DOTMATCH)  #=> true  # period by default. */
"\n"/*    File.fnmatch('.*',  '.profile')                      #=> true */
"\n"/*  */
"\n"/*    File.fnmatch('**\/\*.rb', 'main.rb')                  #=> false */
"\n"/*    File.fnmatch('**\/\*.rb', './main.rb')                #=> false */
"\n"/*    File.fnmatch('**\/\*.rb', 'lib/song.rb')              #=> true */
"\n"/*    File.fnmatch('**.rb', 'main.rb')                    #=> true */
"\n"/*    File.fnmatch('**.rb', './main.rb')                  #=> false */
"\n"/*    File.fnmatch('**.rb', 'lib/song.rb')                #=> true */
"\n"/*    File.fnmatch('*',     'dave/.profile')              #=> true */
"\n"/*  */
"\n"/*    File.fnmatch('**\/foo', 'a/b/c/foo', File::FNM_PATHNAME)     #=> true */
"\n"/*    File.fnmatch('**\/foo', '/a/b/c/foo', File::FNM_PATHNAME)    #=> true */
"\n"/*    File.fnmatch('**\/foo', 'c:/a/b/c/foo', File::FNM_PATHNAME)  #=> true */
"\n"/*    File.fnmatch('**\/foo', 'a/.b/c/foo', File::FNM_PATHNAME)    #=> false */
"\n"/*    File.fnmatch('**\/foo', 'a/.b/c/foo', File::FNM_PATHNAME | File::FNM_DOTMATCH) #=> true */
"  def fnmatch(pattern, path, flags = 0)\n"
"  end\n"
"  alias fnmatch? fnmatch\n"
"end if false\n"
#line 544 "miniprelude.c"
};

static const char prelude_name2[] = "<internal:gc>";
static const struct {
    char L0[479]; /* 1..58 */
    char L58[504]; /* 59..205 */
    char L205[483]; /* 206..299 */
    char L299[499]; /* 300..342 */
    char L342[296]; /* 343..355 */
} prelude_code2 = {
#line 1 "gc.rb"
""/* for gc.c */
""
""/*  The GC module provides an interface to Ruby's mark and */
""/*  sweep garbage collection mechanism. */
""/*  */
""/*  Some of the underlying methods are also available via the ObjectSpace */
""/*  module. */
""/*  */
""/*  You may obtain information about the operation of the GC through */
""/*  GC::Profiler. */
"module GC\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     GC.start                     -> nil */
"\n"/*     ObjectSpace.garbage_collect  -> nil */
"\n"/*     include GC; garbage_collect  -> nil */
"\n"/*     GC.start(full_mark: true, immediate_sweep: true)           -> nil */
"\n"/*     ObjectSpace.garbage_collect(full_mark: true, immediate_sweep: true) -> nil */
"\n"/*     include GC; garbage_collect(full_mark: true, immediate_sweep: true) -> nil */
"\n"/*  */
"\n"/*  Initiates garbage collection, even if manually disabled. */
"\n"/*  */
"\n"/*  This method is defined with keyword arguments that default to true: */
"\n"/*  */
"\n"/*     def GC.start(full_mark: true, immediate_sweep: true); end */
"\n"/*  */
"\n"/*  Use full_mark: false to perform a minor GC. */
"\n"/*  Use immediate_sweep: false to defer sweeping (use lazy sweep). */
"\n"/*  */
"\n"/*  Note: These keyword arguments are implementation and version dependent. They */
"\n"/*  are not guaranteed to be future-compatible, and may be ignored if the */
"\n"/*  underlying implementation does not support them. */
"  def self.start full_mark: true, immediate_mark: true, immediate_sweep: true\n"
"    Primitive.gc_start_internal full_mark, immediate_mark, immediate_sweep, false\n"
"  end\n"
"\n"
"  def garbage_collect full_mark: true, immediate_mark: true, immediate_sweep: true\n"
"    Primitive.gc_start_internal full_mark, immediate_mark, immediate_sweep, false\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     GC.auto_compact    -> true or false */
"\n"/*  */
"\n"/*  Returns whether or not automatic compaction has been enabled. */
"\n"/*  */
"  def self.auto_compact\n"
"    Primitive.gc_get_auto_compact\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     GC.auto_compact = flag */
"\n"/*  */
"\n"/*  Updates automatic compaction mode. */
"\n"/*  */
"\n"/*  When enabled, the compactor will execute on every major collection. */
"\n"/*  */
"\n"/*  Enabling compaction will degrade performance on major collections. */
"  def self.auto_compact=(flag)\n"
,
#line 59 "gc.rb"
"    Primitive.gc_set_auto_compact(flag)\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     GC.enable    -> true or false */
"\n"/*  */
"\n"/*  Enables garbage collection, returning +true+ if garbage */
"\n"/*  collection was previously disabled. */
"\n"/*  */
"\n"/*     GC.disable   #=> false */
"\n"/*     GC.enable    #=> true */
"\n"/*     GC.enable    #=> false */
"\n"/*  */
"  def self.enable\n"
"    Primitive.gc_enable\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     GC.disable    -> true or false */
"\n"/*  */
"\n"/*  Disables garbage collection, returning +true+ if garbage */
"\n"/*  collection was already disabled. */
"\n"/*  */
"\n"/*     GC.disable   #=> false */
"\n"/*     GC.disable   #=> true */
"  def self.disable\n"
"    Primitive.gc_disable\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*    GC.stress	    -> integer, true or false */
"\n"/*  */
"\n"/*  Returns current status of GC stress mode. */
"  def self.stress\n"
"    Primitive.gc_stress_get\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*    GC.stress = flag          -> flag */
"\n"/*  */
"\n"/*  Updates the GC stress mode. */
"\n"/*  */
"\n"/*  When stress mode is enabled, the GC is invoked at every GC opportunity: */
"\n"/*  all memory and object allocations. */
"\n"/*  */
"\n"/*  Enabling stress mode will degrade performance, it is only for debugging. */
"\n"/*  */
"\n"/*  flag can be true, false, or an integer bit-ORed following flags. */
"\n"/*    0x01:: no major GC */
"\n"/*    0x02:: no immediate sweep */
"\n"/*    0x04:: full mark after malloc/calloc/realloc */
"  def self.stress=(flag)\n"
"    Primitive.gc_stress_set_m flag\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     GC.count -> Integer */
"\n"/*  */
"\n"/*  The number of times GC occurred. */
"\n"/*  */
"\n"/*  It returns the number of times GC occurred since the process started. */
"  def self.count\n"
"    Primitive.gc_count\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     GC.stat -> Hash */
"\n"/*     GC.stat(hash) -> Hash */
"\n"/*     GC.stat(:key) -> Numeric */
"\n"/*  */
"\n"/*  Returns a Hash containing information about the GC. */
"\n"/*  */
"\n"/*  The contents of the hash are implementation specific and may change in */
"\n"/*  the future without notice. */
"\n"/*  */
"\n"/*  The hash includes information about internal statistics about GC such as: */
"\n"/*  */
"\n"/*  [count] */
"\n"/*    The total number of garbage collections ran since application start */
"\n"/*    (count includes both minor and major garbage collections) */
"\n"/*  [time] */
"\n"/*    The total time spent in garbage collections (in milliseconds) */
"\n"/*  [heap_allocated_pages] */
"\n"/*    The total number of `:heap_eden_pages` + `:heap_tomb_pages` */
"\n"/*  [heap_sorted_length] */
"\n"/*    The number of pages that can fit into the buffer that holds references to */
"\n"/*    all pages */
"\n"/*  [heap_allocatable_pages] */
"\n"/*    The total number of pages the application could allocate without additional GC */
"\n"/*  [heap_available_slots] */
"\n"/*    The total number of slots in all `:heap_allocated_pages` */
"\n"/*  [heap_live_slots] */
"\n"/*    The total number of slots which contain live objects */
"\n"/*  [heap_free_slots] */
"\n"/*    The total number of slots which do not contain live objects */
"\n"/*  [heap_final_slots] */
"\n"/*    The total number of slots with pending finalizers to be run */
"\n"/*  [heap_marked_slots] */
"\n"/*    The total number of objects marked in the last GC */
"\n"/*  [heap_eden_pages] */
"\n"/*    The total number of pages which contain at least one live slot */
"\n"/*  [heap_tomb_pages] */
"\n"/*    The total number of pages which do not contain any live slots */
"\n"/*  [total_allocated_pages] */
"\n"/*    The cumulative number of pages allocated since application start */
"\n"/*  [total_freed_pages] */
"\n"/*    The cumulative number of pages freed since application start */
"\n"/*  [total_allocated_objects] */
"\n"/*    The cumulative number of objects allocated since application start */
"\n"/*  [total_freed_objects] */
"\n"/*    The cumulative number of objects freed since application start */
"\n"/*  [malloc_increase_bytes] */
"\n"/*    Amount of memory allocated on the heap for objects. Decreased by any GC */
"\n"/*  [malloc_increase_bytes_limit] */
"\n"/*    When `:malloc_increase_bytes` crosses this limit, GC is triggered */
"\n"/*  [minor_gc_count] */
"\n"/*    The total number of minor garbage collections run since process start */
"\n"/*  [major_gc_count] */
"\n"/*    The total number of major garbage collections run since process start */
"\n"/*  [compact_count] */
"\n"/*    The total number of compactions run since process start */
"\n"/*  [read_barrier_faults] */
"\n"/*    The total number of times the read barrier was triggered during */
"\n"/*    compaction */
"\n"/*  [total_moved_objects] */
"\n"/*    The total number of objects compaction has moved */
"\n"/*  [remembered_wb_unprotected_objects] */
"\n"/*    The total number of objects without write barriers */
"\n"/*  [remembered_wb_unprotected_objects_limit] */
"\n"/*    When `:remembered_wb_unprotected_objects` crosses this limit, */
"\n"/*    major GC is triggered */
"\n"/*  [old_objects] */
"\n"/*    Number of live, old objects which have survived at least 3 garbage collections */
"\n"/*  [old_objects_limit] */
"\n"/*    When `:old_objects` crosses this limit, major GC is triggered */
"\n"/*  [oldmalloc_increase_bytes] */
"\n"/*    Amount of memory allocated on the heap for objects. Decreased by major GC */
"\n"/*  [oldmalloc_increase_bytes_limit] */
"\n"/*    When `:old_malloc_increase_bytes` crosses this limit, major GC is triggered */
"\n"/*  */
"\n"/*  If the optional argument, hash, is given, */
"\n"/*  it is overwritten and returned. */
"\n"/*  This is intended to avoid probe effect. */
"\n"/*  */
"\n"/*  This method is only expected to work on CRuby. */
"  def self.stat hash_or_key = nil\n"
"    Primitive.gc_stat hash_or_key\n"
,
#line 206 "gc.rb"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    GC.stat_heap -> Hash */
"\n"/*    GC.stat_heap(nil, hash) -> Hash */
"\n"/*    GC.stat_heap(heap_name) -> Hash */
"\n"/*    GC.stat_heap(heap_name, hash) -> Hash */
"\n"/*    GC.stat_heap(heap_name, :key) -> Numeric */
"\n"/*  */
"\n"/* Returns information for memory pools in the GC. */
"\n"/*  */
"\n"/* If the first optional argument, +heap_name+, is passed in and not +nil+, it */
"\n"/* returns a +Hash+ containing information about the particular memory pool. */
"\n"/* Otherwise, it will return a +Hash+ with memory pool names as keys and */
"\n"/* a +Hash+ containing information about the memory pool as values. */
"\n"/*  */
"\n"/* If the second optional argument, +hash_or_key+, is given as +Hash+, it will */
"\n"/* be overwritten and returned. This is intended to avoid the probe effect. */
"\n"/*  */
"\n"/* If both optional arguments are passed in and the second optional argument is */
"\n"/* a symbol, it will return a +Numeric+ of the value for the particular memory */
"\n"/* pool. */
"\n"/*  */
"\n"/* On CRuby, +heap_name+ is of the type +Integer+ but may be of type +String+ */
"\n"/* on other implementations. */
"\n"/*  */
"\n"/* The contents of the hash are implementation specific and may change in */
"\n"/* the future without notice. */
"\n"/*  */
"\n"/* If the optional argument, hash, is given, it is overwritten and returned. */
"\n"/*  */
"\n"/* This method is only expected to work on CRuby. */
"  def self.stat_heap heap_name = nil, hash_or_key = nil\n"
"    Primitive.gc_stat_heap heap_name, hash_or_key\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     GC.latest_gc_info -> {:gc_by=>:newobj} */
"\n"/*     GC.latest_gc_info(hash) -> hash */
"\n"/*     GC.latest_gc_info(:major_by) -> :malloc */
"\n"/*  */
"\n"/*  Returns information about the most recent garbage collection. */
"\n"/*  */
"\n"/* If the optional argument, hash, is given, */
"\n"/* it is overwritten and returned. */
"\n"/* This is intended to avoid probe effect. */
"  def self.latest_gc_info hash_or_key = nil\n"
"    Primitive.gc_latest_gc_info hash_or_key\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     GC.latest_compact_info -> {:considered=>{:T_CLASS=>11}, :moved=>{:T_CLASS=>11}} */
"\n"/*  */
"\n"/*  Returns information about object moved in the most recent GC compaction. */
"\n"/*  */
"\n"/* The returned hash has two keys :considered and :moved.  The hash for */
"\n"/* :considered lists the number of objects that were considered for movement */
"\n"/* by the compactor, and the :moved hash lists the number of objects that */
"\n"/* were actually moved.  Some objects can't be moved (maybe they were pinned) */
"\n"/* so these numbers can be used to calculate compaction efficiency. */
"  def self.latest_compact_info\n"
"    Primitive.gc_compact_stats\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     GC.compact */
"\n"/*  */
"\n"/* This function compacts objects together in Ruby's heap.  It eliminates */
"\n"/* unused space (or fragmentation) in the heap by moving objects in to that */
"\n"/* unused space.  This function returns a hash which contains statistics about */
"\n"/* which objects were moved.  See `GC.latest_gc_info` for details about */
"\n"/* compaction statistics. */
"\n"/*  */
"\n"/* This method is implementation specific and not expected to be implemented */
"\n"/* in any implementation besides MRI. */
"  def self.compact\n"
"    Primitive.gc_compact\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    GC.verify_compaction_references(toward: nil, double_heap: false) -> hash */
"\n"/*  */
"\n"/* Verify compaction reference consistency. */
"\n"/*  */
"\n"/* This method is implementation specific.  During compaction, objects that */
"\n"/* were moved are replaced with T_MOVED objects.  No object should have a */
"\n"/* reference to a T_MOVED object after compaction. */
"\n"/*  */
"\n"/* This function doubles the heap to ensure room to move all objects, */
"\n"/* compacts the heap to make sure everything moves, updates all references, */
"\n"/* then performs a full GC.  If any object contains a reference to a T_MOVED */
"\n"/* object, that object should be pushed on the mark stack, and will */
"\n"/* make a SEGV. */
"  def self.verify_compaction_references(toward: nil, double_heap: false)\n"
,
#line 300 "gc.rb"
"    Primitive.gc_verify_compaction_references(double_heap, toward == :empty)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*     GC.using_rvargc? -> true or false */
"\n"/*  */
"\n"/* Returns true if using experimental feature Variable Width Allocation, false */
"\n"/* otherwise. */
"  def self.using_rvargc?\n"/* :nodoc: */
"    GC::INTERNAL_CONSTANTS[:SIZE_POOL_COUNT] > 1\n"
"  end\n"
"\n"
"\n"
"\n"/* call-seq: */
"\n"/*    GC.measure_total_time = true/false */
"\n"/*  */
"\n"/* Enable to measure GC time. */
"\n"/* You can get the result with <tt>GC.stat(:time)</tt>. */
"\n"/* Note that GC time measurement can cause some performance overhead. */
"  def self.measure_total_time=(flag)\n"
"    Primitive.cstmt! %{\n"
"      rb_objspace.flags.measure_gc = RTEST(flag) ? TRUE : FALSE;\n"
"      return flag;\n"
"    }\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    GC.measure_total_time -> true/false */
"\n"/*  */
"\n"/* Return measure_total_time flag (default: +true+). */
"\n"/* Note that measurement can affect the application performance. */
"  def self.measure_total_time\n"
"    Primitive.cexpr! %{\n"
"      RBOOL(rb_objspace.flags.measure_gc)\n"
"    }\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    GC.total_time -> int */
"\n"/*  */
"\n"/* Return measured GC total time in nano seconds. */
"  def self.total_time\n"
"    Primitive.cexpr! %{\n"
,
#line 343 "gc.rb"
"      ULL2NUM(rb_objspace.profile.total_time_ns)\n"
"    }\n"
"  end\n"
"end\n"
"\n"
"module ObjectSpace\n"
"  def garbage_collect full_mark: true, immediate_mark: true, immediate_sweep: true\n"
"    Primitive.gc_start_internal full_mark, immediate_mark, immediate_sweep, false\n"
"  end\n"
"\n"
"  module_function :garbage_collect\n"
"end\n"
#line 918 "miniprelude.c"
};

static const char prelude_name3[] = "<internal:numeric>";
static const struct {
    char L0[508]; /* 1..102 */
    char L102[504]; /* 103..180 */
    char L180[508]; /* 181..270 */
    char L270[507]; /* 271..326 */
    char L326[111]; /* 327..333 */
} prelude_code3 = {
#line 1 "numeric.rb"
"class Numeric\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     num.real?  ->  true or false */
"\n"/*  */
"\n"/*  Returns +true+ if +num+ is a real number (i.e. not Complex). */
"\n"/*  */
"  def real?\n"
"    return true\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     num.integer?  ->  true or false */
"\n"/*  */
"\n"/*  Returns +true+ if +num+ is an Integer. */
"\n"/*  */
"\n"/*      1.0.integer?   #=> false */
"\n"/*      1.integer?     #=> true */
"\n"/*  */
"  def integer?\n"
"    return false\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     num.finite?  ->  true or false */
"\n"/*  */
"\n"/*  Returns +true+ if +num+ is a finite number, otherwise returns +false+. */
"\n"/*  */
"  def finite?\n"
"    return true\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     num.infinite?  ->  -1, 1, or nil */
"\n"/*  */
"\n"/*  Returns +nil+, -1, or 1 depending on whether the value is */
"\n"/*  finite, <code>-Infinity</code>, or <code>+Infinity</code>. */
"\n"/*  */
"  def infinite?\n"
"    return nil\n"
"  end\n"
"end\n"
"\n"
"class Integer\n"
"\n"/* call-seq: */
"\n"/*    -int  ->  integer */
"\n"/*  */
"\n"/* Returns +int+, negated. */
"  def -@\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_int_uminus(self)'\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*   ~int  ->  integer */
"\n"/*  */
"\n"/* One's complement: returns a number where each bit is flipped. */
"\n"/*  */
"\n"/* Inverts the bits in an Integer. As integers are conceptually of */
"\n"/* infinite length, the result acts as if it had an infinite number of */
"\n"/* one bits to the left. In hex representations, this is displayed */
"\n"/* as two periods to the left of the digits. */
"\n"/*  */
"\n"/*   sprintf("%X", ~0x1122334455)    #=> "..FEEDDCCBBAA" */
"  def ~\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_int_comp(self)'\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    int.abs        ->  integer */
"\n"/*    int.magnitude  ->  integer */
"\n"/*  */
"\n"/* Returns the absolute value of +int+. */
"\n"/*  */
"\n"/*    (-12345).abs   #=> 12345 */
"\n"/*    -12345.abs     #=> 12345 */
"\n"/*    12345.abs      #=> 12345 */
"\n"/*  */
"\n"/* Integer#magnitude is an alias for Integer#abs. */
"  def abs\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_int_abs(self)'\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    int.bit_length  ->  integer */
"\n"/*  */
"\n"/* Returns the number of bits of the value of +int+. */
"\n"/*  */
"\n"/* "Number of bits" means the bit position of the highest bit */
"\n"/* which is different from the sign bit */
"\n"/* (where the least significant bit has bit position 1). */
"\n"/* If there is no such bit (zero or minus one), zero is returned. */
"\n"/*  */
"\n"/* I.e. this method returns <i>ceil(log2(int < 0 ? -int : int+1))</i>. */
"\n"/*  */
"\n"/*    (-2**1000-1).bit_length   #=> 1001 */
"\n"/*    (-2**1000).bit_length     #=> 1000 */
,
#line 103 "numeric.rb"
"\n"/*    (-2**1000+1).bit_length   #=> 1000 */
"\n"/*    (-2**12-1).bit_length     #=> 13 */
"\n"/*    (-2**12).bit_length       #=> 12 */
"\n"/*    (-2**12+1).bit_length     #=> 12 */
"\n"/*    -0x101.bit_length         #=> 9 */
"\n"/*    -0x100.bit_length         #=> 8 */
"\n"/*    -0xff.bit_length          #=> 8 */
"\n"/*    -2.bit_length             #=> 1 */
"\n"/*    -1.bit_length             #=> 0 */
"\n"/*    0.bit_length              #=> 0 */
"\n"/*    1.bit_length              #=> 1 */
"\n"/*    0xff.bit_length           #=> 8 */
"\n"/*    0x100.bit_length          #=> 9 */
"\n"/*    (2**12-1).bit_length      #=> 12 */
"\n"/*    (2**12).bit_length        #=> 13 */
"\n"/*    (2**12+1).bit_length      #=> 13 */
"\n"/*    (2**1000-1).bit_length    #=> 1000 */
"\n"/*    (2**1000).bit_length      #=> 1001 */
"\n"/*    (2**1000+1).bit_length    #=> 1001 */
"\n"/*  */
"\n"/* This method can be used to detect overflow in Array#pack as follows: */
"\n"/*  */
"\n"/*    if n.bit_length < 32 */
"\n"/*      [n].pack("l") # no overflow */
"\n"/*    else */
"\n"/*      raise "overflow" */
"\n"/*    end */
"  def bit_length\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_int_bit_length(self)'\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     int.even?  ->  true or false */
"\n"/*  */
"\n"/*  Returns +true+ if +int+ is an even number. */
"  def even?\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_int_even_p(self)'\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     int.integer?  ->  true */
"\n"/*  */
"\n"/*  Since +int+ is already an Integer, this always returns +true+. */
"  def integer?\n"
"    return true\n"
"  end\n"
"\n"
"  alias magnitude abs\n"
"=begin\n"
"  def magnitude\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_int_abs(self)'\n"
"  end\n"
"=end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     int.odd?  ->  true or false */
"\n"/*  */
"\n"/*  Returns +true+ if +int+ is an odd number. */
"  def odd?\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_int_odd_p(self)'\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     int.ord  ->  self */
"\n"/*  */
"\n"/*  Returns the +int+ itself. */
"\n"/*  */
"\n"/*     97.ord   #=> 97 */
"\n"/*  */
"\n"/*  This method is intended for compatibility to character literals */
"\n"/*  in Ruby 1.9. */
"\n"/*  */
"\n"/*  For example, <code>?a.ord</code> returns 97 both in 1.8 and 1.9. */
"  def ord\n"
,
#line 181 "numeric.rb"
"    return self\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  Document-method: Integer#size */
"\n"/*  call-seq: */
"\n"/*     int.size  ->  int */
"\n"/*  */
"\n"/*  Returns the number of bytes in the machine representation of +int+ */
"\n"/*  (machine dependent). */
"\n"/*  */
"\n"/*     1.size               #=> 8 */
"\n"/*     -1.size              #=> 8 */
"\n"/*     2147483647.size      #=> 8 */
"\n"/*     (256**10 - 1).size   #=> 10 */
"\n"/*     (256**20 - 1).size   #=> 20 */
"\n"/*     (256**40 - 1).size   #=> 40 */
"\n"/*  */
"  def size\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_int_size(self)'\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     int.to_i    ->  integer */
"\n"/*  */
"\n"/*  Since +int+ is already an Integer, returns +self+. */
"\n"/*  */
"\n"/*  #to_int is an alias for #to_i. */
"  def to_i\n"
"    return self\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*     int.to_int  ->  integer */
"\n"/*  */
"\n"/*  Since +int+ is already an Integer, returns +self+. */
"  def to_int\n"
"    return self\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    int.zero? -> true or false */
"\n"/*  */
"\n"/* Returns +true+ if +int+ has a zero value. */
"  def zero?\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_int_zero_p(self)'\n"
"  end\n"
"end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*    Integer.try_convert(object) -> object, integer, or nil */
"\n"/*  */
"\n"/*  If +object+ is an \Integer object, returns +object+. */
"\n"/*    Integer.try_convert(1) # => 1 */
"\n"/*  */
"\n"/*  Otherwise if +object+ responds to <tt>:to_int</tt>, */
"\n"/*  calls <tt>object.to_int</tt> and returns the result. */
"\n"/*    Integer.try_convert(1.25) # => 1 */
"\n"/*  */
"\n"/*  Returns +nil+ if +object+ does not respond to <tt>:to_int</tt> */
"\n"/*    Integer.try_convert([]) # => nil */
"\n"/*  */
"\n"/*  Raises an exception unless <tt>object.to_int</tt> returns an \Integer object. */
"\n"/*  */
"def Integer.try_convert(num)\n"
"=begin\n"
"  Primitive.attr! 'inline'\n"
"  Primitive.cexpr! 'rb_check_integer_type(num)'\n"
"=end\n"
"end if false\n"
"\n"
"class Float\n"
"\n"/*  */
"\n"/* call-seq: */
"\n"/*    float.to_f  ->  self */
"\n"/*  */
"\n"/* Since +float+ is already a Float, returns +self+. */
"\n"/*  */
"  def to_f\n"
"    return self\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     float.abs        ->  float */
"\n"/*     float.magnitude  ->  float */
"\n"/*  */
"\n"/*  Returns the absolute value of +float+. */
,
#line 271 "numeric.rb"
"\n"/*  */
"\n"/*     (-34.56).abs   #=> 34.56 */
"\n"/*     -34.56.abs     #=> 34.56 */
"\n"/*     34.56.abs      #=> 34.56 */
"\n"/*  */
"\n"/*  Float#magnitude is an alias for Float#abs. */
"\n"/*  */
"  def abs\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_float_abs(self)'\n"
"  end\n"
"\n"
"  def magnitude\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_float_abs(self)'\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/* call-seq: */
"\n"/*    -float  ->  float */
"\n"/*  */
"\n"/* Returns +float+, negated. */
"\n"/*  */
"  def -@\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_float_uminus(self)'\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     float.zero?  ->  true or false */
"\n"/*  */
"\n"/*  Returns +true+ if +float+ is 0.0. */
"\n"/*  */
"  def zero?\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'RBOOL(FLOAT_ZERO_P(self))'\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     float.positive?  ->  true or false */
"\n"/*  */
"\n"/*  Returns +true+ if +float+ is greater than 0. */
"\n"/*  */
"  def positive?\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'RBOOL(RFLOAT_VALUE(self) > 0.0)'\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     float.negative?  ->  true or false */
"\n"/*  */
"\n"/*  Returns +true+ if +float+ is less than 0. */
"\n"/*  */
,
#line 327 "numeric.rb"
"  def negative?\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'RBOOL(RFLOAT_VALUE(self) < 0.0)'\n"
"  end\n"
"\n"
"end\n"
#line 1270 "miniprelude.c"
};

static const char prelude_name4[] = "<internal:io>";
static const struct {
    char L0[336]; /* 1..124 */
} prelude_code4 = {
#line 1 "io.rb"
"class IO\n"
"\n"/* other IO methods are defined in io.c */
"\n"
"\n"/* call-seq: */
"\n"/*    ios.read_nonblock(maxlen [, options])              -> string */
"\n"/*    ios.read_nonblock(maxlen, outbuf [, options])      -> outbuf */
"\n"/*  */
"\n"/* Reads at most <i>maxlen</i> bytes from <em>ios</em> using */
"\n"/* the read(2) system call after O_NONBLOCK is set for */
"\n"/* the underlying file descriptor. */
"\n"/*  */
"\n"/* If the optional <i>outbuf</i> argument is present, */
"\n"/* it must reference a String, which will receive the data. */
"\n"/* The <i>outbuf</i> will contain only the received data after the method call */
"\n"/* even if it is not empty at the beginning. */
"\n"/*  */
"\n"/* read_nonblock just calls the read(2) system call. */
"\n"/* It causes all errors the read(2) system call causes: Errno::EWOULDBLOCK, Errno::EINTR, etc. */
"\n"/* The caller should care such errors. */
"\n"/*  */
"\n"/* If the exception is Errno::EWOULDBLOCK or Errno::EAGAIN, */
"\n"/* it is extended by IO::WaitReadable. */
"\n"/* So IO::WaitReadable can be used to rescue the exceptions for retrying */
"\n"/* read_nonblock. */
"\n"/*  */
"\n"/* read_nonblock causes EOFError on EOF. */
"\n"/*  */
"\n"/* On some platforms, such as Windows, non-blocking mode is not supported */
"\n"/* on IO objects other than sockets. In such cases, Errno::EBADF will */
"\n"/* be raised. */
"\n"/*  */
"\n"/* If the read byte buffer is not empty, */
"\n"/* read_nonblock reads from the buffer like readpartial. */
"\n"/* In this case, the read(2) system call is not called. */
"\n"/*  */
"\n"/* When read_nonblock raises an exception kind of IO::WaitReadable, */
"\n"/* read_nonblock should not be called */
"\n"/* until io is readable for avoiding busy loop. */
"\n"/* This can be done as follows. */
"\n"/*  */
"\n"/*   # emulates blocking read (readpartial). */
"\n"/*   begin */
"\n"/*     result = io.read_nonblock(maxlen) */
"\n"/*   rescue IO::WaitReadable */
"\n"/*     IO.select([io]) */
"\n"/*     retry */
"\n"/*   end */
"\n"/*  */
"\n"/* Although IO#read_nonblock doesn't raise IO::WaitWritable. */
"\n"/* OpenSSL::Buffering#read_nonblock can raise IO::WaitWritable. */
"\n"/* If IO and SSL should be used polymorphically, */
"\n"/* IO::WaitWritable should be rescued too. */
"\n"/* See the document of OpenSSL::Buffering#read_nonblock for sample code. */
"\n"/*  */
"\n"/* Note that this method is identical to readpartial */
"\n"/* except the non-blocking flag is set. */
"\n"/*  */
"\n"/* By specifying a keyword argument _exception_ to +false+, you can indicate */
"\n"/* that read_nonblock should not raise an IO::WaitReadable exception, but */
"\n"/* return the symbol +:wait_readable+ instead. At EOF, it will return nil */
"\n"/* instead of raising EOFError. */
"  def read_nonblock(len, buf = nil, exception: true)\n"
"    Primitive.io_read_nonblock(len, buf, exception)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    ios.write_nonblock(string)   -> integer */
"\n"/*    ios.write_nonblock(string [, options])   -> integer */
"\n"/*  */
"\n"/* Writes the given string to <em>ios</em> using */
"\n"/* the write(2) system call after O_NONBLOCK is set for */
"\n"/* the underlying file descriptor. */
"\n"/*  */
"\n"/* It returns the number of bytes written. */
"\n"/*  */
"\n"/* write_nonblock just calls the write(2) system call. */
"\n"/* It causes all errors the write(2) system call causes: Errno::EWOULDBLOCK, Errno::EINTR, etc. */
"\n"/* The result may also be smaller than string.length (partial write). */
"\n"/* The caller should care such errors and partial write. */
"\n"/*  */
"\n"/* If the exception is Errno::EWOULDBLOCK or Errno::EAGAIN, */
"\n"/* it is extended by IO::WaitWritable. */
"\n"/* So IO::WaitWritable can be used to rescue the exceptions for retrying write_nonblock. */
"\n"/*  */
"\n"/*   # Creates a pipe. */
"\n"/*   r, w = IO.pipe */
"\n"/*  */
"\n"/*   # write_nonblock writes only 65536 bytes and return 65536. */
"\n"/*   # (The pipe size is 65536 bytes on this environment.) */
"\n"/*   s = "a" * 100000 */
"\n"/*   p w.write_nonblock(s)     #=> 65536 */
"\n"/*  */
"\n"/*   # write_nonblock cannot write a byte and raise EWOULDBLOCK (EAGAIN). */
"\n"/*   p w.write_nonblock("b")   # Resource temporarily unavailable (Errno::EAGAIN) */
"\n"/*  */
"\n"/* If the write buffer is not empty, it is flushed at first. */
"\n"/*  */
"\n"/* When write_nonblock raises an exception kind of IO::WaitWritable, */
"\n"/* write_nonblock should not be called */
"\n"/* until io is writable for avoiding busy loop. */
"\n"/* This can be done as follows. */
"\n"/*  */
"\n"/*   begin */
"\n"/*     result = io.write_nonblock(string) */
"\n"/*   rescue IO::WaitWritable, Errno::EINTR */
"\n"/*     IO.select(nil, [io]) */
"\n"/*     retry */
"\n"/*   end */
"\n"/*  */
"\n"/* Note that this doesn't guarantee to write all data in string. */
"\n"/* The length written is reported as result and it should be checked later. */
"\n"/*  */
"\n"/* On some platforms such as Windows, write_nonblock is not supported */
"\n"/* according to the kind of the IO object. */
"\n"/* In such cases, write_nonblock raises <code>Errno::EBADF</code>. */
"\n"/*  */
"\n"/* By specifying a keyword argument _exception_ to +false+, you can indicate */
"\n"/* that write_nonblock should not raise an IO::WaitWritable exception, but */
"\n"/* return the symbol +:wait_writable+ instead. */
"  def write_nonblock(buf, exception: true)\n"
"    Primitive.io_write_nonblock(buf, exception)\n"
"  end\n"
"end\n"
#line 1401 "miniprelude.c"
};

static const char prelude_name5[] = "<internal:marshal>";
static const struct {
    char L0[202]; /* 1..41 */
} prelude_code5 = {
#line 1 "marshal.rb"
"module Marshal\n"
"\n"/* call-seq: */
"\n"/*    load(source, proc = nil, freeze: false) -> obj */
"\n"/*    restore(source, proc = nil, freeze: false) -> obj */
"\n"/*  */
"\n"/* Returns the result of converting the serialized data in source into a */
"\n"/* Ruby object (possibly with associated subordinate objects). source */
"\n"/* may be either an instance of IO or an object that responds to */
"\n"/* to_str. If proc is specified, each object will be passed to the proc, as the object */
"\n"/* is being deserialized. */
"\n"/*  */
"\n"/* Never pass untrusted data (including user supplied input) to this method. */
"\n"/* Please see the overview for further details. */
"\n"/*  */
"\n"/* If the <tt>freeze: true</tt> argument is passed, deserialized object would */
"\n"/* be deeply frozen. Note that it may lead to more efficient memory usage due to */
"\n"/* frozen strings deduplication: */
"\n"/*  */
"\n"/*    serialized = Marshal.dump(['value1', 'value2', 'value1', 'value2']) */
"\n"/*  */
"\n"/*    deserialized = Marshal.load(serialized) */
"\n"/*    deserialized.map(&:frozen?) */
"\n"/*    # => [false, false, false, false] */
"\n"/*    deserialized.map(&:object_id) */
"\n"/*    # => [1023900, 1023920, 1023940, 1023960] -- 4 different objects */
"\n"/*  */
"\n"/*    deserialized = Marshal.load(serialized, freeze: true) */
"\n"/*    deserialized.map(&:frozen?) */
"\n"/*    # => [true, true, true, true] */
"\n"/*    deserialized.map(&:object_id) */
"\n"/*    # => [1039360, 1039380, 1039360, 1039380] -- only 2 different objects, object_ids repeating */
"\n"/*  */
"  def self.load(source, proc = nil, freeze: false)\n"
"    Primitive.marshal_load(source, proc, freeze)\n"
"  end\n"
"\n"
"  class << self\n"
"    alias restore load\n"
"  end\n"
"end\n"
#line 1449 "miniprelude.c"
};

static const char prelude_name6[] = "<internal:pack>";
static const struct {
    char L0[501]; /* 1..306 */
    char L306[50]; /* 307..310 */
} prelude_code6 = {
#line 1 "pack.rb"
"class Array\n"
"\n"/*  call-seq: */
"\n"/*     arr.pack( aTemplateString ) -> aBinaryString */
"\n"/*     arr.pack( aTemplateString, buffer: aBufferString ) -> aBufferString */
"\n"/*  */
"\n"/*  Packs the contents of <i>arr</i> into a binary sequence according to */
"\n"/*  the directives in <i>aTemplateString</i> (see the table below) */
"\n"/*  Directives ``A,'' ``a,'' and ``Z'' may be followed by a count, */
"\n"/*  which gives the width of the resulting field. The remaining */
"\n"/*  directives also may take a count, indicating the number of array */
"\n"/*  elements to convert. If the count is an asterisk */
"\n"/*  (``<code>*</code>''), all remaining array elements will be */
"\n"/*  converted. Any of the directives ``<code>sSiIlL</code>'' may be */
"\n"/*  followed by an underscore (``<code>_</code>'') or */
"\n"/*  exclamation mark (``<code>!</code>'') to use the underlying */
"\n"/*  platform's native size for the specified type; otherwise, they use a */
"\n"/*  platform-independent size. Spaces are ignored in the template */
"\n"/*  string. See also String#unpack. */
"\n"/*  */
"\n"/*     a = [ "a", "b", "c" ] */
"\n"/*     n = [ 65, 66, 67 ] */
"\n"/*     a.pack("A3A3A3")   #=> "a  b  c  " */
"\n"/*     a.pack("a3a3a3")   #=> "a\000\000b\000\000c\000\000" */
"\n"/*     n.pack("ccc")      #=> "ABC" */
"\n"/*  */
"\n"/*  If <i>aBufferString</i> is specified and its capacity is enough, */
"\n"/*  +pack+ uses it as the buffer and returns it. */
"\n"/*  When the offset is specified by the beginning of <i>aTemplateString</i>, */
"\n"/*  the result is filled after the offset. */
"\n"/*  If original contents of <i>aBufferString</i> exists and it's longer than */
"\n"/*  the offset, the rest of <i>offsetOfBuffer</i> are overwritten by the result. */
"\n"/*  If it's shorter, the gap is filled with ``<code>\0</code>''. */
"\n"/*  */
"\n"/*     # packed data is appended by default */
"\n"/*     [255].pack("C", buffer:"foo".b) #=> "foo\xFF" */
"\n"/*  */
"\n"/*     # "@0" (offset 0) specifies that packed data is filled from beginning. */
"\n"/*     # Also, original data after packed data is removed. ("oo" is removed.) */
"\n"/*     [255].pack("@0C", buffer:"foo".b) #=> "\xFF" */
"\n"/*  */
"\n"/*     # If the offset is bigger than the original length, \x00 is filled. */
"\n"/*     [255].pack("@5C", buffer:"foo".b) #=> "foo\x00\x00\xFF" */
"\n"/*  */
"\n"/*  Note that ``buffer:'' option does not guarantee not to allocate memory */
"\n"/*  in +pack+.  If the capacity of <i>aBufferString</i> is not enough, */
"\n"/*  +pack+ allocates memory. */
"\n"/*  */
"\n"/*  Directives for +pack+. */
"\n"/*  */
"\n"/*   Integer       | Array   | */
"\n"/*   Directive     | Element | Meaning */
"\n"/*   ---------------------------------------------------------------------------- */
"\n"/*   C             | Integer | 8-bit unsigned (unsigned char) */
"\n"/*   S             | Integer | 16-bit unsigned, native endian (uint16_t) */
"\n"/*   L             | Integer | 32-bit unsigned, native endian (uint32_t) */
"\n"/*   Q             | Integer | 64-bit unsigned, native endian (uint64_t) */
"\n"/*   J             | Integer | pointer width unsigned, native endian (uintptr_t) */
"\n"/*                 |         | (J is available since Ruby 2.3.) */
"\n"/*                 |         | */
"\n"/*   c             | Integer | 8-bit signed (signed char) */
"\n"/*   s             | Integer | 16-bit signed, native endian (int16_t) */
"\n"/*   l             | Integer | 32-bit signed, native endian (int32_t) */
"\n"/*   q             | Integer | 64-bit signed, native endian (int64_t) */
"\n"/*   j             | Integer | pointer width signed, native endian (intptr_t) */
"\n"/*                 |         | (j is available since Ruby 2.3.) */
"\n"/*                 |         | */
"\n"/*   S_ S!         | Integer | unsigned short, native endian */
"\n"/*   I I_ I!       | Integer | unsigned int, native endian */
"\n"/*   L_ L!         | Integer | unsigned long, native endian */
"\n"/*   Q_ Q!         | Integer | unsigned long long, native endian (ArgumentError */
"\n"/*                 |         | if the platform has no long long type.) */
"\n"/*                 |         | (Q_ and Q! is available since Ruby 2.1.) */
"\n"/*   J!            | Integer | uintptr_t, native endian (same with J) */
"\n"/*                 |         | (J! is available since Ruby 2.3.) */
"\n"/*                 |         | */
"\n"/*   s_ s!         | Integer | signed short, native endian */
"\n"/*   i i_ i!       | Integer | signed int, native endian */
"\n"/*   l_ l!         | Integer | signed long, native endian */
"\n"/*   q_ q!         | Integer | signed long long, native endian (ArgumentError */
"\n"/*                 |         | if the platform has no long long type.) */
"\n"/*                 |         | (q_ and q! is available since Ruby 2.1.) */
"\n"/*   j!            | Integer | intptr_t, native endian (same with j) */
"\n"/*                 |         | (j! is available since Ruby 2.3.) */
"\n"/*                 |         | */
"\n"/*   S> s> S!> s!> | Integer | same as the directives without ">" except */
"\n"/*   L> l> L!> l!> |         | big endian */
"\n"/*   I!> i!>       |         | (available since Ruby 1.9.3) */
"\n"/*   Q> q> Q!> q!> |         | "S>" is the same as "n" */
"\n"/*   J> j> J!> j!> |         | "L>" is the same as "N" */
"\n"/*                 |         | */
"\n"/*   S< s< S!< s!< | Integer | same as the directives without "<" except */
"\n"/*   L< l< L!< l!< |         | little endian */
"\n"/*   I!< i!<       |         | (available since Ruby 1.9.3) */
"\n"/*   Q< q< Q!< q!< |         | "S<" is the same as "v" */
"\n"/*   J< j< J!< j!< |         | "L<" is the same as "V" */
"\n"/*                 |         | */
"\n"/*   n             | Integer | 16-bit unsigned, network (big-endian) byte order */
"\n"/*   N             | Integer | 32-bit unsigned, network (big-endian) byte order */
"\n"/*   v             | Integer | 16-bit unsigned, VAX (little-endian) byte order */
"\n"/*   V             | Integer | 32-bit unsigned, VAX (little-endian) byte order */
"\n"/*                 |         | */
"\n"/*   U             | Integer | UTF-8 character */
"\n"/*   w             | Integer | BER-compressed integer */
"\n"/*  */
"\n"/*   Float        | Array   | */
"\n"/*   Directive    | Element | Meaning */
"\n"/*   --------------------------------------------------------------------------- */
"\n"/*   D d          | Float   | double-precision, native format */
"\n"/*   F f          | Float   | single-precision, native format */
"\n"/*   E            | Float   | double-precision, little-endian byte order */
"\n"/*   e            | Float   | single-precision, little-endian byte order */
"\n"/*   G            | Float   | double-precision, network (big-endian) byte order */
"\n"/*   g            | Float   | single-precision, network (big-endian) byte order */
"\n"/*  */
"\n"/*   String       | Array   | */
"\n"/*   Directive    | Element | Meaning */
"\n"/*   --------------------------------------------------------------------------- */
"\n"/*   A            | String  | arbitrary binary string (space padded, count is width) */
"\n"/*   a            | String  | arbitrary binary string (null padded, count is width) */
"\n"/*   Z            | String  | same as ``a'', except that null is added with * */
"\n"/*   B            | String  | bit string (MSB first) */
"\n"/*   b            | String  | bit string (LSB first) */
"\n"/*   H            | String  | hex string (high nibble first) */
"\n"/*   h            | String  | hex string (low nibble first) */
"\n"/*   u            | String  | UU-encoded string */
"\n"/*   M            | String  | quoted printable, MIME encoding (see also RFC2045) */
"\n"/*                |         | (text mode but input must use LF and output LF) */
"\n"/*   m            | String  | base64 encoded string (see RFC 2045) */
"\n"/*                |         | (if count is 0, no line feed are added, see RFC 4648) */
"\n"/*                |         | (count specifies input bytes between each LF, */
"\n"/*                |         | rounded down to nearest multiple of 3) */
"\n"/*   P            | String  | pointer to a structure (fixed-length string) */
"\n"/*   p            | String  | pointer to a null-terminated string */
"\n"/*  */
"\n"/*   Misc.        | Array   | */
"\n"/*   Directive    | Element | Meaning */
"\n"/*   --------------------------------------------------------------------------- */
"\n"/*   @            | ---     | moves to absolute position */
"\n"/*   X            | ---     | back up a byte */
"\n"/*   x            | ---     | null byte */
"  def pack(fmt, buffer: nil)\n"
"    Primitive.pack_pack(fmt, buffer)\n"
"  end\n"
"end\n"
"\n"
"class String\n"
"\n"/* call-seq: */
"\n"/*    str.unpack(format)    ->  anArray */
"\n"/*    str.unpack(format, offset: anInteger)    ->  anArray */
"\n"/*  */
"\n"/* Decodes <i>str</i> (which may contain binary data) according to the */
"\n"/* format string, returning an array of each value extracted. */
"\n"/* The format string consists of a sequence of single-character directives, */
"\n"/* summarized in the table at the end of this entry. */
"\n"/* Each directive may be followed */
"\n"/* by a number, indicating the number of times to repeat with this */
"\n"/* directive. An asterisk (``<code>*</code>'') will use up all */
"\n"/* remaining elements. The directives <code>sSiIlL</code> may each be */
"\n"/* followed by an underscore (``<code>_</code>'') or */
"\n"/* exclamation mark (``<code>!</code>'') to use the underlying */
"\n"/* platform's native size for the specified type; otherwise, it uses a */
"\n"/* platform-independent consistent size. Spaces are ignored in the */
"\n"/* format string. */
"\n"/*  */
"\n"/* See also String#unpack1,  Array#pack. */
"\n"/*  */
"\n"/*    "abc \0\0abc \0\0".unpack('A6Z6')   #=> ["abc", "abc "] */
"\n"/*    "abc \0\0".unpack('a3a3')           #=> ["abc", " \000\000"] */
"\n"/*    "abc \0abc \0".unpack('Z*Z*')       #=> ["abc ", "abc "] */
"\n"/*    "aa".unpack('b8B8')                 #=> ["10000110", "01100001"] */
"\n"/*    "aaa".unpack('h2H2c')               #=> ["16", "61", 97] */
"\n"/*    "\xfe\xff\xfe\xff".unpack('sS')     #=> [-2, 65534] */
"\n"/*    "now=20is".unpack('M*')             #=> ["now is"] */
"\n"/*    "whole".unpack('xax2aX2aX1aX2a')    #=> ["h", "e", "l", "l", "o"] */
"\n"/*  */
"\n"/* This table summarizes the various formats and the Ruby classes */
"\n"/* returned by each. */
"\n"/*  */
"\n"/*  Integer       |         | */
"\n"/*  Directive     | Returns | Meaning */
"\n"/*  ------------------------------------------------------------------ */
"\n"/*  C             | Integer | 8-bit unsigned (unsigned char) */
"\n"/*  S             | Integer | 16-bit unsigned, native endian (uint16_t) */
"\n"/*  L             | Integer | 32-bit unsigned, native endian (uint32_t) */
"\n"/*  Q             | Integer | 64-bit unsigned, native endian (uint64_t) */
"\n"/*  J             | Integer | pointer width unsigned, native endian (uintptr_t) */
"\n"/*                |         | */
"\n"/*  c             | Integer | 8-bit signed (signed char) */
"\n"/*  s             | Integer | 16-bit signed, native endian (int16_t) */
"\n"/*  l             | Integer | 32-bit signed, native endian (int32_t) */
"\n"/*  q             | Integer | 64-bit signed, native endian (int64_t) */
"\n"/*  j             | Integer | pointer width signed, native endian (intptr_t) */
"\n"/*                |         | */
"\n"/*  S_ S!         | Integer | unsigned short, native endian */
"\n"/*  I I_ I!       | Integer | unsigned int, native endian */
"\n"/*  L_ L!         | Integer | unsigned long, native endian */
"\n"/*  Q_ Q!         | Integer | unsigned long long, native endian (ArgumentError */
"\n"/*                |         | if the platform has no long long type.) */
"\n"/*  J!            | Integer | uintptr_t, native endian (same with J) */
"\n"/*                |         | */
"\n"/*  s_ s!         | Integer | signed short, native endian */
"\n"/*  i i_ i!       | Integer | signed int, native endian */
"\n"/*  l_ l!         | Integer | signed long, native endian */
"\n"/*  q_ q!         | Integer | signed long long, native endian (ArgumentError */
"\n"/*                |         | if the platform has no long long type.) */
"\n"/*  j!            | Integer | intptr_t, native endian (same with j) */
"\n"/*                |         | */
"\n"/*  S> s> S!> s!> | Integer | same as the directives without ">" except */
"\n"/*  L> l> L!> l!> |         | big endian */
"\n"/*  I!> i!>       |         | */
"\n"/*  Q> q> Q!> q!> |         | "S>" is the same as "n" */
"\n"/*  J> j> J!> j!> |         | "L>" is the same as "N" */
"\n"/*                |         | */
"\n"/*  S< s< S!< s!< | Integer | same as the directives without "<" except */
"\n"/*  L< l< L!< l!< |         | little endian */
"\n"/*  I!< i!<       |         | */
"\n"/*  Q< q< Q!< q!< |         | "S<" is the same as "v" */
"\n"/*  J< j< J!< j!< |         | "L<" is the same as "V" */
"\n"/*                |         | */
"\n"/*  n             | Integer | 16-bit unsigned, network (big-endian) byte order */
"\n"/*  N             | Integer | 32-bit unsigned, network (big-endian) byte order */
"\n"/*  v             | Integer | 16-bit unsigned, VAX (little-endian) byte order */
"\n"/*  V             | Integer | 32-bit unsigned, VAX (little-endian) byte order */
"\n"/*                |         | */
"\n"/*  U             | Integer | UTF-8 character */
"\n"/*  w             | Integer | BER-compressed integer (see Array#pack) */
"\n"/*  */
"\n"/*  Float        |         | */
"\n"/*  Directive    | Returns | Meaning */
"\n"/*  ----------------------------------------------------------------- */
"\n"/*  D d          | Float   | double-precision, native format */
"\n"/*  F f          | Float   | single-precision, native format */
"\n"/*  E            | Float   | double-precision, little-endian byte order */
"\n"/*  e            | Float   | single-precision, little-endian byte order */
"\n"/*  G            | Float   | double-precision, network (big-endian) byte order */
"\n"/*  g            | Float   | single-precision, network (big-endian) byte order */
"\n"/*  */
"\n"/*  String       |         | */
"\n"/*  Directive    | Returns | Meaning */
"\n"/*  ----------------------------------------------------------------- */
"\n"/*  A            | String  | arbitrary binary string (remove trailing nulls and ASCII spaces) */
"\n"/*  a            | String  | arbitrary binary string */
"\n"/*  Z            | String  | null-terminated string */
"\n"/*  B            | String  | bit string (MSB first) */
"\n"/*  b            | String  | bit string (LSB first) */
"\n"/*  H            | String  | hex string (high nibble first) */
"\n"/*  h            | String  | hex string (low nibble first) */
"\n"/*  u            | String  | UU-encoded string */
"\n"/*  M            | String  | quoted-printable, MIME encoding (see RFC2045) */
"\n"/*  m            | String  | base64 encoded string (RFC 2045) (default) */
"\n"/*               |         | base64 encoded string (RFC 4648) if followed by 0 */
"\n"/*  P            | String  | pointer to a structure (fixed-length string) */
"\n"/*  p            | String  | pointer to a null-terminated string */
"\n"/*  */
"\n"/*  Misc.        |         | */
"\n"/*  Directive    | Returns | Meaning */
"\n"/*  ----------------------------------------------------------------- */
"\n"/*  @            | ---     | skip to the offset given by the length argument */
"\n"/*  X            | ---     | skip backward one byte */
"\n"/*  x            | ---     | skip forward one byte */
"\n"/*  */
"\n"/* The keyword <i>offset</i> can be given to start the decoding after skipping */
"\n"/* the specified amount of bytes: */
"\n"/*   "abc".unpack("C*") # => [97, 98, 99] */
"\n"/*   "abc".unpack("C*", offset: 2) # => [99] */
"\n"/*   "abc".unpack("C*", offset: 4) # => offset outside of string (ArgumentError) */
"\n"/*  */
"\n"/* HISTORY */
"\n"/*  */
"\n"/* * J, J! j, and j! are available since Ruby 2.3. */
"\n"/* * Q_, Q!, q_, and q! are available since Ruby 2.1. */
"\n"/* * I!<, i!<, I!>, and i!> are available since Ruby 1.9.3. */
"  def unpack(fmt, offset: 0)\n"
"    Primitive.pack_unpack(fmt, offset)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    str.unpack1(format)    ->  obj */
"\n"/*    str.unpack1(format, offset: anInteger)    ->  obj */
"\n"/*  */
"\n"/* Decodes <i>str</i> (which may contain binary data) according to the */
"\n"/* format string, returning the first value extracted. */
"\n"/*  */
"\n"/* See also String#unpack, Array#pack. */
"\n"/*  */
"\n"/* Contrast with String#unpack: */
"\n"/*  */
"\n"/*    "abc \0\0abc \0\0".unpack('A6Z6')   #=> ["abc", "abc "] */
"\n"/*    "abc \0\0abc \0\0".unpack1('A6Z6')  #=> "abc" */
"\n"/*  */
"\n"/* In that case data would be lost but often it's the case that the array */
"\n"/* only holds one value, especially when unpacking binary data. For instance: */
"\n"/*  */
"\n"/*    "\xff\x00\x00\x00".unpack("l")         #=>  [255] */
"\n"/*    "\xff\x00\x00\x00".unpack1("l")        #=>  255 */
"\n"/*  */
"\n"/* Thus unpack1 is convenient, makes clear the intention and signals */
"\n"/* the expected return value to those reading the code. */
"\n"/*  */
"\n"/* The keyword <i>offset</i> can be given to start the decoding after skipping */
"\n"/* the specified amount of bytes: */
"\n"/*   "abc".unpack1("C*") # => 97 */
"\n"/*   "abc".unpack1("C*", offset: 2) # => 99 */
"\n"/*   "abc".unpack1("C*", offset: 4) # => offset outside of string (ArgumentError) */
"\n"/*  */
"  def unpack1(fmt, offset: 0)\n"
,
#line 307 "pack.rb"
"    Primitive.pack_unpack1(fmt, offset)\n"
"  end\n"
"end\n"
#line 1769 "miniprelude.c"
};

static const char prelude_name7[] = "<internal:trace_point>";
static const struct {
    char L0[481]; /* 1..211 */
    char L211[484]; /* 212..279 */
    char L279[496]; /* 280..354 */
    char L354[215]; /* 355..372 */
} prelude_code7 = {
#line 1 "trace_point.rb"
""/* loaded from vm_trace.c */
""
""/* Document-class: TracePoint */
""/*  */
""/* A class that provides the functionality of Kernel#set_trace_func in a */
""/* nice Object-Oriented API. */
""/*  */
""/* == Example */
""/*  */
""/* We can use TracePoint to gather information specifically for exceptions: */
""/*  */
""/*     trace = TracePoint.new(:raise) do |tp| */
""/* 	p [tp.lineno, tp.event, tp.raised_exception] */
""/*     end */
""/*     #=> #<TracePoint:disabled> */
""/*  */
""/*     trace.enable */
""/*     #=> false */
""/*  */
""/*     0 / 0 */
""/*     #=> [5, :raise, #<ZeroDivisionError: divided by 0>] */
""/*  */
""/* == Events */
""/*  */
""/* If you don't specify the type of events you want to listen for, */
""/* TracePoint will include all available events. */
""/*  */
""/* *Note* do not depend on current event set, as this list is subject to */
""/* change. Instead, it is recommended you specify the type of events you */
""/* want to use. */
""/*  */
""/* To filter what is traced, you can pass any of the following as +events+: */
""/*  */
""/* +:line+:: execute an expression or statement on a new line */
""/* +:class+:: start a class or module definition */
""/* +:end+:: finish a class or module definition */
""/* +:call+:: call a Ruby method */
""/* +:return+:: return from a Ruby method */
""/* +:c_call+:: call a C-language routine */
""/* +:c_return+:: return from a C-language routine */
""/* +:raise+:: raise an exception */
""/* +:b_call+:: event hook at block entry */
""/* +:b_return+:: event hook at block ending */
""/* +:a_call+:: event hook at all calls (+call+, +b_call+, and +c_call+) */
""/* +:a_return+:: event hook at all returns (+return+, +b_return+, and +c_return+) */
""/* +:thread_begin+:: event hook at thread beginning */
""/* +:thread_end+:: event hook at thread ending */
""/* +:fiber_switch+:: event hook at fiber switch */
""/* +:script_compiled+:: new Ruby code compiled (with +eval+, +load+ or +require+) */
""/*  */
"class TracePoint\n"
"\n"/* call-seq: */
"\n"/* TracePoint.new(*events) { |obj| block }	    -> obj */
"\n"/*  */
"\n"/* Returns a new TracePoint object, not enabled by default. */
"\n"/*  */
"\n"/* Next, in order to activate the trace, you must use TracePoint#enable */
"\n"/*  */
"\n"/* trace = TracePoint.new(:call) do |tp| */
"\n"/*     p [tp.lineno, tp.defined_class, tp.method_id, tp.event] */
"\n"/* end */
"\n"/* #=> #<TracePoint:disabled> */
"\n"/*  */
"\n"/* trace.enable */
"\n"/* #=> false */
"\n"/*  */
"\n"/* puts "Hello, TracePoint!" */
"\n"/* # ... */
"\n"/* # [48, IRB::Notifier::AbstractNotifier, :printf, :call] */
"\n"/* # ... */
"\n"/*  */
"\n"/* When you want to deactivate the trace, you must use TracePoint#disable */
"\n"/*  */
"\n"/* trace.disable */
"\n"/*  */
"\n"/* See TracePoint@Events for possible events and more information. */
"\n"/*  */
"\n"/* A block must be given, otherwise an ArgumentError is raised. */
"\n"/*  */
"\n"/* If the trace method isn't included in the given events filter, a */
"\n"/* RuntimeError is raised. */
"\n"/*  */
"\n"/* TracePoint.trace(:line) do |tp| */
"\n"/*     p tp.raised_exception */
"\n"/* end */
"\n"/* #=> RuntimeError: 'raised_exception' not supported by this event */
"\n"/*  */
"\n"/* If the trace method is called outside block, a RuntimeError is raised. */
"\n"/*  */
"\n"/*      TracePoint.trace(:line) do |tp| */
"\n"/*        $tp = tp */
"\n"/*      end */
"\n"/*      $tp.lineno #=> access from outside (RuntimeError) */
"\n"/*  */
"\n"/* Access from other threads is also forbidden. */
"\n"/*  */
"  def self.new(*events)\n"
"    Primitive.tracepoint_new_s(events)\n"
"  end\n"
"\n"
"\n"/*  call-seq: */
"\n"/*    trace.inspect  -> string */
"\n"/*  */
"\n"/*  Return a string containing a human-readable TracePoint */
"\n"/*  status. */
"  def inspect\n"
"    Primitive.tracepoint_inspect\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/* TracePoint.stat -> obj */
"\n"/*  */
"\n"/*  Returns internal information of TracePoint. */
"\n"/*  */
"\n"/*  The contents of the returned value are implementation specific. */
"\n"/*  It may be changed in future. */
"\n"/*  */
"\n"/*  This method is only for debugging TracePoint itself. */
"  def self.stat\n"
"    Primitive.tracepoint_stat_s\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    TracePoint.trace(*events) { |obj| block }	-> obj */
"\n"/*  */
"\n"/* A convenience method for TracePoint.new, that activates the trace */
"\n"/* automatically. */
"\n"/*  */
"\n"/*     trace = TracePoint.trace(:call) { |tp| [tp.lineno, tp.event] } */
"\n"/*     #=> #<TracePoint:enabled> */
"\n"/*  */
"\n"/*     trace.enabled? #=> true */
"\n"/*  */
"  def self.trace(*events)\n"
"    Primitive.tracepoint_trace_s(events)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*   TracePoint.allow_reentry */
"\n"/*  */
"\n"/* In general, while a TracePoint callback is running, */
"\n"/* other registered callbacks are not called to avoid */
"\n"/* confusion by reentrance. */
"\n"/* This method allows the reentrance in a given block. */
"\n"/* This method should be used carefully, otherwise the callback */
"\n"/* can be easily called infinitely. */
"\n"/*  */
"\n"/* If this method is called when the reentrance is already allowed, */
"\n"/* it raises a RuntimeError. */
"  def self.allow_reentry\n"
"    Primitive.tracepoint_allow_reentry\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    trace.enable(target: nil, target_line: nil, target_thread: nil)    -> true or false */
"\n"/*    trace.enable(target: nil, target_line: nil, target_thread: :default) { block }  -> obj */
"\n"/*  */
"\n"/* Activates the trace. */
"\n"/*  */
"\n"/* Returns +true+ if trace was enabled. */
"\n"/* Returns +false+ if trace was disabled. */
"\n"/*  */
"\n"/*   trace.enabled?  #=> false */
"\n"/*   trace.enable    #=> false (previous state) */
"\n"/*                   #   trace is enabled */
"\n"/*   trace.enabled?  #=> true */
"\n"/*   trace.enable    #=> true (previous state) */
"\n"/*                   #   trace is still enabled */
"\n"/*  */
"\n"/* If a block is given, the trace will only be enabled during the block call. */
"\n"/* If target and target_line are both nil, then target_thread will default */
"\n"/* to the current thread if a block is given. */
"\n"/*  */
"\n"/*    trace.enabled? */
"\n"/*    #=> false */
"\n"/*  */
"\n"/*    trace.enable do */
"\n"/*      trace.enabled? */
"\n"/*      # only enabled for this block and thread */
"\n"/*    end */
"\n"/*  */
"\n"/*    trace.enabled? */
"\n"/*    #=> false */
"\n"/*  */
"\n"/* +target+, +target_line+ and +target_thread+ parameters are used to */
"\n"/* limit tracing only to specified code objects. +target+ should be a */
"\n"/* code object for which RubyVM::InstructionSequence.of will return */
"\n"/* an instruction sequence. */
"\n"/*  */
"\n"/*    t = TracePoint.new(:line) { |tp| p tp } */
"\n"/*  */
"\n"/*    def m1 */
"\n"/*      p 1 */
"\n"/*    end */
"\n"/*  */
"\n"/*    def m2 */
"\n"/*      p 2 */
"\n"/*    end */
"\n"/*  */
"\n"/*    t.enable(target: method(:m1)) */
"\n"/*  */
"\n"/*    m1 */
"\n"/*    # prints #<TracePoint:line test.rb:4 in `m1'> */
"\n"/*    m2 */
"\n"/*    # prints nothing */
"\n"/*  */
"\n"/* Note: You cannot access event hooks within the +enable+ block. */
"\n"/*  */
"\n"/*    trace.enable { p tp.lineno } */
"\n"/*    #=> RuntimeError: access from outside */
"\n"/*  */
,
#line 212 "trace_point.rb"
"  def enable(target: nil, target_line: nil, target_thread: :default)\n"
"    Primitive.tracepoint_enable_m(target, target_line, target_thread)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/* trace.disable		-> true or false */
"\n"/* trace.disable { block } -> obj */
"\n"/*  */
"\n"/* Deactivates the trace */
"\n"/*  */
"\n"/* Return true if trace was enabled. */
"\n"/* Return false if trace was disabled. */
"\n"/*  */
"\n"/* trace.enabled?	#=> true */
"\n"/* trace.disable	#=> true (previous status) */
"\n"/* trace.enabled?	#=> false */
"\n"/* trace.disable	#=> false */
"\n"/*  */
"\n"/* If a block is given, the trace will only be disable within the scope of the */
"\n"/* block. */
"\n"/*  */
"\n"/* trace.enabled? */
"\n"/* #=> true */
"\n"/*  */
"\n"/* trace.disable do */
"\n"/*     trace.enabled? */
"\n"/*     # only disabled for this block */
"\n"/* end */
"\n"/*  */
"\n"/* trace.enabled? */
"\n"/* #=> true */
"\n"/*  */
"\n"/* Note: You cannot access event hooks within the block. */
"\n"/*  */
"\n"/* trace.disable { p tp.lineno } */
"\n"/* #=> RuntimeError: access from outside */
"  def disable\n"
"    Primitive.tracepoint_disable_m\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/* trace.enabled?	    -> true or false */
"\n"/*  */
"\n"/* The current status of the trace */
"  def enabled?\n"
"    Primitive.tracepoint_enabled_p\n"
"  end\n"
"\n"
"\n"/* Type of event */
"\n"/*  */
"\n"/* See TracePoint@Events for more information. */
"  def event\n"
"    Primitive.tracepoint_attr_event\n"
"  end\n"
"\n"
"\n"/* Line number of the event */
"  def lineno\n"
"    Primitive.tracepoint_attr_lineno\n"
"  end\n"
"\n"
"\n"/* Path of the file being run */
"  def path\n"
"    Primitive.tracepoint_attr_path\n"
"  end\n"
"\n"
"\n"/* Return the parameters definition of the method or block that the */
"\n"/* current hook belongs to. Format is the same as for Method#parameters */
"  def parameters\n"
,
#line 280 "trace_point.rb"
"    Primitive.tracepoint_attr_parameters\n"
"  end\n"
"\n"
"\n"/* Return the name at the definition of the method being called */
"  def method_id\n"
"    Primitive.tracepoint_attr_method_id\n"
"  end\n"
"\n"
"\n"/* Return the called name of the method being called */
"  def callee_id\n"
"    Primitive.tracepoint_attr_callee_id\n"
"  end\n"
"\n"
"\n"/* Return class or module of the method being called. */
"\n"/*  */
"\n"/* class C; def foo; end; end */
"\n"/* 	trace = TracePoint.new(:call) do |tp| */
"\n"/* 	  p tp.defined_class #=> C */
"\n"/* 	end.enable do */
"\n"/* 	  C.new.foo */
"\n"/* 	end */
"\n"/*  */
"\n"/* If method is defined by a module, then that module is returned. */
"\n"/*  */
"\n"/* module M; def foo; end; end */
"\n"/* 	class C; include M; end; */
"\n"/* 	trace = TracePoint.new(:call) do |tp| */
"\n"/* 	  p tp.defined_class #=> M */
"\n"/* 	end.enable do */
"\n"/* 	  C.new.foo */
"\n"/* 	end */
"\n"/*  */
"\n"/* <b>Note:</b> #defined_class returns singleton class. */
"\n"/*  */
"\n"/* 6th block parameter of Kernel#set_trace_func passes original class */
"\n"/* of attached by singleton class. */
"\n"/*  */
"\n"/* <b>This is a difference between Kernel#set_trace_func and TracePoint.</b> */
"\n"/*  */
"\n"/* class C; def self.foo; end; end */
"\n"/* 	trace = TracePoint.new(:call) do |tp| */
"\n"/* 	  p tp.defined_class #=> #<Class:C> */
"\n"/* 	end.enable do */
"\n"/* 	  C.foo */
"\n"/* 	end */
"  def defined_class\n"
"    Primitive.tracepoint_attr_defined_class\n"
"  end\n"
"\n"
"\n"/* Return the generated binding object from event. */
"\n"/*  */
"\n"/* Note that for +c_call+ and +c_return+ events, the binding returned is the */
"\n"/* binding of the nearest Ruby method calling the C method, since C methods */
"\n"/* themselves do not have bindings. */
"  def binding\n"
"    Primitive.tracepoint_attr_binding\n"
"  end\n"
"\n"
"\n"/* Return the trace object during event */
"\n"/*  */
"\n"/* Same as the following, except it returns the correct object (the method */
"\n"/* receiver) for +c_call+ and +c_return+ events: */
"\n"/*  */
"\n"/*   trace.binding.eval('self') */
"  def self\n"
"    Primitive.tracepoint_attr_self\n"
"  end\n"
"\n"
"\n"/*  Return value from +:return+, +c_return+, and +b_return+ event */
"  def return_value\n"
"    Primitive.tracepoint_attr_return_value\n"
"  end\n"
"\n"
"\n"/* Value from exception raised on the +:raise+ event */
"  def raised_exception\n"
,
#line 355 "trace_point.rb"
"    Primitive.tracepoint_attr_raised_exception\n"
"  end\n"
"\n"
"\n"/* Compiled source code (String) on *eval methods on the +:script_compiled+ event. */
"\n"/* If loaded from a file, it will return nil. */
"  def eval_script\n"
"    Primitive.tracepoint_attr_eval_script\n"
"  end\n"
"\n"
"\n"/* Compiled instruction sequence represented by a RubyVM::InstructionSequence instance */
"\n"/* on the +:script_compiled+ event. */
"\n"/*  */
"\n"/* Note that this method is MRI specific. */
"  def instruction_sequence\n"
"    Primitive.tracepoint_attr_instruction_sequence\n"
"  end\n"
"end\n"
#line 2157 "miniprelude.c"
};

static const char prelude_name8[] = "<internal:warning>";
static const struct {
    char L0[182]; /* 1..54 */
} prelude_code8 = {
#line 1 "warning.rb"
""/* encoding: utf-8 */
""/* frozen-string-literal: true */
""
"module Kernel\n"
"  module_function\n"
"\n"
"\n"/* call-seq: */
"\n"/*    warn(*msgs, uplevel: nil, category: nil)   -> nil */
"\n"/*  */
"\n"/* If warnings have been disabled (for example with the */
"\n"/* <code>-W0</code> flag), does nothing.  Otherwise, */
"\n"/* converts each of the messages to strings, appends a newline */
"\n"/* character to the string if the string does not end in a newline, */
"\n"/* and calls Warning.warn with the string. */
"\n"/*  */
"\n"/*    warn("warning 1", "warning 2") */
"\n"/*  */
"\n"/*  <em>produces:</em> */
"\n"/*  */
"\n"/*    warning 1 */
"\n"/*    warning 2 */
"\n"/*  */
"\n"/* If the <code>uplevel</code> keyword argument is given, the string will */
"\n"/* be prepended with information for the given caller frame in */
"\n"/* the same format used by the <code>rb_warn</code> C function. */
"\n"/*  */
"\n"/*    # In baz.rb */
"\n"/*    def foo */
"\n"/*      warn("invalid call to foo", uplevel: 1) */
"\n"/*    end */
"\n"/*  */
"\n"/*    def bar */
"\n"/*      foo */
"\n"/*    end */
"\n"/*  */
"\n"/*    bar */
"\n"/*  */
"\n"/*  <em>produces:</em> */
"\n"/*  */
"\n"/*    baz.rb:6: warning: invalid call to foo */
"\n"/*  */
"\n"/* If <code>category</code> keyword argument is given, passes the category */
"\n"/* to <code>Warning.warn</code>.  The category given must be be one of the */
"\n"/* following categories: */
"\n"/*  */
"\n"/* :deprecated :: Used for warning for deprecated functionality that may */
"\n"/*                be removed in the future. */
"\n"/* :experimental :: Used for experimental features that may change in */
"\n"/*                  future releases. */
"  def warn(*msgs, uplevel: nil, category: nil)\n"
"    Primitive.rb_warn_m(msgs, uplevel, category)\n"
"  end\n"
"end\n"
#line 2218 "miniprelude.c"
};

static const char prelude_name9[] = "<internal:array>";
static const struct {
    char L0[397]; /* 1..70 */
} prelude_code9 = {
#line 1 "array.rb"
"class Array\n"
"\n"/* call-seq: */
"\n"/*    array.shuffle!(random: Random) -> array */
"\n"/*  */
"\n"/* Shuffles the elements of +self+ in place. */
"\n"/*    a = [1, 2, 3] #=> [1, 2, 3] */
"\n"/*    a.shuffle!    #=> [2, 3, 1] */
"\n"/*    a             #=> [2, 3, 1] */
"\n"/*  */
"\n"/* The optional +random+ argument will be used as the random number generator: */
"\n"/*    a.shuffle!(random: Random.new(1))  #=> [1, 3, 2] */
"  def shuffle!(random: Random)\n"
"    Primitive.rb_ary_shuffle_bang(random)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    array.shuffle(random: Random) -> new_ary */
"\n"/*  */
"\n"/* Returns a new array with elements of +self+ shuffled. */
"\n"/*    a = [1, 2, 3] #=> [1, 2, 3] */
"\n"/*    a.shuffle     #=> [2, 3, 1] */
"\n"/*    a             #=> [1, 2, 3] */
"\n"/*  */
"\n"/* The optional +random+ argument will be used as the random number generator: */
"\n"/*    a.shuffle(random: Random.new(1))  #=> [1, 3, 2] */
"  def shuffle(random: Random)\n"
"    Primitive.rb_ary_shuffle(random)\n"
"  end\n"
"\n"
"\n"/* call-seq: */
"\n"/*    array.sample(random: Random) -> object */
"\n"/*    array.sample(n, random: Random) -> new_ary */
"\n"/*  */
"\n"/* Returns random elements from +self+. */
"\n"/*  */
"\n"/* When no arguments are given, returns a random element from +self+: */
"\n"/*    a = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10] */
"\n"/*    a.sample # => 3 */
"\n"/*    a.sample # => 8 */
"\n"/* If +self+ is empty, returns +nil+. */
"\n"/*  */
"\n"/* When argument +n+ is given, returns a new \Array containing +n+ random */
"\n"/* elements from +self+: */
"\n"/*    a.sample(3) # => [8, 9, 2] */
"\n"/*    a.sample(6) # => [9, 6, 10, 3, 1, 4] */
"\n"/* Returns no more than <tt>a.size</tt> elements */
"\n"/* (because no new duplicates are introduced): */
"\n"/*    a.sample(a.size * 2) # => [6, 4, 1, 8, 5, 9, 10, 2, 3, 7] */
"\n"/* But +self+ may contain duplicates: */
"\n"/*    a = [1, 1, 1, 2, 2, 3] */
"\n"/*    a.sample(a.size * 2) # => [1, 1, 3, 2, 1, 2] */
"\n"/* The argument +n+ must be a non-negative numeric value. */
"\n"/* The order of the result array is unrelated to the order of +self+. */
"\n"/* Returns a new empty \Array if +self+ is empty. */
"\n"/*  */
"\n"/* The optional +random+ argument will be used as the random number generator: */
"\n"/*    a = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10] */
"\n"/*    a.sample(random: Random.new(1))     #=> 6 */
"\n"/*    a.sample(4, random: Random.new(1))  #=> [6, 10, 9, 2] */
"  def sample(n = (ary = false), random: Random)\n"
"    if Primitive.mandatory_only?\n"
"\n"/* Primitive.cexpr! %{ rb_ary_sample(self, rb_cRandom, Qfalse, Qfalse) } */
"      Primitive.ary_sample0\n"
"    else\n"
"\n"/* Primitive.cexpr! %{ rb_ary_sample(self, random, n, ary) } */
"      Primitive.ary_sample(random, n, ary)\n"
"    end\n"
"  end\n"
"end\n"
#line 2295 "miniprelude.c"
};

static const char prelude_name10[] = "<internal:kernel>";
static const struct {
    char L0[484]; /* 1..121 */
    char L121[486]; /* 122..179 */
} prelude_code10 = {
#line 1 "kernel.rb"
"module Kernel\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     obj.class    -> class */
"\n"/*  */
"\n"/*  Returns the class of <i>obj</i>. This method must always be called */
"\n"/*  with an explicit receiver, as #class is also a reserved word in */
"\n"/*  Ruby. */
"\n"/*  */
"\n"/*     1.class      #=> Integer */
"\n"/*     self.class   #=> Object */
"  #--\n"
"\n"/* Equivalent to \c Object\#class in Ruby. */
"\n"/*  */
"\n"/* Returns the class of \c obj, skipping singleton classes or module inclusions. */
"  #++\n"
"\n"/*  */
"  def class\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_obj_class(self)'\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     obj.clone(freeze: nil) -> an_object */
"\n"/*  */
"\n"/*  Produces a shallow copy of <i>obj</i>---the instance variables of */
"\n"/*  <i>obj</i> are copied, but not the objects they reference. */
"\n"/*  #clone copies the frozen value state of <i>obj</i>, unless the */
"\n"/*  +:freeze+ keyword argument is given with a false or true value. */
"\n"/*  See also the discussion under Object#dup. */
"\n"/*  */
"\n"/*     class Klass */
"\n"/*        attr_accessor :str */
"\n"/*     end */
"\n"/*     s1 = Klass.new      #=> #<Klass:0x401b3a38> */
"\n"/*     s1.str = "Hello"    #=> "Hello" */
"\n"/*     s2 = s1.clone       #=> #<Klass:0x401b3998 @str="Hello"> */
"\n"/*     s2.str[1,4] = "i"   #=> "i" */
"\n"/*     s1.inspect          #=> "#<Klass:0x401b3a38 @str=\"Hi\">" */
"\n"/*     s2.inspect          #=> "#<Klass:0x401b3998 @str=\"Hi\">" */
"\n"/*  */
"\n"/*  This method may have class-specific behavior.  If so, that */
"\n"/*  behavior will be documented under the #+initialize_copy+ method of */
"\n"/*  the class. */
"\n"/*  */
"  def clone(freeze: nil)\n"
"    Primitive.rb_obj_clone2(freeze)\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     obj.frozen?    -> true or false */
"\n"/*  */
"\n"/*  Returns the freeze status of <i>obj</i>. */
"\n"/*  */
"\n"/*     a = [ "a", "b", "c" ] */
"\n"/*     a.freeze    #=> ["a", "b", "c"] */
"\n"/*     a.frozen?   #=> true */
"  #--\n"
"\n"/* Determines if the object is frozen. Equivalent to \c Object\#frozen? in Ruby. */
"\n"/* \param[in] obj  the object to be determines */
"\n"/* \retval Qtrue if frozen */
"\n"/* \retval Qfalse if not frozen */
"  #++\n"
"\n"/*  */
"  def frozen?\n"
"    Primitive.attr! 'inline'\n"
"    Primitive.cexpr! 'rb_obj_frozen_p(self)'\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     obj.tap {|x| block }    -> obj */
"\n"/*  */
"\n"/*  Yields self to the block, and then returns self. */
"\n"/*  The primary purpose of this method is to "tap into" a method chain, */
"\n"/*  in order to perform operations on intermediate results within the chain. */
"\n"/*  */
"\n"/*     (1..10)                  .tap {|x| puts "original: #{x}" } */
"\n"/*       .to_a                  .tap {|x| puts "array:    #{x}" } */
"\n"/*       .select {|x| x.even? } .tap {|x| puts "evens:    #{x}" } */
"\n"/*       .map {|x| x*x }        .tap {|x| puts "squares:  #{x}" } */
"\n"/*  */
"  #--\n"
"\n"/* \private */
"  #++\n"
"\n"/*  */
"  def tap\n"
"    yield(self)\n"
"    self\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     obj.then {|x| block }          -> an_object */
"\n"/*  */
"\n"/*  Yields self to the block and returns the result of the block. */
"\n"/*  */
"\n"/*     3.next.then {|x| x**x }.to_s             #=> "256" */
"\n"/*  */
"\n"/*  Good usage for +then+ is value piping in method chains: */
"\n"/*  */
"\n"/*     require 'open-uri' */
"\n"/*     require 'json' */
"\n"/*  */
"\n"/*     construct_url(arguments). */
"\n"/*       then {|url| URI(url).read }. */
"\n"/*       then {|response| JSON.parse(response) } */
"\n"/*  */
"\n"/*  When called without block, the method returns +Enumerator+, */
"\n"/*  which can be used, for example, for conditional */
"\n"/*  circuit-breaking: */
"\n"/*  */
"\n"/*     # meets condition, no-op */
"\n"/*     1.then.detect(&:odd?)            # => 1 */
"\n"/*     # does not meet condition, drop value */
"\n"/*     2.then.detect(&:odd?)            # => nil */
"\n"/*  */
"  def then\n"
"    unless Primitive.block_given_p\n"
,
#line 122 "kernel.rb"
"      return Primitive.cexpr! 'SIZED_ENUMERATOR(self, 0, 0, rb_obj_size)'\n"
"    end\n"
"    yield(self)\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     obj.yield_self {|x| block }    -> an_object */
"\n"/*  */
"\n"/*  Yields self to the block and returns the result of the block. */
"\n"/*  */
"\n"/*     "my string".yield_self {|s| s.upcase }   #=> "MY STRING" */
"\n"/*  */
"\n"/*  Good usage for +then+ is value piping in method chains: */
"\n"/*  */
"\n"/*     require 'open-uri' */
"\n"/*     require 'json' */
"\n"/*  */
"\n"/*     construct_url(arguments). */
"\n"/*       then {|url| URI(url).read }. */
"\n"/*       then {|response| JSON.parse(response) } */
"\n"/*  */
"  def yield_self\n"
"    unless Primitive.block_given_p\n"
"      return Primitive.cexpr! 'SIZED_ENUMERATOR(self, 0, 0, rb_obj_size)'\n"
"    end\n"
"    yield(self)\n"
"  end\n"
"\n"
"  module_function\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     Float(arg, exception: true)    -> float or nil */
"\n"/*  */
"\n"/*  Returns <i>arg</i> converted to a float. Numeric types are */
"\n"/*  converted directly, and with exception to String and */
"\n"/*  <code>nil</code> the rest are converted using */
"\n"/*  <i>arg</i><code>.to_f</code>.  Converting a String with invalid */
"\n"/*  characters will result in a ArgumentError.  Converting */
"\n"/*  <code>nil</code> generates a TypeError.  Exceptions can be */
"\n"/*  suppressed by passing <code>exception: false</code>. */
"\n"/*  */
"\n"/*     Float(1)                 #=> 1.0 */
"\n"/*     Float("123.456")         #=> 123.456 */
"\n"/*     Float("123.0_badstring") #=> ArgumentError: invalid value for Float(): "123.0_badstring" */
"\n"/*     Float(nil)               #=> TypeError: can't convert nil into Float */
"\n"/*     Float("123.0_badstring", exception: false)  #=> nil */
"\n"/*  */
"  def Float(arg, exception: true)\n"
"    if Primitive.mandatory_only?\n"
"      Primitive.rb_f_float1(arg)\n"
"    else\n"
"      Primitive.rb_f_float(arg, exception)\n"
"    end\n"
"  end\n"
"end\n"
#line 2484 "miniprelude.c"
};

static const char prelude_name11[] = "<internal:ractor>";
static const struct {
    char L0[508]; /* 1..293 */
    char L293[485]; /* 294..349 */
    char L349[508]; /* 350..473 */
    char L473[466]; /* 474..627 */
    char L627[454]; /* 628..703 */
    char L703[478]; /* 704..753 */
    char L753[508]; /* 754..827 */
    char L827[184]; /* 828..839 */
} prelude_code11 = {
#line 1 "ractor.rb"
""/* Ractor is a Actor-model abstraction for Ruby that provides thread-safe parallel execution. */
""/*  */
""/* Ractor.new can make a new Ractor, and it will run in parallel. */
""/*  */
""/*     # The simplest ractor */
""/*     r = Ractor.new {puts "I am in Ractor!"} */
""/*     r.take # wait for it to finish */
""/*     # here "I am in Ractor!" would be printed */
""/*  */
""/* Ractors do not share usual objects, so the same kinds of thread-safety concerns such as data-race, */
""/* race-conditions are not available on multi-ractor programming. */
""/*  */
""/* To achieve this, ractors severely limit object sharing between different ractors. */
""/* For example, unlike threads, ractors can't access each other's objects, nor any objects through */
""/* variables of the outer scope. */
""/*  */
""/*     a = 1 */
""/*     r = Ractor.new {puts "I am in Ractor! a=#{a}"} */
""/*     # fails immediately with */
""/*     # ArgumentError (can not isolate a Proc because it accesses outer variables (a).) */
""/*  */
""/* On CRuby (the default implementation), Global Virtual Machine Lock (GVL) is held per ractor, so */
""/* ractors are performed in parallel without locking each other. */
""/*  */
""/* Instead of accessing the shared state, the objects should be passed to and from ractors via */
""/* sending and receiving objects as messages. */
""/*  */
""/*     a = 1 */
""/*     r = Ractor.new do */
""/*       a_in_ractor = receive # receive blocks till somebody will pass message */
""/*       puts "I am in Ractor! a=#{a_in_ractor}" */
""/*     end */
""/*     r.send(a)  # pass it */
""/*     r.take */
""/*     # here "I am in Ractor! a=1" would be printed */
""/*  */
""/* There are two pairs of methods for sending/receiving messages: */
""/*  */
""/* * Ractor#send and Ractor.receive for when the _sender_ knows the receiver (push); */
""/* * Ractor.yield and Ractor#take for when the _receiver_ knows the sender (pull); */
""/*  */
""/* In addition to that, an argument to Ractor.new would be passed to block and available there */
""/* as if received by Ractor.receive, and the last block value would be sent outside of the */
""/* ractor as if sent by Ractor.yield. */
""/*  */
""/* A little demonstration on a classic ping-pong: */
""/*  */
""/*     server = Ractor.new do */
""/*       puts "Server starts: #{self.inspect}" */
""/*       puts "Server sends: ping" */
""/*       Ractor.yield 'ping'                       # The server doesn't know the receiver and sends to whoever interested */
""/*       received = Ractor.receive                 # The server doesn't know the sender and receives from whoever sent */
""/*       puts "Server received: #{received}" */
""/*     end */
""/*  */
""/*     client = Ractor.new(server) do |srv|        # The server is sent inside client, and available as srv */
""/*       puts "Client starts: #{self.inspect}" */
""/*       received = srv.take                       # The Client takes a message specifically from the server */
""/*       puts "Client received from " \ */
""/*            "#{srv.inspect}: #{received}" */
""/*       puts "Client sends to " \ */
""/*            "#{srv.inspect}: pong" */
""/*       srv.send 'pong'                           # The client sends a message specifically to the server */
""/*     end */
""/*  */
""/*     [client, server].each(&:take)               # Wait till they both finish */
""/*  */
""/* This will output: */
""/*  */
""/*     Server starts: #<Ractor:#2 test.rb:1 running> */
""/*     Server sends: ping */
""/*     Client starts: #<Ractor:#3 test.rb:8 running> */
""/*     Client received from #<Ractor:#2 rac.rb:1 blocking>: ping */
""/*     Client sends to #<Ractor:#2 rac.rb:1 blocking>: pong */
""/*     Server received: pong */
""/*  */
""/* It is said that Ractor receives messages via the <em>incoming port</em>, and sends them */
""/* to the <em>outgoing port</em>. Either one can be disabled with Ractor#close_incoming and */
""/* Ractor#close_outgoing respectively. If a ractor terminated, its ports will be closed */
""/* automatically. */
""/*  */
""/* == Shareable and unshareable objects */
""/*  */
""/* When the object is sent to and from the ractor, it is important to understand whether the */
""/* object is shareable or unshareable. Most of objects are unshareable objects. */
""/*  */
""/* Shareable objects are basically those which can be used by several threads without compromising */
""/* thread-safety; e.g. immutable ones. Ractor.shareable? allows to check this, and Ractor.make_shareable */
""/* tries to make object shareable if it is not. */
""/*  */
""/*     Ractor.shareable?(1)            #=> true -- numbers and other immutable basic values are */
""/*     Ractor.shareable?('foo')        #=> false, unless the string is frozen due to # freeze_string_literals: true */
""/*     Ractor.shareable?('foo'.freeze) #=> true */
""/*  */
""/*     ary = ['hello', 'world'] */
""/*     ary.frozen?                 #=> false */
""/*     ary[0].frozen?              #=> false */
""/*     Ractor.make_shareable(ary) */
""/*     ary.frozen?                 #=> true */
""/*     ary[0].frozen?              #=> true */
""/*     ary[1].frozen?              #=> true */
""/*  */
""/* When a shareable object is sent (via #send or Ractor.yield), no additional processing happens, */
""/* and it just becomes usable by both ractors. When an unshareable object is sent, it can be */
""/* either _copied_ or _moved_. The first is the default, and it makes the object's full copy by */
""/* deep cloning of non-shareable parts of its structure. */
""/*  */
""/*     data = ['foo', 'bar'.freeze] */
""/*     r = Ractor.new do */
""/*       data2 = Ractor.receive */
""/*       puts "In ractor: #{data2.object_id}, #{data2[0].object_id}, #{data2[1].object_id}" */
""/*     end */
""/*     r.send(data) */
""/*     r.take */
""/*     puts "Outside  : #{data.object_id}, #{data[0].object_id}, #{data[1].object_id}" */
""/*  */
""/* This will output: */
""/*  */
""/*     In ractor: 340, 360, 320 */
""/*     Outside  : 380, 400, 320 */
""/*  */
""/* (Note that object id of both array and non-frozen string inside array have changed inside */
""/* the ractor, showing it is different objects. But the second array's element, which is a */
""/* shareable frozen string, has the same object_id.) */
""/*  */
""/* Deep cloning of the objects may be slow, and sometimes impossible. Alternatively, */
""/* <tt>move: true</tt> may be used on sending. This will <em>move</em> the object to the */
""/* receiving ractor, making it inaccessible for a sending ractor. */
""/*  */
""/*     data = ['foo', 'bar'] */
""/*     r = Ractor.new do */
""/*       data_in_ractor = Ractor.receive */
""/*       puts "In ractor: #{data_in_ractor.object_id}, #{data_in_ractor[0].object_id}" */
""/*     end */
""/*     r.send(data, move: true) */
""/*     r.take */
""/*     puts "Outside: moved? #{Ractor::MovedObject === data}" */
""/*     puts "Outside: #{data.inspect}" */
""/*  */
""/* This will output: */
""/*  */
""/*     In ractor: 100, 120 */
""/*     Outside: moved? true */
""/*     test.rb:9:in `method_missing': can not send any methods to a moved object (Ractor::MovedError) */
""/*  */
""/* Notice that even +inspect+ (and more basic methods like <tt>__id__</tt>) is inaccessible */
""/* on a moved object. */
""/*  */
""/* Besides frozen objects, there are shareable objects. Class and Module objects are shareable so */
""/* the Class/Module definitions are shared between ractors. Ractor objects are also shareable objects. */
""/* All operations for the shareable mutable objects are thread-safe, so the thread-safety property */
""/* will be kept. We can not define mutable shareable objects in Ruby, but C extensions can introduce them. */
""/*  */
""/* It is prohibited to access instance variables of mutable shareable objects (especially Modules and classes) */
""/* from ractors other than main: */
""/*  */
""/*     class C */
""/*       class << self */
""/*         attr_accessor :tricky */
""/*       end */
""/*     end */
""/*  */
""/*     C.tricky = 'test' */
""/*  */
""/*     r = Ractor.new(C) do |cls| */
""/*       puts "I see #{cls}" */
""/*       puts "I can't see #{cls.tricky}" */
""/*     end */
""/*     r.take */
""/*     # I see C */
""/*     # can not access instance variables of classes/modules from non-main Ractors (RuntimeError) */
""/*  */
""/* Ractors can access constants if they are shareable. The main Ractor is the only one that can */
""/* access non-shareable constants. */
""/*  */
""/*     GOOD = 'good'.freeze */
""/*     BAD = 'bad' */
""/*  */
""/*     r = Ractor.new do */
""/*       puts "GOOD=#{GOOD}" */
""/*       puts "BAD=#{BAD}" */
""/*     end */
""/*     r.take */
""/*     # GOOD=good */
""/*     # can not access non-shareable objects in constant Object::BAD by non-main Ractor. (NameError) */
""/*  */
""/*     # Consider the same C class from above */
""/*  */
""/*     r = Ractor.new do */
""/*       puts "I see #{C}" */
""/*       puts "I can't see #{C.tricky}" */
""/*     end */
""/*     r.take */
""/*     # I see C */
""/*     # can not access instance variables of classes/modules from non-main Ractors (RuntimeError) */
""/*  */
""/* See also the description of <tt># shareable_constant_value</tt> pragma in */
""/* {Comments syntax}[rdoc-ref:syntax/comments.rdoc] explanation. */
""/*  */
""/* == Ractors vs threads */
""/*  */
""/* Each ractor creates its own thread. New threads can be created from inside ractor */
""/* (and, on CRuby, sharing GVL with other threads of this ractor). */
""/*  */
""/*     r = Ractor.new do */
""/*       a = 1 */
""/*       Thread.new {puts "Thread in ractor: a=#{a}"}.join */
""/*     end */
""/*     r.take */
""/*     # Here "Thread in ractor: a=1" will be printed */
""/*  */
""/* == Note on code examples */
""/*  */
""/* In examples below, sometimes we use the following method to wait till ractors that */
""/* are not currently blocked will finish (or process till next blocking) method. */
""/*  */
""/*     def wait */
""/*       sleep(0.1) */
""/*     end */
""/*  */
""/* It is **only for demonstration purposes** and shouldn't be used in a real code. */
""/* Most of the times, just #take is used to wait till ractor will finish. */
""/*  */
""/* == Reference */
""/*  */
""/* See {Ractor design doc}[rdoc-ref:ractor.md] for more details. */
""/*  */
"class Ractor\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     Ractor.new(*args, name: nil) {|*args| block } -> ractor */
"\n"/*  */
"\n"/* Create a new Ractor with args and a block. */
"\n"/*  */
"\n"/* A block (Proc) will be isolated (can't access to outer variables). +self+ */
"\n"/* inside the block will refer to the current Ractor. */
"\n"/*  */
"\n"/*    r = Ractor.new { puts "Hi, I am #{self.inspect}" } */
"\n"/*    r.take */
"\n"/*    # Prints "Hi, I am #<Ractor:#2 test.rb:1 running>" */
"\n"/*  */
"\n"/* +args+ passed to the method would be propagated to block args by the same rules as */
"\n"/* objects passed through #send/Ractor.receive: if +args+ are not shareable, they */
"\n"/* will be copied (via deep cloning, which might be inefficient). */
"\n"/*  */
"\n"/*    arg = [1, 2, 3] */
"\n"/*    puts "Passing: #{arg} (##{arg.object_id})" */
"\n"/*    r = Ractor.new(arg) {|received_arg| */
"\n"/*      puts "Received: #{received_arg} (##{received_arg.object_id})" */
"\n"/*    } */
"\n"/*    r.take */
"\n"/*    # Prints: */
"\n"/*    #   Passing: [1, 2, 3] (#280) */
"\n"/*    #   Received: [1, 2, 3] (#300) */
"\n"/*  */
"\n"/* Ractor's +name+ can be set for debugging purposes: */
"\n"/*  */
"\n"/*    r = Ractor.new(name: 'my ractor') {} */
"\n"/*    p r */
"\n"/*    #=> #<Ractor:#3 my ractor test.rb:1 terminated> */
"\n"/*  */
"  def self.new(*args, name: nil, &block)\n"
"    b = block\n"/* TODO: builtin bug */
"    raise ArgumentError, \"must be called with a block\" unless block\n"
"    loc = caller_locations(1, 1).first\n"
"    loc = \"#{loc.path}:#{loc.lineno}\"\n"
"    __builtin_ractor_create(loc, name, args, b)\n"
"  end\n"
"\n"
"\n"/* Returns the currently executing Ractor. */
"\n"/*  */
"\n"/*   Ractor.current #=> #<Ractor:#1 running> */
"  def self.current\n"
"    __builtin_cexpr! %q{\n"
"      rb_ractor_self(rb_ec_ractor_ptr(ec));\n"
"    }\n"
"  end\n"
"\n"
"\n"/* Returns total count of Ractors currently running. */
"\n"/*  */
"\n"/*    Ractor.count                   #=> 1 */
"\n"/*    r = Ractor.new(name: 'example') { Ractor.yield(1) } */
"\n"/*    Ractor.count                   #=> 2 (main + example ractor) */
"\n"/*    r.take                         # wait for Ractor.yield(1) */
"\n"/*    r.take                         # wait till r will finish */
"\n"/*    Ractor.count                   #=> 1 */
"  def self.count\n"
"    __builtin_cexpr! %q{\n"
"      ULONG2NUM(GET_VM()->ractor.cnt);\n"
"    }\n"
"  end\n"
"\n"
"\n"/*  */
,
#line 294 "ractor.rb"
"\n"/* call-seq: */
"\n"/*    Ractor.select(*ractors, [yield_value:, move: false]) -> [ractor or symbol, obj] */
"\n"/*  */
"\n"/* Waits for the first ractor to have something in its outgoing port, reads from this ractor, and */
"\n"/* returns that ractor and the object received. */
"\n"/*  */
"\n"/*    r1 = Ractor.new {Ractor.yield 'from 1'} */
"\n"/*    r2 = Ractor.new {Ractor.yield 'from 2'} */
"\n"/*  */
"\n"/*    r, obj = Ractor.select(r1, r2) */
"\n"/*  */
"\n"/*    puts "received #{obj.inspect} from #{r.inspect}" */
"\n"/*    # Prints: received "from 1" from #<Ractor:#2 test.rb:1 running> */
"\n"/*  */
"\n"/* If one of the given ractors is the current ractor, and it would be selected, +r+ will contain */
"\n"/* +:receive+ symbol instead of the ractor object. */
"\n"/*  */
"\n"/*    r1 = Ractor.new(Ractor.current) do |main| */
"\n"/*      main.send 'to main' */
"\n"/*      Ractor.yield 'from 1' */
"\n"/*    end */
"\n"/*    r2 = Ractor.new do */
"\n"/*      Ractor.yield 'from 2' */
"\n"/*    end */
"\n"/*  */
"\n"/*    r, obj = Ractor.select(r1, r2, Ractor.current) */
"\n"/*    puts "received #{obj.inspect} from #{r.inspect}" */
"\n"/*    # Prints: received "to main" from :receive */
"\n"/*  */
"\n"/* If +yield_value+ is provided, that value may be yielded if another Ractor is calling #take. */
"\n"/* In this case, the pair <tt>[:yield, nil]</tt> would be returned: */
"\n"/*  */
"\n"/*    r1 = Ractor.new(Ractor.current) do |main| */
"\n"/*      puts "Received from main: #{main.take}" */
"\n"/*    end */
"\n"/*  */
"\n"/*    puts "Trying to select" */
"\n"/*    r, obj = Ractor.select(r1, Ractor.current, yield_value: 123) */
"\n"/*    wait */
"\n"/*    puts "Received #{obj.inspect} from #{r.inspect}" */
"\n"/*  */
"\n"/* This will print: */
"\n"/*  */
"\n"/*    Trying to select */
"\n"/*    Received from main: 123 */
"\n"/*    Received nil from :yield */
"\n"/*  */
"\n"/* +move+ boolean flag defines whether yielded value should be copied (default) or moved. */
"  def self.select(*ractors, yield_value: yield_unspecified = true, move: false)\n"
"    raise ArgumentError, 'specify at least one ractor or `yield_value`' if yield_unspecified && ractors.empty?\n"
"\n"
"    __builtin_cstmt! %q{\n"
"      const VALUE *rs = RARRAY_CONST_PTR_TRANSIENT(ractors);\n"
"      VALUE rv;\n"
"      VALUE v = ractor_select(ec, rs, RARRAY_LENINT(ractors),\n"
"                              yield_unspecified == Qtrue ? Qundef : yield_value,\n"
,
#line 350 "ractor.rb"
"                              (bool)RTEST(move) ? true : false, &rv);\n"
"      return rb_ary_new_from_args(2, rv, v);\n"
"    }\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/* call-seq: */
"\n"/*    Ractor.receive -> msg */
"\n"/*  */
"\n"/* Receive an incoming message from the current Ractor's incoming port's queue, which was */
"\n"/* sent there by #send. */
"\n"/*  */
"\n"/*     r = Ractor.new do */
"\n"/*       v1 = Ractor.receive */
"\n"/*       puts "Received: #{v1}" */
"\n"/*     end */
"\n"/*     r.send('message1') */
"\n"/*     r.take */
"\n"/*     # Here will be printed: "Received: message1" */
"\n"/*  */
"\n"/* Alternatively, private instance method +receive+ may be used: */
"\n"/*  */
"\n"/*     r = Ractor.new do */
"\n"/*       v1 = receive */
"\n"/*       puts "Received: #{v1}" */
"\n"/*     end */
"\n"/*     r.send('message1') */
"\n"/*     r.take */
"\n"/*     # Here will be printed: "Received: message1" */
"\n"/*  */
"\n"/* The method blocks if the queue is empty. */
"\n"/*  */
"\n"/*     r = Ractor.new do */
"\n"/*       puts "Before first receive" */
"\n"/*       v1 = Ractor.receive */
"\n"/*       puts "Received: #{v1}" */
"\n"/*       v2 = Ractor.receive */
"\n"/*       puts "Received: #{v2}" */
"\n"/*     end */
"\n"/*     wait */
"\n"/*     puts "Still not received" */
"\n"/*     r.send('message1') */
"\n"/*     wait */
"\n"/*     puts "Still received only one" */
"\n"/*     r.send('message2') */
"\n"/*     r.take */
"\n"/*  */
"\n"/* Output: */
"\n"/*  */
"\n"/*     Before first receive */
"\n"/*     Still not received */
"\n"/*     Received: message1 */
"\n"/*     Still received only one */
"\n"/*     Received: message2 */
"\n"/*  */
"\n"/* If close_incoming was called on the ractor, the method raises Ractor::ClosedError */
"\n"/* if there are no more messages in incoming queue: */
"\n"/*  */
"\n"/*     Ractor.new do */
"\n"/*       close_incoming */
"\n"/*       receive */
"\n"/*     end */
"\n"/*     wait */
"\n"/*     # in `receive': The incoming port is already closed => #<Ractor:#2 test.rb:1 running> (Ractor::ClosedError) */
"\n"/*  */
"  def self.receive\n"
"    __builtin_cexpr! %q{\n"
"      ractor_receive(ec, rb_ec_ractor_ptr(ec))\n"
"    }\n"
"  end\n"
"\n"
"  class << self\n"
"    alias recv receive\n"
"  end\n"
"\n"
"\n"/* same as Ractor.receive */
"  private def receive\n"
"    __builtin_cexpr! %q{\n"
"      ractor_receive(ec, rb_ec_ractor_ptr(ec))\n"
"    }\n"
"  end\n"
"  alias recv receive\n"
"\n"
"\n"/*  */
"\n"/* call-seq: */
"\n"/*    Ractor.receive_if {|msg| block } -> msg */
"\n"/*  */
"\n"/* Receive only a specific message. */
"\n"/*  */
"\n"/* Instead of Ractor.receive, Ractor.receive_if can provide a pattern */
"\n"/* by a block and you can choose the receiving message. */
"\n"/*  */
"\n"/*     r = Ractor.new do */
"\n"/*       p Ractor.receive_if{|msg| msg.match?(/foo/)} #=> "foo3" */
"\n"/*       p Ractor.receive_if{|msg| msg.match?(/bar/)} #=> "bar1" */
"\n"/*       p Ractor.receive_if{|msg| msg.match?(/baz/)} #=> "baz2" */
"\n"/*     end */
"\n"/*     r << "bar1" */
"\n"/*     r << "baz2" */
"\n"/*     r << "foo3" */
"\n"/*     r.take */
"\n"/*  */
"\n"/* This will output: */
"\n"/*  */
"\n"/*     foo3 */
"\n"/*     bar1 */
"\n"/*     baz2 */
"\n"/*  */
"\n"/* If the block returns a truthy value, the message will be removed from the incoming queue */
"\n"/* and returned. */
"\n"/* Otherwise, the message remains in the incoming queue and the following received */
"\n"/* messages are checked by the given block. */
"\n"/*  */
"\n"/* If there are no messages left in the incoming queue, the method will */
"\n"/* block until new messages arrive. */
"\n"/*  */
"\n"/* If the block is escaped by break/return/exception/throw, the message is removed from */
"\n"/* the incoming queue as if a truthy value had been returned. */
"\n"/*  */
"\n"/*     r = Ractor.new do */
"\n"/*       val = Ractor.receive_if{|msg| msg.is_a?(Array)} */
"\n"/*       puts "Received successfully: #{val}" */
"\n"/*     end */
"\n"/*  */
,
#line 474 "ractor.rb"
"\n"/*     r.send(1) */
"\n"/*     r.send('test') */
"\n"/*     wait */
"\n"/*     puts "2 non-matching sent, nothing received" */
"\n"/*     r.send([1, 2, 3]) */
"\n"/*     wait */
"\n"/*  */
"\n"/* Prints: */
"\n"/*  */
"\n"/*     2 non-matching sent, nothing received */
"\n"/*     Received successfully: [1, 2, 3] */
"\n"/*  */
"\n"/* Note that you can not call receive/receive_if in the given block recursively. */
"\n"/* It means that you should not do any tasks in the block. */
"\n"/*  */
"\n"/*     Ractor.current << true */
"\n"/*     Ractor.receive_if{|msg| Ractor.receive} */
"\n"/*     #=> `receive': can not call receive/receive_if recursively (Ractor::Error) */
"\n"/*  */
"  def self.receive_if &b\n"
"    Primitive.ractor_receive_if b\n"
"  end\n"
"\n"
"  private def receive_if &b\n"
"    Primitive.ractor_receive_if b\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/* call-seq: */
"\n"/*    ractor.send(msg, move: false) -> self */
"\n"/*  */
"\n"/* Send a message to a Ractor's incoming queue to be consumed by Ractor.receive. */
"\n"/*  */
"\n"/*   r = Ractor.new do */
"\n"/*     value = Ractor.receive */
"\n"/*     puts "Received #{value}" */
"\n"/*   end */
"\n"/*   r.send 'message' */
"\n"/*   # Prints: "Received: message" */
"\n"/*  */
"\n"/* The method is non-blocking (will return immediately even if the ractor is not ready */
"\n"/* to receive anything): */
"\n"/*  */
"\n"/*    r = Ractor.new {sleep(5)} */
"\n"/*    r.send('test') */
"\n"/*    puts "Sent successfully" */
"\n"/*    # Prints: "Sent successfully" immediately */
"\n"/*  */
"\n"/* Attempt to send to ractor which already finished its execution will raise Ractor::ClosedError. */
"\n"/*  */
"\n"/*   r = Ractor.new {} */
"\n"/*   r.take */
"\n"/*   p r */
"\n"/*   # "#<Ractor:#6 (irb):23 terminated>" */
"\n"/*   r.send('test') */
"\n"/*   # Ractor::ClosedError (The incoming-port is already closed) */
"\n"/*  */
"\n"/* If close_incoming was called on the ractor, the method also raises Ractor::ClosedError. */
"\n"/*  */
"\n"/*    r =  Ractor.new do */
"\n"/*      sleep(500) */
"\n"/*      receive */
"\n"/*    end */
"\n"/*    r.close_incoming */
"\n"/*    r.send('test') */
"\n"/*    # Ractor::ClosedError (The incoming-port is already closed) */
"\n"/*    # The error would be raised immediately, not when ractor will try to receive */
"\n"/*  */
"\n"/* If the +obj+ is unshareable, by default it would be copied into ractor by deep cloning. */
"\n"/* If the <tt>move: true</tt> is passed, object is _moved_ into ractor and becomes */
"\n"/* inaccessible to sender. */
"\n"/*  */
"\n"/*    r = Ractor.new {puts "Received: #{receive}"} */
"\n"/*    msg = 'message' */
"\n"/*    r.send(msg, move: true) */
"\n"/*    r.take */
"\n"/*    p msg */
"\n"/*  */
"\n"/* This prints: */
"\n"/*  */
"\n"/*    Received: message */
"\n"/*    in `p': undefined method `inspect' for #<Ractor::MovedObject:0x000055c99b9b69b8> */
"\n"/*  */
"\n"/* All references to the object and its parts will become invalid in sender. */
"\n"/*  */
"\n"/*    r = Ractor.new {puts "Received: #{receive}"} */
"\n"/*    s = 'message' */
"\n"/*    ary = [s] */
"\n"/*    copy = ary.dup */
"\n"/*    r.send(ary, move: true) */
"\n"/*  */
"\n"/*    s.inspect */
"\n"/*    # Ractor::MovedError (can not send any methods to a moved object) */
"\n"/*    ary.class */
"\n"/*    # Ractor::MovedError (can not send any methods to a moved object) */
"\n"/*    copy.class */
"\n"/*    # => Array, it is different object */
"\n"/*    copy[0].inspect */
"\n"/*    # Ractor::MovedError (can not send any methods to a moved object) */
"\n"/*    # ...but its item was still a reference to `s`, which was moved */
"\n"/*  */
"\n"/* If the object was shareable, <tt>move: true</tt> has no effect on it: */
"\n"/*  */
"\n"/*    r = Ractor.new {puts "Received: #{receive}"} */
"\n"/*    s = 'message'.freeze */
"\n"/*    r.send(s, move: true) */
"\n"/*    s.inspect #=> "message", still available */
"\n"/*  */
"  def send(obj, move: false)\n"
"    __builtin_cexpr! %q{\n"
"      ractor_send(ec, RACTOR_PTR(self), obj, move)\n"
"    }\n"
"  end\n"
"  alias << send\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     Ractor.yield(msg, move: false) -> nil */
"\n"/*  */
"\n"/* Send a message to the current ractor's outgoing port to be consumed by #take. */
"\n"/*  */
"\n"/*    r = Ractor.new {Ractor.yield 'Hello from ractor'} */
"\n"/*    puts r.take */
"\n"/*    # Prints: "Hello from ractor" */
"\n"/*  */
"\n"/* The method is blocking, and will return only when somebody consumes the */
"\n"/* sent message. */
"\n"/*  */
"\n"/*    r = Ractor.new do */
"\n"/*      Ractor.yield 'Hello from ractor' */
"\n"/*      puts "Ractor: after yield" */
"\n"/*    end */
"\n"/*    wait */
"\n"/*    puts "Still not taken" */
"\n"/*    puts r.take */
"\n"/*  */
"\n"/* This will print: */
"\n"/*  */
"\n"/*    Still not taken */
"\n"/*    Hello from ractor */
"\n"/*    Ractor: after yield */
"\n"/*  */
"\n"/* If the outgoing port was closed with #close_outgoing, the method will raise: */
"\n"/*  */
"\n"/*    r = Ractor.new do */
"\n"/*      close_outgoing */
"\n"/*      Ractor.yield 'Hello from ractor' */
"\n"/*    end */
"\n"/*    wait */
"\n"/*    # `yield': The outgoing-port is already closed (Ractor::ClosedError) */
"\n"/*  */
"\n"/* The meaning of +move+ argument is the same as for #send. */
"  def self.yield(obj, move: false)\n"
"    __builtin_cexpr! %q{\n"
,
#line 628 "ractor.rb"
"      ractor_yield(ec, rb_ec_ractor_ptr(ec), obj, move)\n"
"    }\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     ractor.take -> msg */
"\n"/*  */
"\n"/* Take a message from ractor's outgoing port, which was put there by Ractor.yield or at ractor's */
"\n"/* finalization. */
"\n"/*  */
"\n"/*   r = Ractor.new do */
"\n"/*     Ractor.yield 'explicit yield' */
"\n"/*     'last value' */
"\n"/*   end */
"\n"/*   puts r.take #=> 'explicit yield' */
"\n"/*   puts r.take #=> 'last value' */
"\n"/*   puts r.take # Ractor::ClosedError (The outgoing-port is already closed) */
"\n"/*  */
"\n"/* The fact that the last value is also put to outgoing port means that +take+ can be used */
"\n"/* as some analog of Thread#join ("just wait till ractor finishes"), but don't forget it */
"\n"/* will raise if somebody had already consumed everything ractor have produced. */
"\n"/*  */
"\n"/* If the outgoing port was closed with #close_outgoing, the method will raise Ractor::ClosedError. */
"\n"/*  */
"\n"/*    r = Ractor.new do */
"\n"/*      sleep(500) */
"\n"/*      Ractor.yield 'Hello from ractor' */
"\n"/*    end */
"\n"/*    r.close_outgoing */
"\n"/*    r.take */
"\n"/*    # Ractor::ClosedError (The outgoing-port is already closed) */
"\n"/*    # The error would be raised immediately, not when ractor will try to receive */
"\n"/*  */
"\n"/* If an uncaught exception is raised in the Ractor, it is propagated on take as a */
"\n"/* Ractor::RemoteError. */
"\n"/*  */
"\n"/*   r = Ractor.new {raise "Something weird happened"} */
"\n"/*  */
"\n"/*   begin */
"\n"/*     r.take */
"\n"/*   rescue => e */
"\n"/*     p e              #  => #<Ractor::RemoteError: thrown by remote Ractor.> */
"\n"/*     p e.ractor == r  # => true */
"\n"/*     p e.cause        # => #<RuntimeError: Something weird happened> */
"\n"/*   end */
"\n"/*  */
"\n"/* Ractor::ClosedError is a descendant of StopIteration, so the closing of the ractor will break */
"\n"/* the loops without propagating the error: */
"\n"/*  */
"\n"/*     r = Ractor.new do */
"\n"/*       3.times {|i| Ractor.yield "message #{i}"} */
"\n"/*       "finishing" */
"\n"/*     end */
"\n"/*  */
"\n"/*     loop {puts "Received: " + r.take} */
"\n"/*     puts "Continue successfully" */
"\n"/*  */
"\n"/* This will print: */
"\n"/*  */
"\n"/*     Received: message 0 */
"\n"/*     Received: message 1 */
"\n"/*     Received: message 2 */
"\n"/*     Received: finishing */
"\n"/*     Continue successfully */
"  def take\n"
"    __builtin_cexpr! %q{\n"
"      ractor_take(ec, RACTOR_PTR(self))\n"
"    }\n"
"  end\n"
"\n"
"  def inspect\n"
"    loc  = __builtin_cexpr! %q{ RACTOR_PTR(self)->loc }\n"
"    name = __builtin_cexpr! %q{ RACTOR_PTR(self)->name }\n"
"    id   = __builtin_cexpr! %q{ INT2FIX(rb_ractor_id(RACTOR_PTR(self))) }\n"
"    status = __builtin_cexpr! %q{\n"
,
#line 704 "ractor.rb"
"      rb_str_new2(ractor_status_str(RACTOR_PTR(self)->status_))\n"
"    }\n"
"    \"#<Ractor:##{id}#{name ? ' '+name : ''}#{loc ? \" \" + loc : ''} #{status}>\"\n"
"  end\n"
"\n"
"  alias to_s inspect\n"
"\n"
"\n"/* The name set in Ractor.new, or +nil+. */
"  def name\n"
"    __builtin_cexpr! %q{RACTOR_PTR(self)->name}\n"
"  end\n"
"\n"
"  class RemoteError\n"
"    attr_reader :ractor\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     ractor.close_incoming -> true | false */
"\n"/*  */
"\n"/* Closes the incoming port and returns its previous state. */
"\n"/* All further attempts to Ractor.receive in the ractor, and #send to the ractor */
"\n"/* will fail with Ractor::ClosedError. */
"\n"/*  */
"\n"/*   r = Ractor.new {sleep(500)} */
"\n"/*   r.close_incoming  #=> false */
"\n"/*   r.close_incoming  #=> true */
"\n"/*   r.send('test') */
"\n"/*   # Ractor::ClosedError (The incoming-port is already closed) */
"  def close_incoming\n"
"    __builtin_cexpr! %q{\n"
"      ractor_close_incoming(ec, RACTOR_PTR(self));\n"
"    }\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/* call-seq: */
"\n"/*    ractor.close_outgoing -> true | false */
"\n"/*  */
"\n"/* Closes the outgoing port and returns its previous state. */
"\n"/* All further attempts to Ractor.yield in the ractor, and #take from the ractor */
"\n"/* will fail with Ractor::ClosedError. */
"\n"/*  */
"\n"/*   r = Ractor.new {sleep(500)} */
"\n"/*   r.close_outgoing  #=> false */
"\n"/*   r.close_outgoing  #=> true */
"\n"/*   r.take */
"\n"/*   # Ractor::ClosedError (The outgoing-port is already closed) */
"  def close_outgoing\n"
"    __builtin_cexpr! %q{\n"
,
#line 754 "ractor.rb"
"      ractor_close_outgoing(ec, RACTOR_PTR(self));\n"
"    }\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/* call-seq: */
"\n"/*    Ractor.shareable?(obj) -> true | false */
"\n"/*  */
"\n"/* Checks if the object is shareable by ractors. */
"\n"/*  */
"\n"/*     Ractor.shareable?(1)            #=> true -- numbers and other immutable basic values are frozen */
"\n"/*     Ractor.shareable?('foo')        #=> false, unless the string is frozen due to # freeze_string_literals: true */
"\n"/*     Ractor.shareable?('foo'.freeze) #=> true */
"\n"/*  */
"\n"/* See also the "Shareable and unshareable objects" section in the Ractor class docs. */
"  def self.shareable? obj\n"
"    __builtin_cexpr! %q{\n"
"      RBOOL(rb_ractor_shareable_p(obj));\n"
"    }\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/* call-seq: */
"\n"/*    Ractor.make_shareable(obj, copy: false) -> shareable_obj */
"\n"/*  */
"\n"/* Make +obj+ shareable between ractors. */
"\n"/*  */
"\n"/* +obj+ and all the objects it refers to will be frozen, unless they are */
"\n"/* already shareable. */
"\n"/*  */
"\n"/* If +copy+ keyword is +true+, the method will copy objects before freezing them */
"\n"/* This is safer option but it can take be slower. */
"\n"/*  */
"\n"/* Note that the specification and implementation of this method are not */
"\n"/* mature and may be changed in the future. */
"\n"/*  */
"\n"/*   obj = ['test'] */
"\n"/*   Ractor.shareable?(obj)     #=> false */
"\n"/*   Ractor.make_shareable(obj) #=> ["test"] */
"\n"/*   Ractor.shareable?(obj)     #=> true */
"\n"/*   obj.frozen?                #=> true */
"\n"/*   obj[0].frozen?             #=> true */
"\n"/*  */
"\n"/*   # Copy vs non-copy versions: */
"\n"/*   obj1 = ['test'] */
"\n"/*   obj1s = Ractor.make_shareable(obj1) */
"\n"/*   obj1.frozen?                        #=> true */
"\n"/*   obj1s.object_id == obj1.object_id   #=> true */
"\n"/*   obj2 = ['test'] */
"\n"/*   obj2s = Ractor.make_shareable(obj2, copy: true) */
"\n"/*   obj2.frozen?                        #=> false */
"\n"/*   obj2s.frozen?                       #=> true */
"\n"/*   obj2s.object_id == obj2.object_id   #=> false */
"\n"/*   obj2s[0].object_id == obj2[0].object_id #=> false */
"\n"/*  */
"\n"/* See also the "Shareable and unshareable objects" section in the Ractor class docs. */
"  def self.make_shareable obj, copy: false\n"
"    if copy\n"
"      __builtin_cexpr! %q{\n"
"        rb_ractor_make_shareable_copy(obj);\n"
"      }\n"
"    else\n"
"      __builtin_cexpr! %q{\n"
"        rb_ractor_make_shareable(obj);\n"
"      }\n"
"    end\n"
"  end\n"
"\n"
"\n"/* get a value from ractor-local storage */
"  def [](sym)\n"
"    Primitive.ractor_local_value(sym)\n"
"  end\n"
"\n"
"\n"/* set a value in ractor-local storage */
,
#line 828 "ractor.rb"
"  def []=(sym, val)\n"
"    Primitive.ractor_local_value_set(sym, val)\n"
"  end\n"
"\n"
"\n"/* returns main ractor */
"  def self.main\n"
"    __builtin_cexpr! %q{\n"
"      rb_ractor_self(GET_VM()->ractor.main_ractor);\n"
"    }\n"
"  end\n"
"end\n"
#line 3351 "miniprelude.c"
};

static const char prelude_name12[] = "<internal:timev>";
static const struct {
    char L0[497]; /* 1..296 */
    char L296[334]; /* 297..312 */
} prelude_code12 = {
#line 1 "timev.rb"
""/* Time is an abstraction of dates and times. Time is stored internally as */
""/* the number of seconds with subsecond since the _Epoch_, */
""/* 1970-01-01 00:00:00 UTC. */
""/*  */
""/* The Time class treats GMT */
""/* (Greenwich Mean Time) and UTC (Coordinated Universal Time) as equivalent. */
""/* GMT is the older way of referring to these baseline times but persists in */
""/* the names of calls on POSIX systems. */
""/*  */
""/* Note: A \Time object uses the resolution available on your system clock. */
""/*  */
""/* All times may have subsecond. Be aware of this fact when comparing times */
""/* with each other -- times that are apparently equal when displayed may be */
""/* different when compared. */
""/* (Since Ruby 2.7.0, Time#inspect shows subsecond but */
""/* Time#to_s still doesn't show subsecond.) */
""/*  */
""/* == Examples */
""/*  */
""/* All of these examples were done using the EST timezone which is GMT-5. */
""/*  */
""/* === Creating a New \Time Instance */
""/*  */
""/* You can create a new instance of Time with Time.new. This will use the */
""/* current system time. Time.now is an alias for this. You can also */
""/* pass parts of the time to Time.new such as year, month, minute, etc. When */
""/* you want to construct a time this way you must pass at least a year. If you */
""/* pass the year with nothing else time will default to January 1 of that year */
""/* at 00:00:00 with the current system timezone. Here are some examples: */
""/*  */
""/*   Time.new(2002)         #=> 2002-01-01 00:00:00 -0500 */
""/*   Time.new(2002, 10)     #=> 2002-10-01 00:00:00 -0500 */
""/*   Time.new(2002, 10, 31) #=> 2002-10-31 00:00:00 -0500 */
""/*  */
""/* You can pass a UTC offset: */
""/*  */
""/*   Time.new(2002, 10, 31, 2, 2, 2, "+02:00") #=> 2002-10-31 02:02:02 +0200 */
""/*  */
""/* Or a timezone object: */
""/*  */
""/*   zone = timezone("Europe/Athens")      # Eastern European Time, UTC+2 */
""/*   Time.new(2002, 10, 31, 2, 2, 2, zone) #=> 2002-10-31 02:02:02 +0200 */
""/*  */
""/* You can also use Time.local and Time.utc to infer */
""/* local and UTC timezones instead of using the current system */
""/* setting. */
""/*  */
""/* You can also create a new time using Time.at which takes the number of */
""/* seconds (with subsecond) since the {Unix */
""/* Epoch}[https://en.wikipedia.org/wiki/Unix_time]. */
""/*  */
""/*   Time.at(628232400) #=> 1989-11-28 00:00:00 -0500 */
""/*  */
""/* === Working with an Instance of \Time */
""/*  */
""/* Once you have an instance of Time there is a multitude of things you can */
""/* do with it. Below are some examples. For all of the following examples, we */
""/* will work on the assumption that you have done the following: */
""/*  */
""/*   t = Time.new(1993, 02, 24, 12, 0, 0, "+09:00") */
""/*  */
""/* Was that a monday? */
""/*  */
""/*   t.monday? #=> false */
""/*  */
""/* What year was that again? */
""/*  */
""/*   t.year #=> 1993 */
""/*  */
""/* Was it daylight savings at the time? */
""/*  */
""/*   t.dst? #=> false */
""/*  */
""/* What's the day a year later? */
""/*  */
""/*   t + (60*60*24*365) #=> 1994-02-24 12:00:00 +0900 */
""/*  */
""/* How many seconds was that since the Unix Epoch? */
""/*  */
""/*   t.to_i #=> 730522800 */
""/*  */
""/* You can also do standard functions like compare two times. */
""/*  */
""/*   t1 = Time.new(2010) */
""/*   t2 = Time.new(2011) */
""/*  */
""/*   t1 == t2 #=> false */
""/*   t1 == t1 #=> true */
""/*   t1 <  t2 #=> true */
""/*   t1 >  t2 #=> false */
""/*  */
""/*   Time.new(2010,10,31).between?(t1, t2) #=> true */
""/*  */
""/* == What's Here */
""/*  */
""/* First, what's elsewhere. \Class \Time: */
""/*  */
""/* - Inherits from {class Object}[rdoc-ref:Object@What-27s+Here]. */
""/* - Includes {module Comparable}[rdoc-ref:Comparable@What-27s+Here]. */
""/*  */
""/* Here, class \Time provides methods that are useful for: */
""/*  */
""/* - {Creating \Time objects}[rdoc-ref:Time@Methods+for+Creating]. */
""/* - {Fetching \Time values}[rdoc-ref:Time@Methods+for+Fetching]. */
""/* - {Querying a \Time object}[rdoc-ref:Time@Methods+for+Querying]. */
""/* - {Comparing \Time objects}[rdoc-ref:Time@Methods+for+Comparing]. */
""/* - {Converting a \Time object}[rdoc-ref:Time@Methods+for+Converting]. */
""/* - {Rounding a \Time}[rdoc-ref:Time@Methods+for+Rounding]. */
""/*  */
""/* === Methods for Creating */
""/*  */
""/* - ::new: Returns a new time from specified arguments (year, month, etc.), */
""/*   including an optional timezone value. */
""/* - ::local (aliased as ::mktime): Same as ::new, except the */
""/*   timezone is the local timezone. */
""/* - ::utc (aliased as ::gm): Same as ::new, except the timezone is UTC. */
""/* - ::at: Returns a new time based on seconds since epoch. */
""/* - ::now: Returns a new time based on the current system time. */
""/* - #+ (plus): Returns a new time increased by the given number of seconds. */
""/* - #- (minus): Returns a new time decreased by the given number of seconds. */
""/*  */
""/* === Methods for Fetching */
""/*  */
""/* - #year: Returns the year of the time. */
""/* - #month (aliased as #mon): Returns the month of the time. */
""/* - #mday (aliased as #day): Returns the day of the month. */
""/* - #hour: Returns the hours value for the time. */
""/* - #min: Returns the minutes value for the time. */
""/* - #sec: Returns the seconds value for the time. */
""/* - #usec (aliased as #tv_usec): Returns the number of microseconds */
""/*   in the subseconds value of the time. */
""/* - #nsec (aliased as #tv_nsec: Returns the number of nanoseconds */
""/*   in the subsecond part of the time. */
""/* - #subsec: Returns the subseconds value for the time. */
""/* - #wday: Returns the integer weekday value of the time (0 == Sunday). */
""/* - #yday: Returns the integer yearday value of the time (1 == January 1). */
""/* - #hash: Returns the integer hash value for the time. */
""/* - #utc_offset (aliased as #gmt_offset and #gmtoff): Returns the offset */
""/*   in seconds between time and UTC. */
""/* - #to_f: Returns the float number of seconds since epoch for the time. */
""/* - #to_i (aliased as #tv_sec): Returns the integer number of seconds since epoch */
""/*   for the time. */
""/* - #to_r: Returns the Rational number of seconds since epoch for the time. */
""/* - #zone: Returns a string representation of the timezone of the time. */
""/*  */
""/* === Methods for Querying */
""/*  */
""/* - #utc? (aliased as #gmt?): Returns whether the time is UTC. */
""/* - #dst? (aliased as #isdst): Returns whether the time is DST (daylight saving time). */
""/* - #sunday?: Returns whether the time is a Sunday. */
""/* - #monday?: Returns whether the time is a Monday. */
""/* - #tuesday?: Returns whether the time is a Tuesday. */
""/* - #wednesday?: Returns whether the time is a Wednesday. */
""/* - #thursday?: Returns whether the time is a Thursday. */
""/* - #friday?: Returns whether time is a Friday. */
""/* - #saturday?: Returns whether the time is a Saturday. */
""/*  */
""/* === Methods for Comparing */
""/*  */
""/* - #<=>: Compares +self+ to another time. */
""/* - #eql?: Returns whether the time is equal to another time. */
""/*  */
""/* === Methods for Converting */
""/*  */
""/* - #asctime (aliased as #ctime): Returns the time as a string. */
""/* - #inspect: Returns the time in detail as a string. */
""/* - #strftime: Returns the time as a string, according to a given format. */
""/* - #to_a: Returns a 10-element array of values from the time. */
""/* - #to_s: Returns a string representation of the time. */
""/* - #getutc (aliased as #getgm): Returns a new time converted to UTC. */
""/* - #getlocal: Returns a new time converted to local time. */
""/* - #utc (aliased as #gmtime): Converts time to UTC in place. */
""/* - #localtime: Converts time to local time in place. */
""/*  */
""/* === Methods for Rounding */
""/*  */
""/* - #round:Returns a new time with subseconds rounded. */
""/* - #ceil: Returns a new time with subseconds raised to a ceiling. */
""/* - #floor: Returns a new time with subseconds lowered to a floor. */
""/*  */
""/* == Timezone Argument */
""/*  */
""/* A timezone argument must have +local_to_utc+ and +utc_to_local+ */
""/* methods, and may have +name+, +abbr+, and +dst?+ methods. */
""/*  */
""/* The +local_to_utc+ method should convert a Time-like object from */
""/* the timezone to UTC, and +utc_to_local+ is the opposite.  The */
""/* result also should be a Time or Time-like object (not necessary to */
""/* be the same class).  The #zone of the result is just ignored. */
""/* Time-like argument to these methods is similar to a Time object in */
""/* UTC without subsecond; it has attribute readers for the parts, */
""/* e.g. #year, #month, and so on, and epoch time readers, #to_i.  The */
""/* subsecond attributes are fixed as 0, and #utc_offset, #zone, */
""/* #isdst, and their aliases are same as a Time object in UTC. */
""/* Also #to_time, #+, and #- methods are defined. */
""/*  */
""/* The +name+ method is used for marshaling. If this method is not */
""/* defined on a timezone object, Time objects using that timezone */
""/* object can not be dumped by Marshal. */
""/*  */
""/* The +abbr+ method is used by '%Z' in #strftime. */
""/*  */
""/* The +dst?+ method is called with a +Time+ value and should return whether */
""/* the +Time+ value is in daylight savings time in the zone. */
""/*  */
""/* === Auto Conversion to Timezone */
""/*  */
""/* At loading marshaled data, a timezone name will be converted to a timezone */
""/* object by +find_timezone+ class method, if the method is defined. */
""/*  */
""/* Similarly, that class method will be called when a timezone argument does */
""/* not have the necessary methods mentioned above. */
"class Time\n"
"\n"/* Creates a new \Time object from the current system time. */
"\n"/* This is the same as Time.new without arguments. */
"\n"/*  */
"\n"/*    Time.now               # => 2009-06-24 12:39:54 +0900 */
"\n"/*    Time.now(in: '+04:00') # => 2009-06-24 07:39:54 +0400 */
"\n"/*  */
"\n"/* Parameter: */
"\n"/* :include: doc/time/in.rdoc */
"  def self.now(in: nil)\n"
"    Primitive.time_s_now(Primitive.arg!(:in))\n"
"  end\n"
"\n"
"\n"/* _Time_ */
"\n"/*  */
"\n"/* This form accepts a \Time object +time+ */
"\n"/* and optional keyword argument +in+: */
"\n"/*  */
"\n"/*   Time.at(Time.new)               # => 2021-04-26 08:52:31.6023486 -0500 */
"\n"/*   Time.at(Time.new, in: '+09:00') # => 2021-04-26 22:52:31.6023486 +0900 */
"\n"/*  */
"\n"/* _Seconds_ */
"\n"/*  */
"\n"/* This form accepts a numeric number of seconds +sec+ */
"\n"/* and optional keyword argument +in+: */
"\n"/*  */
"\n"/*   Time.at(946702800)               # => 1999-12-31 23:00:00 -0600 */
"\n"/*   Time.at(946702800, in: '+09:00') # => 2000-01-01 14:00:00 +0900 */
"\n"/*  */
"\n"/* <em>Seconds with Subseconds and Units</em> */
"\n"/*  */
"\n"/* This form accepts an integer number of seconds +sec_i+, */
"\n"/* a numeric number of milliseconds +msec+, */
"\n"/* a symbol argument for the subsecond unit type (defaulting to :usec), */
"\n"/* and an optional keyword argument +in+: */
"\n"/*  */
"\n"/*   Time.at(946702800, 500, :millisecond)               # => 1999-12-31 23:00:00.5 -0600 */
"\n"/*   Time.at(946702800, 500, :millisecond, in: '+09:00') # => 2000-01-01 14:00:00.5 +0900 */
"\n"/*   Time.at(946702800, 500000)                             # => 1999-12-31 23:00:00.5 -0600 */
"\n"/*   Time.at(946702800, 500000, :usec)                      # => 1999-12-31 23:00:00.5 -0600 */
"\n"/*   Time.at(946702800, 500000, :microsecond)               # => 1999-12-31 23:00:00.5 -0600 */
"\n"/*   Time.at(946702800, 500000, in: '+09:00')               # => 2000-01-01 14:00:00.5 +0900 */
"\n"/*   Time.at(946702800, 500000, :usec, in: '+09:00')        # => 2000-01-01 14:00:00.5 +0900 */
"\n"/*   Time.at(946702800, 500000, :microsecond, in: '+09:00') # => 2000-01-01 14:00:00.5 +0900 */
"\n"/*   Time.at(946702800, 500000000, :nsec)                     # => 1999-12-31 23:00:00.5 -0600 */
"\n"/*   Time.at(946702800, 500000000, :nanosecond)               # => 1999-12-31 23:00:00.5 -0600 */
"\n"/*   Time.at(946702800, 500000000, :nsec, in: '+09:00')       # => 2000-01-01 14:00:00.5 +0900 */
"\n"/*   Time.at(946702800, 500000000, :nanosecond, in: '+09:00') # => 2000-01-01 14:00:00.5 +0900 */
"\n"/*  */
"\n"/* Parameters: */
"\n"/* :include: doc/time/sec_i.rdoc */
"\n"/* :include: doc/time/msec.rdoc */
"\n"/* :include: doc/time/usec.rdoc */
"\n"/* :include: doc/time/nsec.rdoc */
"\n"/* :include: doc/time/in.rdoc */
"\n"/*  */
"  def self.at(time, subsec = false, unit = :microsecond, in: nil)\n"
"    if Primitive.mandatory_only?\n"
"      Primitive.time_s_at1(time)\n"
"    else\n"
"      Primitive.time_s_at(time, subsec, unit, Primitive.arg!(:in))\n"
"    end\n"
"  end\n"
"\n"
"\n"/* Returns a new \Time object based on the given arguments. */
"\n"/*  */
"\n"/* With no positional arguments, returns the value of Time.now: */
"\n"/*  */
"\n"/*   Time.new                                       # => 2021-04-24 17:27:46.0512465 -0500 */
"\n"/*  */
"\n"/* Otherwise, returns a new \Time object based on the given parameters: */
"\n"/*  */
"\n"/*   Time.new(2000)                                 # => 2000-01-01 00:00:00 -0600 */
"\n"/*   Time.new(2000, 12, 31, 23, 59, 59.5)           # => 2000-12-31 23:59:59.5 -0600 */
"\n"/*   Time.new(2000, 12, 31, 23, 59, 59.5, '+09:00') # => 2000-12-31 23:59:59.5 +0900 */
"\n"/*  */
"\n"/* Parameters: */
"\n"/*  */
"\n"/* :include: doc/time/year.rdoc */
"\n"/* :include: doc/time/mon-min.rdoc */
"\n"/* :include: doc/time/sec.rdoc */
"\n"/* :include: doc/time/zone_and_in.rdoc */
"\n"/*  */
"  def initialize(year = (now = true), mon = nil, mday = nil, hour = nil, min = nil, sec = nil, zone = nil, in: nil)\n"
,
#line 297 "timev.rb"
"    if zone\n"
"      if Primitive.arg!(:in)\n"
"        raise ArgumentError, \"timezone argument given as positional and keyword arguments\"\n"
"      end\n"
"    else\n"
"      zone = Primitive.arg!(:in)\n"
"    end\n"
"\n"
"    if now\n"
"      return Primitive.time_init_now(zone)\n"
"    end\n"
"\n"
"    Primitive.time_init_args(year, mon, mday, hour, min, sec, zone)\n"
"  end\n"
"end\n"
#line 3673 "miniprelude.c"
};

static const char prelude_name13[] = "<internal:nilclass>";
static const struct {
    char L0[98]; /* 1..26 */
} prelude_code13 = {
#line 1 "nilclass.rb"
"class NilClass\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     nil.to_i -> 0 */
"\n"/*  */
"\n"/*  Always returns zero. */
"\n"/*  */
"\n"/*     nil.to_i   #=> 0 */
"\n"/*  */
"  def to_i\n"
"    return 0\n"
"  end\n"
"\n"
"\n"/*  */
"\n"/*  call-seq: */
"\n"/*     nil.to_f    -> 0.0 */
"\n"/*  */
"\n"/*  Always returns zero. */
"\n"/*  */
"\n"/*     nil.to_f   #=> 0.0 */
"\n"/*  */
"  def to_f\n"
"    return 0.0\n"
"  end\n"
"end\n"
#line 3706 "miniprelude.c"
};

static const char prelude_name14[] = "<internal:prelude>";
static const struct {
    char L0[310]; /* 1..32 */
} prelude_code14 = {
#line 1 "prelude.rb"
"class Binding\n"
"\n"/* :nodoc: */
"  def irb\n"
"    require 'irb'\n"
"    irb\n"
"  end\n"
"\n"
"\n"/* suppress redefinition warning */
"  alias irb irb\n"/* :nodoc: */
"end\n"
"\n"
"module Kernel\n"
"  def pp(*objs)\n"
"    require 'pp'\n"
"    pp(*objs)\n"
"  end\n"
"\n"
"\n"/* suppress redefinition warning */
"  alias pp pp\n"/* :nodoc: */
"\n"
"  private :pp\n"
"end\n"
"\n"
"autoload :Set, 'set'\n"
"\n"
"module Enumerable\n"
"\n"/* Makes a set from the enumerable object with given arguments. */
"  def to_set(klass = Set, *args, &block)\n"
"    klass.new(self, *args, &block)\n"
"  end\n"
"end\n"
#line 3745 "miniprelude.c"
};

static const char prelude_name15[] = "<internal:gem_prelude>";
static const struct {
    char L0[388]; /* 1..20 */
} prelude_code15 = {
#line 1 "gem_prelude.rb"
"begin\n"
"  require 'rubygems'\n"
"rescue LoadError => e\n"
"  raise unless e.path == 'rubygems'\n"
"\n"
"  warn \"`RubyGems' were not loaded.\"\n"
"end if defined?(Gem)\n"
"\n"
"begin\n"
"  require 'error_highlight'\n"
"rescue LoadError\n"
"  warn \"`error_highlight' was not loaded.\"\n"
"end if defined?(ErrorHighlight)\n"
"\n"
"begin\n"
"  require 'did_you_mean'\n"
"rescue LoadError\n"
"  warn \"`did_you_mean' was not loaded.\"\n"
"end if defined?(DidYouMean)\n"
#line 3772 "miniprelude.c"
};

static const char prelude_name16[] = "<internal:yjit>";
static const struct {
    char L0[475]; /* 1..34 */
    char L34[474]; /* 35..42 */
    char L42[498]; /* 43..59 */
    char L59[456]; /* 60..80 */
    char L80[483]; /* 81..91 */
    char L91[507]; /* 92..107 */
    char L107[483]; /* 108..123 */
    char L123[498]; /* 124..155 */
    char L155[459]; /* 156..175 */
    char L175[435]; /* 176..180 */
    char L180[451]; /* 181..192 */
    char L192[423]; /* 193..203 */
    char L203[451]; /* 204..208 */
    char L208[479]; /* 209..215 */
    char L215[452]; /* 216..229 */
    char L229[488]; /* 230..240 */
    char L240[490]; /* 241..257 */
    char L257[425]; /* 258..269 */
    char L269[370]; /* 270..280 */
} prelude_code16 = {
#line 1 "yjit.rb"
""/* frozen_string_literal: true */
""
""/* This module allows for introspection of YJIT, CRuby's experimental in-process */
""/* just-in-time compiler. This module exists only to help develop YJIT, as such, */
""/* everything in the module is highly implementation specific and comes with no */
""/* API stability guarantee whatsoever. */
""/*  */
""/* This module may not exist if YJIT does not support the particular platform */
""/* for which CRuby is built. There is also no API stability guarantee as to in */
""/* what situations this module is defined. */
"module RubyVM::YJIT\n"
"  if defined?(Disasm)\n"
"    def self.disasm(iseq, tty: $stdout && $stdout.tty?)\n"
"      iseq = RubyVM::InstructionSequence.of(iseq)\n"
"\n"
"      blocks = blocks_for(iseq)\n"
"      return if blocks.empty?\n"
"\n"
"      str = String.new\n"
"      str << iseq.disasm\n"
"      str << \"\\n\"\n"
"\n"
"\n"/* Sort the blocks by increasing addresses */
"      sorted_blocks = blocks.sort_by(&:address)\n"
"\n"
"      highlight = ->(str) {\n"
"        if tty\n"
"          \"\\x1b[1m#{str}\\x1b[0m\"\n"
"        else\n"
"          str\n"
"        end\n"
"      }\n"
"\n"
"      cs = Disasm.new\n"
,
#line 35 "yjit.rb"
"      sorted_blocks.each_with_index do |block, i|\n"
"        str << \"== BLOCK #{i+1}/#{blocks.length}: #{block.code.length} BYTES, ISEQ RANGE [#{block.iseq_start_index},#{block.iseq_end_index}) \".ljust(80, \"=\")\n"
"        str << \"\\n\"\n"
"\n"
"        comments = comments_for(block.address, block.address + block.code.length)\n"
"        comment_idx = 0\n"
"        cs.disasm(block.code, block.address).each do |i|\n"
"          while (comment = comments[comment_idx]) && comment.address <= i.address\n"
,
#line 43 "yjit.rb"
"            str << \"  ; #{highlight.call(comment.comment)}\\n\"\n"
"            comment_idx += 1\n"
"          end\n"
"\n"
"          str << sprintf(\n"
"            \"  %<address>08x:  %<instruction>s\\t%<details>s\\n\",\n"
"            address: i.address,\n"
"            instruction: i.mnemonic,\n"
"            details: i.op_str\n"
"          )\n"
"        end\n"
"      end\n"
"\n"
"      block_sizes = blocks.map { |block| block.code.length }\n"
"      total_bytes = block_sizes.sum\n"
"      str << \"\\n\"\n"
"      str << \"Total code size: #{total_bytes} bytes\"\n"
,
#line 60 "yjit.rb"
"      str << \"\\n\"\n"
"\n"
"      str\n"
"    end\n"
"\n"
"    def self.comments_for(start_address, end_address)\n"
"      Primitive.comments_for(start_address, end_address)\n"
"    end\n"
"\n"
"    def self.graphviz_for(iseq)\n"
"      iseq = RubyVM::InstructionSequence.of(iseq)\n"
"      cs = Disasm.new\n"
"\n"
"      highlight = ->(comment) { \"<b>#{comment}</b>\" }\n"
"      linebreak = \"<br align=\\\"left\\\"/>\\n\"\n"
"\n"
"      buff = +''\n"
"      blocks = blocks_for(iseq).sort_by(&:id)\n"
"      buff << \"digraph g {\\n\"\n"
"\n"
"\n"/* Write the iseq info as a legend */
,
#line 81 "yjit.rb"
"      buff << \"  legend [shape=record fontsize=\\\"30\\\" fillcolor=\\\"lightgrey\\\" style=\\\"filled\\\"];\\n\"\n"
"      buff << \"  legend [label=\\\"{ Instruction Disassembly For: | {#{iseq.base_label}@#{iseq.absolute_path}:#{iseq.first_lineno}}}\\\"];\\n\"\n"
"\n"
"\n"/* Subgraph contains disassembly */
"      buff << \"  subgraph disasm {\\n\"\n"
"      buff << \"  node [shape=record fontname=\\\"courier\\\"];\\n\"\n"
"      buff << \"  edge [fontname=\\\"courier\\\" penwidth=3];\\n\"\n"
"      blocks.each do |block|\n"
"        disasm = disasm_block(cs, block, highlight)\n"
"\n"
"\n"/* convert newlines to breaks that graphviz understands */
,
#line 92 "yjit.rb"
"        disasm.gsub!(/\\n/, linebreak)\n"
"\n"
"\n"/* strip leading whitespace */
"        disasm.gsub!(/^\\s+/, '')\n"
"\n"
"        buff << \"b#{block.id} [label=<#{disasm}>];\\n\"\n"
"        buff << block.outgoing_ids.map { |id|\n"
"          next_block = blocks.bsearch { |nb| id <=> nb.id }\n"
"          if next_block.address == (block.address + block.code.length)\n"
"            \"b#{block.id} -> b#{id}[label=\\\"Fall\\\"];\"\n"
"          else\n"
"            \"b#{block.id} -> b#{id}[label=\\\"Jump\\\" style=dashed];\"\n"
"          end\n"
"        }.join(\"\\n\")\n"
"        buff << \"\\n\"\n"
"      end\n"
,
#line 108 "yjit.rb"
"      buff << \"  }\"\n"
"      buff << \"}\"\n"
"      buff\n"
"    end\n"
"\n"
"    def self.disasm_block(cs, block, highlight)\n"
"      comments = comments_for(block.address, block.address + block.code.length)\n"
"      comment_idx = 0\n"
"      str = +''\n"
"      cs.disasm(block.code, block.address).each do |i|\n"
"        while (comment = comments[comment_idx]) && comment.address <= i.address\n"
"          str << \"  ; #{highlight.call(comment.comment)}\\n\"\n"
"          comment_idx += 1\n"
"        end\n"
"\n"
"        str << sprintf(\n"
,
#line 124 "yjit.rb"
"          \"  %<address>08x:  %<instruction>s\\t%<details>s\\n\",\n"
"          address: i.address,\n"
"          instruction: i.mnemonic,\n"
"          details: i.op_str\n"
"        )\n"
"      end\n"
"      str\n"
"    end\n"
"  end\n"
"\n"
"\n"/* Return a hash for statistics generated for the --yjit-stats command line option. */
"\n"/* Return nil when option is not passed or unavailable. */
"  def self.runtime_stats\n"
"\n"/* defined in yjit_iface.c */
"    Primitive.get_yjit_stats\n"
"  end\n"
"\n"
"\n"/* Discard statistics collected for --yjit-stats. */
"  def self.reset_stats!\n"
"\n"/* defined in yjit_iface.c */
"    Primitive.reset_stats_bang\n"
"  end\n"
"\n"
"  def self.stats_enabled?\n"
"    Primitive.yjit_stats_enabled_p\n"
"  end\n"
"\n"
"  def self.enabled?\n"
"    Primitive.cexpr! 'RBOOL(rb_yjit_enabled_p())'\n"
"  end\n"
"\n"
"  def self.simulate_oom!\n"
,
#line 156 "yjit.rb"
"    Primitive.simulate_oom_bang\n"
"  end\n"
"\n"
"\n"/* Avoid calling a method here to not interfere with compilation tests */
"  if Primitive.yjit_stats_enabled_p\n"
"    at_exit { _print_stats }\n"
"  end\n"
"\n"
"  class << self\n"
"    private\n"
"\n"
"\n"/* Format and print out counters */
"    def _print_stats\n"
"      stats = runtime_stats\n"
"      return unless stats\n"
"\n"
"      $stderr.puts(\"***YJIT: Printing YJIT statistics on exit***\")\n"
"\n"
"      print_counters(stats, prefix: 'send_', prompt: 'method call exit reasons: ')\n"
"      print_counters(stats, prefix: 'invokesuper_', prompt: 'invokesuper exit reasons: ')\n"
,
#line 176 "yjit.rb"
"      print_counters(stats, prefix: 'leave_', prompt: 'leave exit reasons: ')\n"
"      print_counters(stats, prefix: 'gbpp_', prompt: 'getblockparamproxy exit reasons: ')\n"
"      print_counters(stats, prefix: 'getivar_', prompt: 'getinstancevariable exit reasons:')\n"
"      print_counters(stats, prefix: 'setivar_', prompt: 'setinstancevariable exit reasons:')\n"
"      print_counters(stats, prefix: 'oaref_', prompt: 'opt_aref exit reasons: ')\n"
,
#line 181 "yjit.rb"
"      print_counters(stats, prefix: 'expandarray_', prompt: 'expandarray exit reasons: ')\n"
"      print_counters(stats, prefix: 'opt_getinlinecache_', prompt: 'opt_getinlinecache exit reasons: ')\n"
"      print_counters(stats, prefix: 'invalidate_', prompt: 'invalidation reasons: ')\n"
"\n"
"      side_exits = total_exit_count(stats)\n"
"      total_exits = side_exits + stats[:leave_interp_return]\n"
"\n"
"\n"/* Number of instructions that finish executing in YJIT. */
"\n"/* See :count-placement: about the subtraction. */
"      retired_in_yjit = stats[:exec_instruction] - side_exits\n"
"\n"
"\n"/* Average length of instruction sequences executed by YJIT */
,
#line 193 "yjit.rb"
"      avg_len_in_yjit = retired_in_yjit.to_f / total_exits\n"
"\n"
"\n"/* Proportion of instructions that retire in YJIT */
"      total_insns_count = retired_in_yjit + stats[:vm_insns_count]\n"
"      yjit_ratio_pct = 100.0 * retired_in_yjit.to_f / total_insns_count\n"
"\n"
"\n"/* Number of failed compiler invocations */
"      compilation_failure = stats[:compilation_failure]\n"
"\n"
"      $stderr.puts \"bindings_allocations:  \" + (\"%10d\" % stats[:binding_allocations])\n"
"      $stderr.puts \"bindings_set:          \" + (\"%10d\" % stats[:binding_set])\n"
,
#line 204 "yjit.rb"
"      $stderr.puts \"compilation_failure:   \" + (\"%10d\" % compilation_failure) if compilation_failure != 0\n"
"      $stderr.puts \"compiled_iseq_count:   \" + (\"%10d\" % stats[:compiled_iseq_count])\n"
"      $stderr.puts \"compiled_block_count:  \" + (\"%10d\" % stats[:compiled_block_count])\n"
"      $stderr.puts \"invalidation_count:    \" + (\"%10d\" % stats[:invalidation_count])\n"
"      $stderr.puts \"constant_state_bumps:  \" + (\"%10d\" % stats[:constant_state_bumps])\n"
,
#line 209 "yjit.rb"
"      $stderr.puts \"inline_code_size:      \" + (\"%10d\" % stats[:inline_code_size])\n"
"      $stderr.puts \"outlined_code_size:    \" + (\"%10d\" % stats[:outlined_code_size])\n"
"\n"
"      $stderr.puts \"total_exit_count:      \" + (\"%10d\" % total_exits)\n"
"      $stderr.puts \"total_insns_count:     \" + (\"%10d\" % total_insns_count)\n"
"      $stderr.puts \"vm_insns_count:        \" + (\"%10d\" % stats[:vm_insns_count])\n"
"      $stderr.puts \"yjit_insns_count:      \" + (\"%10d\" % stats[:exec_instruction])\n"
,
#line 216 "yjit.rb"
"      $stderr.puts \"ratio_in_yjit:         \" + (\"%9.1f\" % yjit_ratio_pct) + \"%\"\n"
"      $stderr.puts \"avg_len_in_yjit:       \" + (\"%10.1f\" % avg_len_in_yjit)\n"
"\n"
"      print_sorted_exit_counts(stats, prefix: \"exit_\")\n"
"    end\n"
"\n"
"    def print_sorted_exit_counts(stats, prefix:, how_many: 20, left_pad: 4)\n"
"      exits = []\n"
"      stats.each do |k, v|\n"
"        if k.start_with?(prefix)\n"
"          exits.push [k.to_s.delete_prefix(prefix), v]\n"
"        end\n"
"      end\n"
"\n"
,
#line 230 "yjit.rb"
"      exits = exits.sort_by { |name, count| -count }[0...how_many]\n"
"      total_exits = total_exit_count(stats)\n"
"\n"
"      top_n_total = exits.map { |name, count| count }.sum\n"
"      top_n_exit_pct = 100.0 * top_n_total / total_exits\n"
"\n"
"      $stderr.puts \"Top-#{how_many} most frequent exit ops (#{\"%.1f\" % top_n_exit_pct}% of exits):\"\n"
"\n"
"      longest_insn_name_len = exits.map { |name, count| name.length }.max\n"
"      exits.each do |name, count|\n"
"        padding = longest_insn_name_len + left_pad\n"
,
#line 241 "yjit.rb"
"        padded_name = \"%#{padding}s\" % name\n"
"        padded_count = \"%10d\" % count\n"
"        percent = 100.0 * count / total_exits\n"
"        formatted_percent = \"%.1f\" % percent\n"
"        $stderr.puts(\"#{padded_name}: #{padded_count} (#{formatted_percent}%)\" )\n"
"      end\n"
"    end\n"
"\n"
"    def total_exit_count(stats, prefix: \"exit_\")\n"
"      total = 0\n"
"      stats.each do |k,v|\n"
"        total += v if k.start_with?(prefix)\n"
"      end\n"
"      total\n"
"    end\n"
"\n"
"    def print_counters(counters, prefix:, prompt:)\n"
,
#line 258 "yjit.rb"
"      $stderr.puts(prompt)\n"
"      counters = counters.filter { |key, _| key.start_with?(prefix) }\n"
"      counters.filter! { |_, value| value != 0 }\n"
"      counters.transform_keys! { |key| key.to_s.delete_prefix(prefix) }\n"
"\n"
"      if counters.empty?\n"
"        $stderr.puts(\"    (all relevant counters are zero)\")\n"
"        return\n"
"      end\n"
"\n"
"      counters = counters.to_a\n"
"      counters.sort_by! { |(_, counter_value)| counter_value }\n"
,
#line 270 "yjit.rb"
"      longest_name_length = counters.max_by { |(name, _)| name.length }.first.length\n"
"      total = counters.sum { |(_, counter_value)| counter_value }\n"
"\n"
"      counters.reverse_each do |(name, value)|\n"
"        percentage = value.fdiv(total) * 100\n"
"        $stderr.printf(\"    %*s %10d (%4.1f%%)\\n\", longest_name_length, name, value, percentage);\n"
"      end\n"
"    end\n"
"  end\n"
"end\n"
#line 4113 "miniprelude.c"
};

COMPILER_WARNING_POP

#define PRELUDE_NAME(n) rb_usascii_str_new_static(prelude_name##n, sizeof(prelude_name##n)-1)
#define PRELUDE_CODE(n) rb_utf8_str_new_static(prelude_code##n.L0, sizeof(prelude_code##n))

static rb_ast_t *
prelude_ast(VALUE name, VALUE code, int line)
{
    rb_ast_t *ast = rb_parser_compile_string_path(rb_parser_new(), name, code, line);
    if (!ast->body.root) {
	rb_ast_dispose(ast);
	rb_exc_raise(rb_errinfo());
    }
    return ast;
}

#define PRELUDE_AST(n, name_str, start_line) \
    (((sizeof(prelude_name##n) - prefix_len - 2) == namelen) && \
     (strncmp(prelude_name##n + prefix_len, feature_name, namelen) == 0) ? \
     prelude_ast((name_str) = PRELUDE_NAME(n), PRELUDE_CODE(n), start_line) : 0)

rb_ast_t *
rb_builtin_ast(const char *feature_name, VALUE *name_str)
{
    const size_t prefix_len = rb_strlen_lit("<internal:");
    size_t namelen = strlen(feature_name);
    rb_ast_t *ast = 0;

    if ((ast = PRELUDE_AST(0, *name_str, 20)) != 0) return ast;
    if ((ast = PRELUDE_AST(1, *name_str, 83)) != 0) return ast;
    if ((ast = PRELUDE_AST(2, *name_str, 11)) != 0) return ast;
    if ((ast = PRELUDE_AST(3, *name_str, 1)) != 0) return ast;
    if ((ast = PRELUDE_AST(4, *name_str, 1)) != 0) return ast;
    if ((ast = PRELUDE_AST(5, *name_str, 1)) != 0) return ast;
    if ((ast = PRELUDE_AST(6, *name_str, 1)) != 0) return ast;
    if ((ast = PRELUDE_AST(7, *name_str, 51)) != 0) return ast;
    if ((ast = PRELUDE_AST(8, *name_str, 4)) != 0) return ast;
    if ((ast = PRELUDE_AST(9, *name_str, 1)) != 0) return ast;
    if ((ast = PRELUDE_AST(10, *name_str, 1)) != 0) return ast;
    if ((ast = PRELUDE_AST(11, *name_str, 228)) != 0) return ast;
    if ((ast = PRELUDE_AST(12, *name_str, 213)) != 0) return ast;
    if ((ast = PRELUDE_AST(13, *name_str, 1)) != 0) return ast;
    if ((ast = PRELUDE_AST(14, *name_str, 1)) != 0) return ast;
    if ((ast = PRELUDE_AST(15, *name_str, 1)) != 0) return ast;
    if ((ast = PRELUDE_AST(16, *name_str, 11)) != 0) return ast;
    return ast;
}

void
Init_prelude(void)
{
}
