#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::ExternalProductCodeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ExternalProductCodeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::ExternalProductCodeType

=head1 DESCRIPTION

Indicates the type of external product ID being used to identify a
stock product.



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 ISBN

ExternalProductID.Value contains an ISBN value.
Required when you pass an ISBN as the external product ID.
(This value is also applicable to Half.com listings.)



=cut


use constant ISBN => scalar('ISBN');


=head2 UPC

ExternalProductID.Value contains a UPC value.
Required when you pass a UPC as the external product ID.
(This value is also applicable to Half.com listings.)



=cut


use constant UPC => scalar('UPC');


=head2 ProductID

ExternalProductID.Value contains an eBay catalog product ID.
Required when you pass an eBay product ID
as the external product ID.
Not applicable with GetSearchResults, GetSearchResultsExpress, or
GetProducts.



=cut


use constant ProductID => scalar('ProductID');


=head2 EAN

ExternalProductID.Value contains an EAN value.
Required when you pass an EAN as the external product ID.
Not applicable with GetSearchResultsExpress.



=cut


use constant EAN => scalar('EAN');


=head2 Keywords

ExternalProductID.Value contains a set of keywords that uniquely identify the product.
Only applicable when listing event ticket.
See the eBay Web Services guide for information about valid
ticket keywords for an external product ID.
Required when you pass a set of keywords as the external product ID.
Not applicable with GetSearchResults, GetSearchResultsExpress, or
GetProducts. With GetSearchResults, use TicketFinder instead.



=cut


use constant Keywords => scalar('Keywords');


=head2 MPN

Reserved for future use.



=cut


use constant MPN => scalar('MPN');


=head2 CustomCode

Reserved for internal or future use



=cut


use constant CustomCode => scalar('CustomCode');







1;   
