#!/usr/bin/perl

package eBay::API::XML::DataType::TaxTableType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. TaxTableType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::TaxTableType

=head1 DESCRIPTION

Sales tax details for zero or more jurisdictions (states,
provinces, etc).



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::TaxTableType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::TaxJurisdictionType;


my @gaProperties = ( [ 'TaxJurisdiction', 'ns:TaxJurisdictionType', '1'
	     ,'eBay::API::XML::DataType::TaxJurisdictionType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setTaxJurisdiction()

Sales tax details for zero or more jurisdictions (states,
provinces, etc).
For GetTaxTable, if DetailLevel is not specified, information is only
returned for the jurisdictions for which the user provided tax
information. If DetailLevel is ReturnAll, tax information
is returned for all possible jurisdictions, whether
specified by the user or not. ShippingIncludedInTax and
SalesTaxPercent are returned but are empty.

  Calls: SetTaxTable
  RequiredInput: Yes

#    Argument: reference to an array  
                      of 'ns:TaxJurisdictionType'

=cut

sub setTaxJurisdiction {
  my $self = shift;
  $self->{'TaxJurisdiction'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getTaxJurisdiction()

  Calls: GetTaxTable
  Returned: Always
  Details: DetailLevel: ReturnAll, none

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

  Calls: GetBidderList
         GetItemShipping
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: reference to an array  
                      of 'ns:TaxJurisdictionType'

=cut

sub getTaxJurisdiction {
  my $self = shift;
  return $self->_getDataTypeArray('TaxJurisdiction');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
