/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.scanner;

import java.awt.Component;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.util.logging.Logger;

public class PixelImage {
    protected static final float[] FILTER_FIR_COEFFS = new float[]{0.050017573f, -0.06430831f, -0.09003163f, 0.15005273f, 0.45015815f, 0.45015815f, 0.15005273f, -0.09003163f, -0.06430831f, 0.050017573f};
    public final int[] pixels;
    public final int width;
    public final int height;
    public final int npix;
    public final float aspectRatio;
    private static final Logger LOG = Logger.getLogger(PixelImage.class.getName());

    public PixelImage(int[] pixels, int width, int height) {
        this.pixels = pixels;
        this.width = width;
        this.height = height;
        this.npix = width * height;
        this.aspectRatio = (float)width / (float)height;
    }

    public PixelImage(Image image) {
        this.width = image.getWidth(null);
        this.height = image.getHeight(null);
        this.npix = this.width * this.height;
        this.aspectRatio = (float)this.width / (float)this.height;
        this.pixels = new int[this.npix];
        PixelGrabber grabber = new PixelGrabber(image, 0, 0, this.width, this.height, this.pixels, 0, this.width);
        try {
            grabber.grabPixels();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public Image rgbToImage(int[] rgbPixels, int width, int height, Component comp) {
        return comp.createImage(new MemoryImageSource(width, height, rgbPixels, 0, width));
    }

    public final int getPixelIndex(int x, int y) {
        return y * this.width + x;
    }

    public final int getPixel(int x, int y) {
        return this.pixels[y * this.width + x];
    }

    private static int rgbToGrayScale(int pix) {
        int r = pix >> 16 & 0xFF;
        int g = pix >> 8 & 0xFF;
        int b = pix & 0xFF;
        int Y = r * 306 + g * 601 + b * 117 >> 10;
        if (Y < 0) {
            Y = 0;
        } else if (Y > 255) {
            Y = 255;
        }
        return Y;
    }

    public final void toGrayScale(boolean normalize) {
        if (this.npix == 0) {
            return;
        }
        if (!normalize) {
            for (int i = 0; i < this.npix; ++i) {
                this.pixels[i] = PixelImage.rgbToGrayScale(this.pixels[i]);
            }
        } else {
            int pix;
            this.pixels[0] = pix = PixelImage.rgbToGrayScale(this.pixels[0]);
            int min = pix;
            int max = pix;
            for (int i = 1; i < this.npix; ++i) {
                this.pixels[i] = pix = PixelImage.rgbToGrayScale(this.pixels[i]);
                min = Math.min(min, pix);
                max = Math.max(max, pix);
            }
            int range = max - min;
            if (range < 1) {
                for (int i = 0; i < this.npix; ++i) {
                    this.pixels[i] = 255;
                }
            } else {
                for (int i = 0; i < this.npix; ++i) {
                    this.pixels[i] = Math.min(255, Math.max(0, (this.pixels[i] - min) * 255 / range));
                }
            }
        }
    }

    public final int[] grayScaleToRGB(int[] pixels) {
        int[] newPixels = new int[pixels.length];
        for (int i = 0; i < newPixels.length; ++i) {
            int pix = pixels[i] & 0xFF;
            newPixels[i] = pix | pix << 8 | pix << 16 | 0xFF000000;
        }
        return newPixels;
    }

    public final void filter() {
        this.filter(this.pixels, this.width, this.height);
    }

    public final void filter(int[] pixels, int width, int height) {
        int j;
        int j2;
        float c;
        int i;
        float[] firSamples = new float[FILTER_FIR_COEFFS.length];
        int lastPos = firSamples.length - 1;
        for (int y = 0; y < height; ++y) {
            for (i = 0; i < firSamples.length; ++i) {
                firSamples[i] = 255.0f;
            }
            int outX = -(firSamples.length / 2);
            int x = 0;
            while (x < width) {
                c = 0.0f;
                for (j2 = 0; j2 < lastPos; ++j2) {
                    c += firSamples[j2] * FILTER_FIR_COEFFS[j2];
                    firSamples[j2] = firSamples[j2 + 1];
                }
                c += firSamples[lastPos] * FILTER_FIR_COEFFS[lastPos];
                firSamples[lastPos] = this.getPixel(x, y);
                if (c < 0.0f) {
                    c = 0.0f;
                } else if (c > 255.0f) {
                    c = 255.0f;
                }
                if (outX >= 0) {
                    pixels[this.getPixelIndex((int)outX, (int)y)] = (int)c;
                }
                ++x;
                ++outX;
            }
            while (outX < width) {
                c = 0.0f;
                for (j = 0; j < lastPos; ++j) {
                    c += firSamples[j] * FILTER_FIR_COEFFS[j];
                    firSamples[j] = firSamples[j + 1];
                }
                c += firSamples[lastPos] * FILTER_FIR_COEFFS[lastPos];
                firSamples[lastPos] = 255.0f;
                if (c < 0.0f) {
                    c = 0.0f;
                } else if (c > 255.0f) {
                    c = 255.0f;
                }
                pixels[this.getPixelIndex((int)outX, (int)y)] = (int)c;
                ++outX;
            }
        }
        for (int x = 0; x < width; ++x) {
            for (i = 0; i < firSamples.length; ++i) {
                firSamples[i] = 255.0f;
            }
            int outY = -(firSamples.length / 2);
            int y = 0;
            while (y < height) {
                c = 0.0f;
                for (j2 = 0; j2 < lastPos; ++j2) {
                    c += firSamples[j2] * FILTER_FIR_COEFFS[j2];
                    firSamples[j2] = firSamples[j2 + 1];
                }
                c += firSamples[lastPos] * FILTER_FIR_COEFFS[lastPos];
                firSamples[lastPos] = this.getPixel(x, y);
                if (c < 0.0f) {
                    c = 0.0f;
                } else if (c > 255.0f) {
                    c = 255.0f;
                }
                if (outY >= 0) {
                    pixels[this.getPixelIndex((int)x, (int)outY)] = (int)c;
                }
                ++y;
                ++outY;
            }
            while (outY < height) {
                c = 0.0f;
                for (j = 0; j < lastPos; ++j) {
                    c += firSamples[j] * FILTER_FIR_COEFFS[j];
                    firSamples[j] = firSamples[j + 1];
                }
                c += firSamples[lastPos] * FILTER_FIR_COEFFS[lastPos];
                firSamples[lastPos] = 255.0f;
                if (c < 0.0f) {
                    c = 0.0f;
                } else if (c > 255.0f) {
                    c = 255.0f;
                }
                pixels[this.getPixelIndex((int)x, (int)outY)] = (int)c;
                ++outY;
            }
        }
    }
}

