use Test::More;
use IO::All;
use File::Temp 'tempfile';
use Data::Dumper;

use_ok('Parse::SAMGov');

my $p = new_ok('Parse::SAMGov');
can_ok($p, 'parse_file');

subtest 'Parse Entity file' => sub {
    my $content = <<'ENTITY';
BOF PUBLIC V2 00000000 20231105 0765210 0007556
CFKVXZJ329K7|||54VJ4||A|Z2|20080713|20240224|20230306|20230301|BLACKHORSE, A PARSONS COMPANY||CORPORATE OFFICE||13461 SUNRISE VALLEY DR|BLDG 8|HERNDON|VA|20171|3283|USA|11||20080501|1231|http://www.blackhorsesolutions.com|2L|DE|USA|0001|2X|541990|0016|541330E~541513N~541512N~541519E~541611N~541618N~541690N~541715E~541930N~541990N~611110N~611420N~611430N~611699N~611710N~928110 |0006|AM15~R408~R423~U006~U012~U099|Y||13461 SUNRISE VALLEY DRIVE|SUITE 400|HERNDON|20171||USA|VA|GLORIA||ZAPATA||100 WEST WALNUT STREET||PASADENA|91124|0001|USA|CA|STEPHEN||FINNEY|SVP BUSINESS DEVELOPMENT|13461 SUNRISE VALLEY DRIVE|SUITE 400|HERNDON|20171|3242|USA|VA|NEIL||SIMS|VP, BUSINESS DEVELOPMENT|13461 SUNRISE VALLEY DRIVE|SUITE 400|HERNDON|20171|3242|USA|VA||||||||||||JANINE||GOOD|CONTRACTS|13461 SUNRISE VALLEY DRIVE|SUITE 400|HERNDON|20171|3242|USA|VA|TIM||JONES|CFO|13461 SUNRISE VALLEY DRIVE|SUITE 400|HERNDON|20171|3242|USA|VA|0003|541330NNNN~541519NN  ~541715NNNN|N||0000|||0000||E&Y||||||||||||||||||||!end
WZZSXMA52K46|||6RNY9||A|Z2|20120605|20241009|20231011|20231011|SEALING TECHNOLOGIES, LLC||||6750 ALEXANDER BELL DR STE 200||COLUMBIA|MD|21046|2199|USA|03||20120528|1231|http://www.sealingtech.com|2L|MD|USA|0002|2X~LJ|541513|0015|334111N~334112N~513210N~541330E~541380N~541513N~541512N~541513N~541519E~541618N~541690N~541715E~541990N~611420N~811210N|0006|5810~7B22~7J20~7K20~DJ10~H263|Y||6750 ALEXANDER BELL DR STE 200||COLUMBIA|21046|2199|USA|MD|EDWARD|L|SEALING|PRESIDENT & CEO|7134 COLUMBIA GATEWAY DRIVE|SUITE 160|COLUMBIA|21046||USA|MD|JENNIFER||BREEN||7134 COLUMBIA GATEWAY DRIVE|SUITE 160|COLUMBIA|21046||USA|MD|||||||||||||||||||||||DANIEL|G|ZICK|CFO|7134 COLUMBIA GATEWAY DRIVE|SUITE 160|COLUMBIA|21046||USA|MD|EDWARD|L|SEALING|PRESIDENT & CEO|7134 COLUMBIA GATEWAY DRIVE|SUITE 160|COLUMBIA|21046||USA|MD|0003|541330NNNN~541519NN  ~541715NNNN|N||0000|||0000||E&Y||||||||||||||||||||!end
EOF PUBLIC V2 00000000 20231105 0765210 0007556
ENTITY
    my ($ftmp, $filename) = tempfile();
    $content > io($filename);
    my $entities = $p->parse_file($filename);
    isnt($entities, undef, 'Entities were parsed');
    isa_ok($entities, 'ARRAY');
    cmp_ok(scalar(@$entities), '>', 0, 'Parsed entities >= 1');
    foreach my $e (@$entities) {
        isa_ok($e, 'Parse::SAMGov::Entity');
        note $e;
    }
    my $entity_541513 = $p->parse_file($filename, sub {
            return 1 if (ref $_[0]->NAICS->{541513} eq 'HASH' and $_[0]->NAICS->{541513}->{is_primary});
            return undef;
        });
    isa_ok($entity_541513, 'ARRAY');
    is(scalar(@$entity_541513), 1, 'Result has 1 element');
    is(ref $entity_541513->[0]->NAICS->{541513}, 'HASH');
    unlink $filename;
    done_testing();
};

done_testing();
__END__
### COPYRIGHT: Selective Intellect LLC.
### AUTHOR: Vikas N Kumar <vikas@cpan.org>
