use Test::More;
use Data::Dump qw/pp ddx/;
use Scalar::Util qw/blessed reftype/;

use lib '../../lib';


use DBIx::HoldMyPlace;


is( \&hmp, \&DBIx::HoldMyPlace::hmp, "hmp() importet by default" );

my $first = "Woody";
my $last  = "Woodpecker";

my $hmp = hmp { "First = $first and Last = $last" };

diag  '$hmp: ',  pp $hmp;

($first, $last) = ("?","?");
my $exp_ph = "First = $first and Last = $last" ;


diag  '$hmp: ',  pp $hmp;


is ( reftype $hmp, 'ARRAY', "array returned");
is ( $hmp->[0], $exp_ph, "placeholders inserted");
is ( reftype $hmp->[1], 'ARRAY');


($first, $last) = ("FIRST","LAST");

diag  '$hmp: ',  pp $hmp;

ok ( $hmp->[1][0]{ref} == \$first, "1. scalar extracted" );
ok ( $hmp->[1][0]{val} == '?' ,"1. placeholder inserted");

ok ( $hmp->[1][1]{ref} == \$last ,"2. scalar extracted");
ok ( $hmp->[1][1]{val} == '?' , "2. placeholder inserted");




  



done_testing();
