#!/usr/bin/perl -w
use strict;
use Test;

BEGIN { plan tests => 6 }

use Attribute::Deprecated;

my $n = 0;

sub foo : Deprecated {
    ++$n;
}

# the warnings should be generated by the first call from each line, but not by
# subsequent calls:

our $w = '';
local $SIG{__WARN__} = sub { $w = shift };

for (0,1,1) {
    $w = '';
    foo();
    ok($_?!$w:$w);
}

# this is a different line, so we should get another warning
for (0,1) {
    $w = '';
    foo();
    ok($_?!$w:$w);
}

ok($n, 5);
