package config;
use 5.008001;
use strict;
use warnings;

our $VERSION = "1.4.2";

use constant {};

our %_CONFIG;

# Конфигурирует модуль. Должен использоваться в .config.pm
sub config($%) {
	my $pkg = shift;
	$_CONFIG{$pkg} = {@_};
	return;
}

# Конфигурирует модуль. Должен использоваться в .config.pm
#@deprecated
sub config_module($$) {
	my ($pkg, $constants) = @_;
	$_CONFIG{$pkg} = $constants;
	return;
}

# Проект всегда старует от корня своей директории, где и должен лежать модуль
require "./.config.pm" if -e "./.config.pm";

# Импортирует конфиг-константы
sub import {
	my ($cls, $name, $value) = @_;
	return if !defined $name;
	my $hash = ref $name eq "HASH"? $name: +{($name => $value)};
	
	my $pkg = caller;

	if(!$^V or $^V lt 5.22.0) {
		no strict 'refs';
		for(keys %$hash) {
			my $val = exists $_CONFIG{$pkg} && exists $_CONFIG{$pkg}{$_}? $_CONFIG{$pkg}{$_}: $hash->{$_};
			*{"${pkg}::$_"} = sub {$val};
		}
	} else {
		constant->import("${pkg}::$_", exists $_CONFIG{$pkg} && exists $_CONFIG{$pkg}{$_}? $_CONFIG{$pkg}{$_}: $hash->{$_}) for keys %$hash;
	}

}

1;

__END__

=encoding utf-8

=head1 NAME

config - Perl module constant configurator

=head1 VERSION

1.4.2

=head1 SYNOPSIS

	use config MY => 123;
	MY # -> 123

=head1 DESCRIPTION

See C<config::Manual>. Since the C<config.pm> file is overlapped on metacpan.org by the CONFIG.pm file (yep - metacpan is case-insensitive for some reason), I had to get out like this)

=head1 AUTHOR

Yaroslav O. Kosmina L<mailto:dart@cpan.org>

=head1 LICENSE

⚖ B<Perl5>

=head1 COPYRIGHT

The config module is copyright (c) 2023 Yaroslav O. Kosmina. Rusland. All rights reserved.
