/* { dg-options "-std=gnu99" } */

/* The preferred exponent of the result of a conversion from an
   integral type to a decimal float type is zero.  A conversion at
   either compile time or runtime should not change the number of
   trailing zeroes.  */

#include "dfp-dbg.h"

#define PASTE2(A,B) A ## B
#define PASTE(A,B) PASTE2(A,B)

#define TESTVAL_NEG(VAL,SUF,SIZE)					\
  x = PASTE(PASTE(VAL,.),SUF);						\
  si = VAL;								\
  sll = PASTE(VAL,LL);							\
  a = si;								\
  b = sll;								\
  c = VAL;								\
  d = PASTE(VAL,LL);							\
  if ((__builtin_memcmp ((void *)&x, (void *)&a, SIZE) != 0)		\
      || (__builtin_memcmp ((void *)&x, (void *)&b,SIZE) != 0)		\
      || (__builtin_memcmp ((void *)&x, (void *)&c,SIZE) != 0)		\
      || (__builtin_memcmp ((void *)&x, (void *)&d,SIZE) != 0))		\
    FAILURE

#define TESTVAL_NEG_BIG(VAL,SUF,SIZE)					\
  x = PASTE(PASTE(VAL,.),SUF);						\
  sll = PASTE(VAL,LL);							\
  a = sll;								\
  b = PASTE(VAL,LL);							\
  if ((__builtin_memcmp ((void *)&x, (void *)&a, SIZE) != 0)		\
      || (__builtin_memcmp ((void *)&x, (void *)&b,SIZE) != 0))		\
    FAILURE

#define TESTVAL_NONNEG(VAL,SUF,SIZE)					\
  x = PASTE(PASTE(VAL,.),SUF);						\
  si = VAL;								\
  ui = VAL;								\
  sll = PASTE(VAL,LL);							\
  ull = PASTE(VAL,ULL);							\
  a = si;								\
  b = sll;								\
  c = ui;								\
  d = ull;								\
  e = VAL;								\
  f = VAL;								\
  g = PASTE(VAL,LL);							\
  h = PASTE(VAL,ULL);							\
  if ((__builtin_memcmp ((void *)&x, (void *)&a, SIZE) != 0)		\
      || (__builtin_memcmp ((void *)&x, (void *)&b,SIZE) != 0)		\
      || (__builtin_memcmp ((void *)&x, (void *)&c,SIZE) != 0)		\
      || (__builtin_memcmp ((void *)&x, (void *)&d,SIZE) != 0)		\
      || (__builtin_memcmp ((void *)&x, (void *)&e,SIZE) != 0)		\
      || (__builtin_memcmp ((void *)&x, (void *)&f,SIZE) != 0)		\
      || (__builtin_memcmp ((void *)&x, (void *)&g,SIZE) != 0)		\
      || (__builtin_memcmp ((void *)&x, (void *)&h,SIZE) != 0))		\
    FAILURE

#define TESTVAL_NONNEG_BIG(VAL,SUF,SIZE)				\
  x = PASTE(PASTE(VAL,.),SUF);						\
  sll = PASTE(VAL,LL);							\
  ull = PASTE(VAL,ULL);							\
  b = sll;								\
  d = ull;								\
  f = PASTE(VAL,LL);							\
  g = PASTE(VAL,ULL);							\
  if ((__builtin_memcmp ((void *)&x, (void *)&b, SIZE) != 0)		\
      || (__builtin_memcmp ((void *)&d, (void *)&d,SIZE) != 0)		\
      || (__builtin_memcmp ((void *)&f, (void *)&d,SIZE) != 0)		\
      || (__builtin_memcmp ((void *)&g, (void *)&d,SIZE) != 0))		\
    FAILURE

#undef SUFFIX
#define SUFFIX DF
#undef TYPE
#define TYPE _Decimal32
  
void
zeroes_32 (void)
{
  volatile TYPE x, a, b, c, d, e, f, g, h;
  volatile int si;
  volatile unsigned int ui;
  volatile long long sll;
  volatile unsigned long long ull;

  TESTVAL_NONNEG (0, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (1, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (5, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (9, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (10, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (50, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (90, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (100, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (500, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (900, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (1000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (5000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (9000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (10000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (50000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (90000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (100000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (500000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (900000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (1000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (5000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (9000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (10000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (50000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (90000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (100000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (500000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (900000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (1000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (5000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (9000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (10000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (50000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (90000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (100000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (500000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (900000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (1000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (5000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (9000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (10000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (50000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (90000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (100000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (500000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (900000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (1000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (5000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (9000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (10000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (50000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (90000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (100000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (500000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (900000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (1000000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (5000000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (9000000000000000000, SUFFIX, sizeof (TYPE));

  TESTVAL_NEG (0, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-1, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-5, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-9, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-10, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-50, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-90, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-100, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-500, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-900, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-1000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-5000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-9000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-10000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-50000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-90000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-100000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-500000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-900000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-1000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-5000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-9000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-10000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-50000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-90000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-100000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-500000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-900000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-1000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-5000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-9000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-10000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-50000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-90000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-100000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-500000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-900000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-1000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-5000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-9000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-10000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-50000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-90000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-100000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-500000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-900000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-1000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-5000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-9000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-10000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-50000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-90000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-100000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-500000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-900000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-1000000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-5000000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-9000000000000000000, SUFFIX, sizeof (TYPE));
}
  
void
round_32 (void)
{
  volatile TYPE x, a, b, c, d, e, f, g, h;
  volatile int si;
  volatile unsigned int ui;
  volatile long long sll;
  volatile unsigned long long ull;

  TESTVAL_NONNEG (10000049, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (10000050, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (10000051, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (10000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (10000001, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (10000002, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (10000003, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (10000004, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (100000049, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (100000051, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (10000006, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (10000007, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (10000008, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (10000009, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (10000010, SUFFIX, sizeof (TYPE));

  TESTVAL_NEG (-10000049, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-10000050, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-10000051, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-10000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-10000001, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-10000002, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-10000003, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-10000004, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-100000049, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-100000051, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-10000006, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-10000007, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-10000008, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-10000009, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-10000010, SUFFIX, sizeof (TYPE));
}

#undef SUFFIX
#define SUFFIX DD
#undef TYPE
#define TYPE _Decimal64
  
void
zeroes_64 (void)
{
  volatile TYPE x, a, b, c, d, e, f, g, h;
  volatile int si;
  volatile unsigned int ui;
  volatile long long sll;
  volatile unsigned long long ull;

  TESTVAL_NONNEG (0, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (1, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (5, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (9, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (10, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (50, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (90, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (100, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (500, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (900, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (1000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (5000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (9000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (10000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (50000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (90000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (100000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (500000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (900000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (1000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (5000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (9000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (10000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (50000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (90000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (100000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (500000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (900000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (1000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (5000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (9000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (10000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (50000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (90000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (100000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (500000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (900000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (1000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (5000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (9000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (10000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (50000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (90000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (100000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (500000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (900000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (1000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (5000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (9000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (10000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (50000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (90000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (100000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (500000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (900000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (1000000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (5000000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (9000000000000000000, SUFFIX, sizeof (TYPE));

  TESTVAL_NEG (0, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-1, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-5, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-9, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-10, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-50, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-90, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-100, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-500, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-900, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-1000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-5000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-9000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-10000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-50000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-90000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-100000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-500000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-900000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-1000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-5000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-9000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-10000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-50000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-90000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-100000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-500000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-900000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-1000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-5000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-9000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-10000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-50000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-90000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-100000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-500000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-900000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-1000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-5000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-9000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-10000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-50000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-90000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-100000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-500000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-900000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-1000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-5000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-9000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-10000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-50000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-90000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-100000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-500000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-900000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-1000000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-5000000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-9000000000000000000, SUFFIX, sizeof (TYPE));
}
  
void
round_64 (void)
{
  volatile TYPE x, a, b, c, d, e, f, g, h;
  volatile int si;
  volatile unsigned int ui;
  volatile long long sll;
  volatile unsigned long long ull;

  TESTVAL_NONNEG_BIG (10000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (10000000000000001, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (10000000000000002, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (10000000000000003, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (10000000000000004, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (100000000000000049, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (100000000000000051, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (10000000000000006, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (10000000000000007, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (10000000000000008, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (10000000000000009, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (10000000000000010, SUFFIX, sizeof (TYPE));

  TESTVAL_NEG_BIG (-10000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-10000000000000001, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-10000000000000002, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-10000000000000003, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-10000000000000004, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-100000000000000049, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-100000000000000051, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-10000000000000006, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-10000000000000007, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-10000000000000008, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-10000000000000009, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-10000000000000010, SUFFIX, sizeof (TYPE));
}

#undef SUFFIX
#define SUFFIX DL
#undef TYPE
#define TYPE _Decimal128
  
void
zeroes_128 (void)
{
  volatile TYPE x, a, b, c, d, e, f, g, h;
  volatile int si;
  volatile unsigned int ui;
  volatile long long sll;
  volatile unsigned long long ull;

  TESTVAL_NONNEG (0, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (1, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (5, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (9, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (10, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (50, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (90, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (100, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (500, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (900, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (1000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (5000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (9000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (10000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (50000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (90000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (100000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (500000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (900000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (1000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (5000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (9000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (10000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (50000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (90000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (100000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (500000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (900000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG (1000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (5000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (9000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (10000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (50000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (90000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (100000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (500000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (900000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (1000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (5000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (9000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (10000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (50000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (90000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (100000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (500000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (900000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (1000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (5000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (9000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (10000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (50000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (90000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (100000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (500000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (900000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (1000000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (5000000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NONNEG_BIG (9000000000000000000, SUFFIX, sizeof (TYPE));

  TESTVAL_NEG (0, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-1, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-5, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-9, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-10, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-50, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-90, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-100, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-500, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-900, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-1000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-5000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-9000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-10000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-50000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-90000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-100000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-500000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-900000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-1000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-5000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-9000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-10000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-50000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-90000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-100000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-500000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-900000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG (-1000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-5000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-9000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-10000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-50000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-90000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-100000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-500000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-900000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-1000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-5000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-9000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-10000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-50000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-90000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-100000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-500000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-900000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-1000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-5000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-9000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-10000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-50000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-90000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-100000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-500000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-900000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-1000000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-5000000000000000000, SUFFIX, sizeof (TYPE));
  TESTVAL_NEG_BIG (-9000000000000000000, SUFFIX, sizeof (TYPE));
}


int
main ()
{
  zeroes_32 ();
  zeroes_64 ();
  zeroes_128 ();
  round_32 ();
  round_64 ();

  FINISH
}
