/* { dg-do run } */
/* { dg-require-effective-target sse4 } */
/* { dg-options "-O2 -msse4.2" } */

#include "sse4_2-check.h"
#include "sse4_2-pcmpstr.h"

#define NUM 1024

#define IMM_VAL0 \
  (_SIDD_SBYTE_OPS | _SIDD_CMP_RANGES | _SIDD_MASKED_POSITIVE_POLARITY)
#define IMM_VAL1 \
  (_SIDD_UBYTE_OPS | _SIDD_CMP_EQUAL_EACH | _SIDD_NEGATIVE_POLARITY \
   | _SIDD_BIT_MASK)
#define IMM_VAL2 \
  (_SIDD_UWORD_OPS | _SIDD_CMP_EQUAL_ANY | _SIDD_MASKED_NEGATIVE_POLARITY)
#define IMM_VAL3 \
  (_SIDD_SWORD_OPS | _SIDD_CMP_EQUAL_ORDERED \
   | _SIDD_POSITIVE_POLARITY | _SIDD_UNIT_MASK)

static void
sse4_2_test (void)
{
  union
    {
      __m128i x[NUM];
      char c[NUM *16];
    } src1, src2;
  __m128i res, correct;
  int correct_flags;
  int flags, cf, zf, sf, of, af;
  int i;

  for (i = 0; i < NUM *16; i++)
    {
      src1.c[i] = rand ();
      src2.c[i] = rand ();
    }

  for (i = 0; i < NUM; i++)
    {
      switch ((rand () % 4))
	{
	case 0:
	  res = _mm_cmpistrm (src1.x[i], src2.x[i], IMM_VAL0);
	  cf = _mm_cmpistrc (src1.x[i], src2.x[i], IMM_VAL0);
	  zf = _mm_cmpistrz (src1.x[i], src2.x[i], IMM_VAL0);
	  sf = _mm_cmpistrs (src1.x[i], src2.x[i], IMM_VAL0);
	  of = _mm_cmpistro (src1.x[i], src2.x[i], IMM_VAL0);
	  af = _mm_cmpistra (src1.x[i], src2.x[i], IMM_VAL0);
	  correct = cmp_im (&src1.x[i], &src2.x[i], IMM_VAL0,
			    &correct_flags);
	  break;

	case 1:
	  res = _mm_cmpistrm (src1.x[i], src2.x[i], IMM_VAL1);
	  cf = _mm_cmpistrc (src1.x[i], src2.x[i], IMM_VAL1);
	  zf = _mm_cmpistrz (src1.x[i], src2.x[i], IMM_VAL1);
	  sf = _mm_cmpistrs (src1.x[i], src2.x[i], IMM_VAL1);
	  of = _mm_cmpistro (src1.x[i], src2.x[i], IMM_VAL1);
	  af = _mm_cmpistra (src1.x[i], src2.x[i], IMM_VAL1);
	  correct = cmp_im (&src1.x[i], &src2.x[i], IMM_VAL1,
			    &correct_flags);
	  break;

	case 2:
	  res = _mm_cmpistrm (src1.x[i], src2.x[i], IMM_VAL2);
	  cf = _mm_cmpistrc (src1.x[i], src2.x[i], IMM_VAL2);
	  zf = _mm_cmpistrz (src1.x[i], src2.x[i], IMM_VAL2);
	  sf = _mm_cmpistrs (src1.x[i], src2.x[i], IMM_VAL2);
	  of = _mm_cmpistro (src1.x[i], src2.x[i], IMM_VAL2);
	  af = _mm_cmpistra (src1.x[i], src2.x[i], IMM_VAL2);
	  correct = cmp_im (&src1.x[i], &src2.x[i], IMM_VAL2,
			    &correct_flags);
	  break;

	default:	
	  res = _mm_cmpistrm (src1.x[i], src2.x[i], IMM_VAL3);
	  cf = _mm_cmpistrc (src1.x[i], src2.x[i], IMM_VAL3);
	  zf = _mm_cmpistrz (src1.x[i], src2.x[i], IMM_VAL3);
	  sf = _mm_cmpistrs (src1.x[i], src2.x[i], IMM_VAL3);
	  of = _mm_cmpistro (src1.x[i], src2.x[i], IMM_VAL3);
	  af = _mm_cmpistra (src1.x[i], src2.x[i], IMM_VAL3);
	  correct = cmp_im (&src1.x[i], &src2.x[i], IMM_VAL3,
			    &correct_flags);
	  break;
	}
      
      if (memcmp (&correct, &res, sizeof (res)))
	abort ();

      flags = 0;
      if (cf)
	flags |= CFLAG;
      if (zf)
	flags |= ZFLAG;
      if (sf)
	flags |= SFLAG;
      if (of)
	flags |= OFLAG;
      
      if (flags != correct_flags
	  || (af && (cf || zf))
	  || (!af && !(cf || zf)))
	abort ();
    }
}
