// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license
//-----------------------------------------------------------------------------
// CodeWarrior-specific definitions
//-----------------------------------------------------------------------------

#ifndef POOMA_PREFIX_H
#define POOMA_PREFIX_H

// This symbol is set here to indicate that Pooma/Configuration.h
// should NOT try to include PoomaConfiguration.h (the header generated
// by configure).  Instead, we just provide values for all the defines
// in this file.

#define POOMA_NO_POOMA_CONFIGURATION_FILE

// POOMA configuration settings, that would otherwise be obtained from
// PoomaConfiguration.h

#define POOMA_YES                           1
#define POOMA_NO                            0
#define POOMA_TRUE                          true
#define POOMA_FALSE                         false
#define POOMA_SUITE                         "Metrowerks"
#define POOMA_ARCH_TYPE                     "Metrowerks"
#define POOMA_COMP_TYPE                     "Metrowerks"
#define POOMA_MAJOR_VERSION                 2
#define POOMA_MINOR_VERSION                 3
#define POOMA_PATCH_LEVEL                   0
#define POOMA_VERSION_STRING                "POOMA 2.3.0"
#define POOMA_VERSION_NUM_STRING            "2.3.0"
#define POOMA_CONFIGURE_ARGS                ""
#define POOMA_BUILD_DATE                    "Fri Jul 14 10:00:00 MDT 2000"
#define POOMA_BUILD_USER                    "swhaney"
#define POOMA_BUILD_HOST                    "scott-mac"
#define POOMA_PREINSTANTIATE                POOMA_NO
#define POOMA_PRINTDEBUG                    POOMA_NO
#define POOMA_NO_TEMPLATED_COMPLEX          POOMA_NO
#define POOMA_NO_STD_COMPLEX                POOMA_NO
#define POOMA_NONSTANDARD_ITERATOR          POOMA_NO
#define POOMA_THREADS                       POOMA_NO
#define POOMA_SMARTS_SCHEDULER_SERIALASYNC  POOMA_NO
#define POOMA_SCHEDULER_NAME                "stub scheduler"
#define POOMA_REORDER_ITERATES              POOMA_NO
#define POOMA_PROFILE                       POOMA_NO
#define POOMA_INSURE                        POOMA_NO
#define POOMA_LUX                           POOMA_NO
#define POOMA_EXCEPTIONS                    __option(exceptions)
#define POOMA_NO_STRINGSTREAM               POOMA_NO
#define POOMA_MISSING_IOMANIPS              POOMA_NO
#define POOMA_NO_TEMPLATE_FRIENDS           POOMA_YES
#define POOMA_NO_RESTRICT                   POOMA_YES
#define POOMA_NO_OSTREAM_ITERATOR_1ARG      POOMA_YES
#define POOMA_NO_PLACEMENT_DELETE           POOMA_YES
#define POOMA_SMALL_DIM_SPECIALIZATIONS     POOMA_NO
#define POOMA_NO_DEPENDENT_TEMPLATE_ARGS    POOMA_YES
#define POOMA_BRAIN_DAMAGED_MICROSOFT_LIB   POOMA_NO
#define POOMA_PAWS                          POOMA_NO
#define POOMA_HDF5                          POOMA_NO
#define POOMA_HAS_O_BINARY_OPEN_MODE        POOMA_YES
#define POOMA_NO_STD_IOSBASE                POOMA_NO
#define POOMA_INC_SYS_STAT_H_FOR_FILE_MODES POOMA_NO
#define POOMA_CHEETAH                       POOMA_NO

#ifndef POOMA_DEFAULT_FLOAT_TYPE
#define POOMA_DEFAULT_FLOAT_TYPE            double
#endif

#ifndef POOMA_DEFAULT_ELEMENT_TYPE
#define POOMA_DEFAULT_ELEMENT_TYPE          POOMA_DEFAULT_FLOAT_TYPE
#endif

#ifndef POOMA_DEFAULT_POSITION_TYPE
#define POOMA_DEFAULT_POSITION_TYPE         POOMA_DEFAULT_FLOAT_TYPE
#endif

#ifndef POOMA_DEFAULT_ENGINE_TYPE
#define POOMA_DEFAULT_ENGINE_TYPE           Brick
#endif

#ifndef POOMA_BOUNDS_CHECK
#define POOMA_BOUNDS_CHECK                  POOMA_NO
#endif

#ifndef POOMA_BOUNDS_CHECK_DEFAULT
#define POOMA_BOUNDS_CHECK_DEFAULT	    POOMA_FALSE
#endif

#ifndef POOMA_DEFAULT_SMARTS_HARDINIT
#define POOMA_DEFAULT_SMARTS_HARDINIT       POOMA_FALSE
#endif

#ifndef POOMA_DEFAULT_SMARTS_HARDRUN
#define POOMA_DEFAULT_SMARTS_HARDRUN        POOMA_FALSE
#endif

#ifndef POOMA_DEFAULT_SMARTS_LOCKTHREADS
#define POOMA_DEFAULT_SMARTS_LOCKTHREADS    POOMA_FALSE
#endif

#ifndef POOMA_DEFAULT_BLOCKING_EXPRESSIONS
#define POOMA_DEFAULT_BLOCKING_EXPRESSIONS  POOMA_TRUE
#endif

// When debugging, we want POOMA_PURIFY and PETE_PURIFY on so we don't have
// to step through assembly language. When optimizing, we want to turn off
// assertions.

// Deciding if we are optimizing is a little tricky with CW. Use the
// "Don't Inline" option as a proxy.

#if __option(dont_inline)

// Debug

#ifndef POOMA_PURIFY
#define POOMA_PURIFY                        POOMA_YES
#endif

#ifndef PETE_PURIFY
#define PETE_PURIFY                         POOMA_YES
#endif

#else

// Optimize

#define NOPAssert
#define NOCTAssert

#endif


///////////////////////////////////////////////////////////////////////////
//
// COMMAND LINE HANDLING
//
///////////////////////////////////////////////////////////////////////////

#define POOMA_ARCH_SPECIFIC_FUNCTIONS POOMA_YES
#define POOMA_MAKE_CCOMMAND_CALL POOMA_NO
#define POOMA_MAKE_PROFILER_CALLS POOMA_NO
#define POOMA_MAKE_MPW_CURSOR_CALLS POOMA_NO

#if defined(macintosh)
#if __option(mpwc_newline)
#include <CursorCtl.h>
#undef POOMA_MAKE_MPW_CURSOR_CALLS
#define POOMA_MAKE_MPW_CURSOR_CALLS POOMA_YES
#else
#include <console.h>
#undef POOMA_MAKE_CCOMMAND_CALL
#define POOMA_MAKE_CCOMMAND_CALL POOMA_YES
#endif // __option(mpwc_newline)
#endif // defined(macintosh)

#if __profile__
#include <profiler.h>
#undef POOMA_MAKE_PROFILER_CALLS
#define POOMA_MAKE_PROFILER_CALLS POOMA_YES
#endif // __profile__

#pragma dont_inline off
#pragma warn_unusedarg off

namespace Pooma { namespace Arch {
  
  inline void dawdle()
  {
#if POOMA_MAKE_MPW_CURSOR_CALLS
    SpinCursor(1);
#endif // POOMA_MAKE_MPW_CURSOR_CALLS
  }
  
  inline void getCommandLineArguments(int &argc, char** &argv)
  {
#if POOMA_MAKE_CCOMMAND_CALL
    argc = ccommand(&argv);
#endif // POOMA_MAKE_CCOMMAND_CALL
  }

  inline void initialize()
  {
#if POOMA_MAKE_PROFILER_CALLS
    ProfilerInit(collectDetailed, bestTimeBase, 5000, 100);
#endif // POOMA_MAKE_PROFILER_CALLS
  }

  inline void finalize()
  {
#if POOMA_MAKE_PROFILER_CALLS
    ProfilerDump("\pPooma.prof");
    ProfilerTerm();
#endif // POOMA_MAKE_PROFILER_CALLS
  }

}} // namespace Pooma { namespace CodeWarrior {

#endif  // POOMA_PREFIX_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: Pooma.prefix.h,v $   $Author: swhaney $
// $Revision: 1.40 $   $Date: 2000/05/31 02:32:56 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
