// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
//
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without
// charge, provided that this Notice and any statement of authorship are
// reproduced on all copies.  Neither the Government nor the University
// makes any warranty, express or implied, or assumes any liability or
// responsibility for the use of this SOFTWARE.
//
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
//
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

//-----------------------------------------------------------------------------
// Test of ReduceOverContexts<T, ReductionOp>
//-----------------------------------------------------------------------------

// Include files

#include "PETE/PETE.h" // seems like overkill...
#include "Tulip/ReduceOverContexts.h"
#include "Tulip/RemoteProxy.h"
#include "Utilities/Tester.h"

#include <vector>

#define BARRIER

#ifndef BARRIER
# if POOMA_CHEETAH
#  define BARRIER Pooma::controller()->barrier()
# else
#  define BARRIER
# endif
#endif

int main(int argc, char *argv[])
{
  Pooma::initialize(argc, argv);
  Pooma::Tester tester(argc, argv);

  const int numContexts = Pooma::contexts();
  const int myContext   = Pooma::context();

  tester.out() << "Sum test #1" << std::endl;

  typedef ReduceOverContexts<int, OpAddAssign> SumReduction_t;

  std::vector<int> foo(numContexts);

  for (int i = 0; i < numContexts; ++i)
    foo[i] = 3;

  int result1;

  SumReduction_t(foo[myContext]).broadcast(result1);  

  BARRIER;

  tester.out().setOutputContext(0);
  tester.out() << "This should print three times the number of contexts,"
               << std::endl << "or " << 3*numContexts 
               << ", on all contexts." << std::endl;

  tester.check(result1 == 3*numContexts);

  BARRIER;

  tester.out().setOutputContext(Inform::allContexts);
  tester.out() << result1 << std::endl;

  BARRIER;

  tester.out().setOutputContext(0);

  tester.out() << "Sum test #2" << std::endl;

  std::vector<int> ans(numContexts);
  for (int i = 0; i < numContexts; i++)
    ans[i] = i + 1;

  tester.out() << "This should print context number plus one on each context."
               << std::endl;

  BARRIER;

  tester.out().setOutputContext(Inform::allContexts);
  tester.out() << ans[myContext] << std::endl;

  BARRIER;

  tester.out().setOutputContext(0);
  tester.out() << "Now reduce the values on contexts 0 and 1 only." 
               << std::endl;

  SumReduction_t reduce(ans[myContext], 0, myContext < 2);

  if (myContext == 0)
    ans[0] = reduce;

  BARRIER;

  RemoteProxy<int> broadcast(ans[myContext], 0);
  int final = broadcast;

  BARRIER;

  tester.out().setOutputContext(Inform::allContexts);
  tester.out() << final << std::endl;

  BARRIER;

  tester.check(final == (numContexts > 1 ? 3 : 1));

  int ret = tester.results("ReduceOverContexts Test");

  Pooma::finalize();

  return ret;
}

