// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

//-----------------------------------------------------------------------------
// Class:
// SmartsTag_t
//-----------------------------------------------------------------------------

#ifndef POOMA_THREADS_SCHEDULER_H
#define POOMA_THREADS_SCHEDULER_H

//////////////////////////////////////////////////////////////////////

//-----------------------------------------------------------------------------
// Overview:
//
// This file exist to wrap the correct includes from Smarts based on the
// scheduler that we've selected.  If we're running in serial then we include
// the a stub file.  This file defines a single typedef: SmartsTag_t, a policy
// tag which is used to select the appropriate smarts data object etc.
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Includes:
//-----------------------------------------------------------------------------

#include "Pooma/Configuration.h"

//-----------------------------------------------------------------------------
// First include the appropriate Smarts scheduler file and define 
// the scheduler policy tag and identification string appropriate
// to the particular choice of scheduler.
//-----------------------------------------------------------------------------

#if POOMA_THREADS

// Set up to use the proper scheduler.  One of the following blocks will
// end up being included.

# if POOMA_SMARTS_SCHEDULER_ASYNC

#  include "Smarts.h"
#  include "IterateSchedulers/FastAsyncScheduler.h"

namespace Pooma {
  typedef Smarts::FastAsync SmartsTag_t;
}

# elif POOMA_SMARTS_SCHEDULER_MCVE_MULTIQ

#   include "Smarts.h"
#   include "IterateSchedulers/MCVE_MultiQ.h"

namespace Pooma {
  typedef Smarts::MCVE_MultiQ SmartsTag_t;
}

# else

#  include "Utilities/PAssert.h"
CTAssert(YOU_HAVE_NOT_SELECTED_A_SCHEDULER);

# endif

#else

# if POOMA_SMARTS_SCHEDULER_SERIALASYNC

#  include "Threads/IterateSchedulers/SerialAsync.h"

namespace Pooma {
  typedef Smarts::SerialAsync SmartsTag_t;
}

# else

// Set up a stub version of the Smarts interface for use in just serial runs

#  include "SmartsStubs.h"

namespace Pooma {
  typedef Smarts::Stub SmartsTag_t;
}

# endif

#endif

#endif     // POOMA_THREADS_SCHEDULER_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: Scheduler.h,v $   $Author: luchini $
// $Revision: 1.7 $   $Date: 2000/05/05 07:44:53 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
