// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

#ifndef POOMA_THREADS_POOMA_SMARTS_H
#define POOMA_THREADS_POOMA_SMARTS_H

//-----------------------------------------------------------------------------
// Types:
//   Pooma::SmartsTag_t
//   Pooma::Scheduler_t
//   Pooma::DataObject_t
//   Pooma::Iterate_t
// 
// Global Data:
//   Pooma::schedulerVersion
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Overview: 
// The POOMA wrapper around defines, includes, and typedefs for the Smarts
// run-time evaluation system.  Based on the settings of POOMA_THREADS and
// the selected scheduler, define several typedefs and include the necessary
// files.  If we're compiling only for serial runs, use a stub version of
// the Smarts interface instead.
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Includes:
//-----------------------------------------------------------------------------

#include "Threads/Scheduler.h"

// Given the scheduler policy tag, we can now define the types of the
// scheduler, dataobject, and iterate:

namespace Pooma {

static const char schedulerVersion[] = POOMA_SCHEDULER_NAME;

typedef Smarts::IterateScheduler<SmartsTag_t> Scheduler_t;
typedef Smarts::DataObject<SmartsTag_t>       DataObject_t;
typedef Smarts::Iterate<SmartsTag_t>          Iterate_t;

typedef Smarts::Runnable                      Runnable_t;
inline void addRunnable(Runnable_t *runnable)
{
  Smarts::add(runnable);
}

} // namespace Pooma


//////////////////////////////////////////////////////////////////////

#endif     // POOMA_THREADS_POOMA_SMARTS_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: PoomaSmarts.h,v $   $Author: luchini $
// $Revision: 1.16 $   $Date: 2000/05/05 07:44:53 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
