// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

#ifndef POOMA_POOMA_FIELDS_H
#define POOMA_POOMA_FIELDS_H

//-----------------------------------------------------------------------------
// A one-stop-shopping header file that sets up everything one needs to use
// all POOMA Fields (and, by inclusion of Arrays.h, Arrays).
//-----------------------------------------------------------------------------

// Include files

// Arrays:
#include "Pooma/Arrays.h"

// Field class:
#include "Field/Field.h"

// FieldStencil classes:
#include "Field/FieldStencil.h"
#include "Field/WeightedFieldStencil.h"

// Geometry, including meshes, and differential operators
#include "Geometry/DiscreteGeometry.URM.h"
#include "Field/DiffOps/Div.URM.h"
#include "Field/DiffOps/Grad.URM.h"
#include "Field/DiffOps/Average.LRM.h"
#include "Geometry/DiscreteGeometry.RM.h"
#include "Field/DiffOps/Div.RM.h"
#include "Field/DiffOps/Grad.RM.h"
#include "Meshes/MeshView.RM.h"
#include "Meshes/MeshView.URM.h"
#include "Geometry/DiscreteGeometry.MeshView.h"

// Boundary Conditions:
#include "BConds/BCond.h"
#include "BConds/BCondBase.h"
#include "BConds/FieldBCondBase.h"
#include "BConds/BCondList.h"
#include "BConds/ComponentBC.h"
#include "BConds/ZeroFaceBC.h"
#include "BConds/ConstantFaceBC.h"
#include "BConds/PeriodicFaceBC.h"
#include "BConds/LinExtrapFaceBC.h"
#include "BConds/PosReflectFaceBC.h"
#include "BConds/NegReflectFaceBC.h"

// Other stuff:
#include "Field/FieldFunctions.h"

#endif // POOMA_POOMA_FIELDS_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: Fields.h,v $   $Author: swhaney $
// $Revision: 1.10 $   $Date: 2000/03/07 13:18:02 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
