// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

#ifndef POOMA_POOMA_DOMAINS_H
#define POOMA_POOMA_DOMAINS_H

//-----------------------------------------------------------------------------
// A one-stop-shopping header file that sets up everything one needs to use
// all Pooma II domain objects and functions.
//-----------------------------------------------------------------------------

// Include files for the basic user domain types

#include "Domain/Loc.h"
#include "Domain/Interval.h"
#include "Domain/Range.h"
#include "Domain/Grid.h"
#include "Domain/Region.h"

// Include files for the wildcard domain types

#include "Domain/AllDomain.h"
#include "Domain/LeftDomain.h"
#include "Domain/RightDomain.h"

// Include files for the domain calculus routines

#include "Domain/Split.h"
#include "Domain/Contains.h"
#include "Domain/Intersect.h"
#include "Domain/Touches.h"
#include "Domain/EquivSubset.h"

#endif

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: Domains.h,v $   $Author: swhaney $
// $Revision: 1.3 $   $Date: 2000/03/07 13:18:01 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
