// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license
//-----------------------------------------------------------------------------
// Particle bench 1: SpatialLayout, MP(Dynamic) Attrib, URM+MP(UG,Brick) Field
//-----------------------------------------------------------------------------

#include "particle_tests.h"


//-----------------------------------------------------------------------------
// The main routine for this benchmark code
//-----------------------------------------------------------------------------

int main(int argc, char *argv[])
{
  // Initialize POOMA and output stream, using Tester class

  startParticleTest(argc, argv,
    "SpatialLayout Benchmark: A=MP(Dynamic), F=URM+MP(Uniform,Brick)");

  // Typedefs for what we are simulating here.

#if POOMA_CHEETAH
  typedef MultiPatch< DynamicTag, Remote<Dynamic> >    AttrEngineTag_t;
  typedef MultiPatch< UniformTag, Remote<Brick> >      FieldEngineTag_t;
#else
  typedef MultiPatch<DynamicTag, Dynamic>              AttrEngineTag_t;
  typedef MultiPatch<UniformTag, Brick>                FieldEngineTag_t;
#endif
  typedef UniformRectilinearMesh<2>                    Mesh_t;
  typedef Vert                                         Centering_t;

  typedef DiscreteGeometry<Centering_t, Mesh_t>        Geometry_t;
  typedef Field<Geometry_t, double, FieldEngineTag_t>  Field_t;
  typedef Field_t::Layout_t                            FieldLayout_t;
  typedef SpatialLayout<Geometry_t, FieldLayout_t>     ParLayout_t;
  typedef TestParTraits<AttrEngineTag_t, ParLayout_t>  ParTraits_t;
  typedef ParLayout_t::PointType_t                     PointType_t;

  // Specify the mesh parameters.

  Interval<2> meshDomain(12, 24);
  PointType_t meshOrigin(1.0, 2.0);
  PointType_t meshSpacing(0.5, 0.5);

  // Create a Mesh and Geometry.

  Mesh_t mesh(meshDomain, meshOrigin, meshSpacing);
  Geometry_t geometry(mesh);

  // Let things catch up

  Pooma::blockAndEvaluate();

  // The size of the mesh.

  Region<2,double> box;
  for (int d=0; d < 2; ++d)
    box[d] = Region<1>(meshOrigin(d),
		       meshOrigin(d) + 0.5 * (meshDomain[d].length() - 1));

  // Create a FieldLayout object.  We don't actually need a Field in
  // this example, though, just the layout.

  Loc<2> blocks(3, 4);
#if POOMA_CHEETAH
  FieldLayout_t flayout(geometry.physicalDomain(), blocks, DistributedTag());
#else
  FieldLayout_t flayout(geometry.physicalDomain(), blocks, ReplicatedTag());
#endif

  // Create a particle layout object.

  ParLayout_t layout(geometry, flayout);

  // Create a Particles object, using our special subclass.

  TestParticles<ParTraits_t> P(layout);

  // Run the benchmark.

  runParticleBenchmark(argc, argv, P, box);

  // Return resulting error code and exit

  return endParticleTest(
    "SpatialLayout Benchmark: A=MP(Dynamic), F=URM+MP(Uniform,Brick)");
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: particle_bench1.cpp,v $   $Author: julianc $
// $Revision: 1.8 $   $Date: 2000/07/14 22:55:19 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
