// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

//-----------------------------------------------------------------------------
// Class:
// **CLASSNAME**
//-----------------------------------------------------------------------------

#ifndef POOMA_MESHES_MESHBC_H
#define POOMA_MESHES_MESHBC_H

//////////////////////////////////////////////////////////////////////

//-----------------------------------------------------------------------------
// Overview: 
// Management of mesh boundary condition types
//-----------------------------------------------------------------------------

// Enumeration used for specifying mesh boundary conditions. Mesh BC are used
// for things like figuring out how to return the mesh spacing for a cell 
// beyond the edge of the physical mesh, as might arise in stencil operations
// on Fields on the mesh.
enum MeshBC { linearExtrapolate, periodic, reflective }; 

#endif     // POOMA_MESHES_MESHBC_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: MeshBC.h,v $   $Author: swhaney $
// $Revision: 1.4 $   $Date: 2000/03/07 13:17:40 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
