// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

//-----------------------------------------------------------------------------
// Includes
//-----------------------------------------------------------------------------
#include "IO/LayoutIO.h"
//-----------------------------------------------------------------------------
// IO size function for DynamicLayout
//-----------------------------------------------------------------------------

int serialSizeof(const DynamicLayout& layout){
  int nBytes=0;

  // Acquire necessary state objects.
  // Acquire the domain.
  const DynamicLayout::Domain_t& dom= layout.domain();

  // Acquire the list of nodes.
  typedef DynamicLayout::List_t List_t;
  List_t nodeList= layout.nodeListGlobal();
  int listSize= nodeList.size();

  // Calculate the sizes.
  // Size the domain.
  nBytes+= serialSizeof(dom);

  // Size the node list.
  nBytes+= sizeof(int);
  List_t::iterator listIter= nodeList.begin();
  DynamicLayout::Value_t* node;
  for(int i=0;i<listSize;i++){
    node= *listIter;
    nBytes+= serialSizeof(*node);
  }

  return nBytes;
}

