#include "Pooma/Pooma.h"
#include "Array/Array.h"
#include "Geometry/DiscreteGeometry.URM.h"
#include "Utilities/Tester.h"

#include <iostream>

int main(int argc, char *argv[])
{
  Pooma::initialize(argc, argv);
  
  Interval<1> I(4);
  UniformRectilinearMesh<2> mesh(I, I);

  // 2D Cell centering, one guard layer in DiscreteGeometry
  DiscreteGeometry<Cell, UniformRectilinearMesh<2> > geomC(mesh, GuardLayers<2>(1));
  std::cout << "======= geomC.x() =======" << std::endl;
  std::cout << geomC.x() << std::endl;
  
  // 2D vector-face centering:
  typedef RectilinearCentering<2,VectorFaceRCTag<2> > Centering_t;
  DiscreteGeometry<Centering_t, UniformRectilinearMesh<2> > geomVF(mesh);
  
  int NComponents = 2;
  for (int c = 0; c < NComponents; c++) {
    std::cout << "======= geomVF.x().comp(" << c << ") =======" << std::endl;
    std::cout << geomVF.x().comp(c) << std::endl;
  }

  // For centering something like 2D Tensors on y-edges:
  typedef RectilinearCentering<2,EdgeRCTag<1> > 
    Centering2_t;
  DiscreteGeometry<Centering2_t, UniformRectilinearMesh<2> > geomE(mesh);
  
  std::cout << "======= geomE.x() =======" << std::endl
	    << geomE.x() << std::endl;
  
  Pooma::finalize();

  return 0;
}
