// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

//-----------------------------------------------------------------------------
// Field test 11: Field::initialize() of a Field with ComponentBCs
// (code supplied by N. Botta on 10/22/99).
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Includes:
//-----------------------------------------------------------------------------

#include "Pooma/Fields.h"
#include "Utilities/Tester.h"

//-----------------------------------------------------------------------------
// Test function
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Main program
//-----------------------------------------------------------------------------

int main(int argc, char* argv[]) 
{
  Pooma::initialize(argc,argv);
  Pooma::Tester tester(argc, argv);

  typedef UniformRectilinearMesh<2> Mesh;

  typedef DiscreteGeometry<Cell, Mesh> Geometry;

  const int nx = 5;
  const int ny = 5;
  const Interval<1> I(nx);
  const Interval<1> J(ny);
  const double lx  = 1;
  const double ly  = 1;
  const double dx = lx / (I.size() - 1);
  const double dy = ly / (J.size() - 1);
  const double ox = -0.5;
  const double oy = -0.5;   

  Mesh mesh(Interval<2>(I,J), Vector<2>(ox,oy), Vector<2>(dx,dy));

  Geometry geometry(mesh, GuardLayers<2>(1));

  Field<Geometry, Vector<4> > var(geometry);
  var = Vector<4>(1.0,2.0,3.0,4.0);

  // the boundary conditions
  typedef ComponentBC<1,NegReflectFaceBC> NegReflect;
  typedef ComponentBC<1,PosReflectFaceBC> PosReflect;
  // x direction left face
  var.addBoundaryCondition(PosReflect(0, 0)); 
  var.addBoundaryCondition(PosReflect(1, 0));
  var.addBoundaryCondition(PosReflect(2, 0));
  var.addBoundaryCondition(PosReflect(3, 0));
  // x direction right face
  var.addBoundaryCondition(PosReflect(0, 1));
  var.addBoundaryCondition(NegReflect(1, 1));
  var.addBoundaryCondition(PosReflect(2, 1));
  var.addBoundaryCondition(PosReflect(3, 1));
  // y direction bottom face
  var.addBoundaryCondition(PosReflect(0, 2));
  var.addBoundaryCondition(PosReflect(1, 2));
  var.addBoundaryCondition(PosReflect(2, 2));
  var.addBoundaryCondition(PosReflect(3, 2));
  // y direction top face
  var.addBoundaryCondition(PosReflect(0, 3));
  var.addBoundaryCondition(PosReflect(1, 3));
  var.addBoundaryCondition(NegReflect(2, 3));
  var.addBoundaryCondition(PosReflect(3, 3));
  
  var.applyBoundaryConditions();
  tester.out() << var.all() << std::endl;

  Field<Geometry, Vector<4> > v;

  v.initialize(var.geometry(), var.bconds());
    
  int ret = tester.results("field_test11");
  Pooma::finalize();
  return ret;
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: field_test11.cpp,v $   $Author: swhaney $
// $Revision: 1.3 $   $Date: 2000/03/07 13:17:15 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
