// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license
//-----------------------------------------------------------------------------
// ump_test3
//-----------------------------------------------------------------------------

#include "Pooma/Pooma.h"
#include "Pooma/UMPArrays.h"
#include "Utilities/Tester.h"

int main(int argc, char *argv[])
{
  Pooma::initialize(argc,argv);
  Pooma::Tester tester(argc,argv);

  // Create the total domain.
  
  const int N = 40;
  Interval<1> D(1, N);
  Interval<2> domain(D, D);
  Interval<1> I(2, N-1), J(2, N-1), X(N/2 - 4, N/2 + 4);
  
  // Create the block sizes.
  
  Loc<2> blocks(2,2);

  // Create the partitioners.
  
  UniformGridPartition<2> partition(blocks);
  
  // Create the layout.
  
  UniformGridLayout<2> layout(domain, partition, ReplicatedTag());
  
  // Make some UMP arrays and fill them.
  
  Array<2, double, MultiPatch<UniformTag,Brick> > a(layout), b(layout);
  a = 0;
  b = 0;
  b(N/2, N/2) = 1000;
  
  tester.out() << a(X,X) << std::endl;
  tester.out() << b(X,X) << std::endl;

  a(I,J) = (1.0 / 9.0) *
    (b(I+1,J+1) + b(I+1,J  ) + b(I+1,J-1) +
     b(I  ,J+1) + b(I  ,J  ) + b(I  ,J-1) +
     b(I-1,J+1) + b(I-1,J  ) + b(I-1,J-1));
     
  tester.out() << a(X,X) << std::endl;

  int ret = tester.results("ump_test3");
  Pooma::finalize();
  return ret;
}
	     
// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: ump_test3.cpp,v $   $Author: luchini $
// $Revision: 1.12 $   $Date: 2000/05/31 21:49:12 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
